/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.laf.AbstractUIInputListener;
import com.alee.laf.UIAction;
import com.alee.laf.UIActionMap;
import com.alee.laf.desktoppane.DesktopPaneInputListener;
import com.alee.laf.desktoppane.WDesktopPaneUI;
import com.alee.utils.LafLookup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import javax.swing.InputMap;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WDesktopPaneInputListener<C extends JDesktopPane, U extends WDesktopPaneUI<C>>
extends AbstractUIInputListener<C, U>
implements DesktopPaneInputListener<C> {
    @Override
    public void install(@NotNull C component) {
        super.install(component);
        UIActionMap actionMap = new UIActionMap();
        actionMap.put(new Action<C>(component, "restore"));
        actionMap.put(new Action<C>(component, "close"));
        actionMap.put(new Action<C>(component, "move"));
        actionMap.put(new Action<C>(component, "resize"));
        actionMap.put(new Action<C>(component, "left"));
        actionMap.put(new Action<C>(component, "shrinkLeft"));
        actionMap.put(new Action<C>(component, "right"));
        actionMap.put(new Action<C>(component, "shrinkRight"));
        actionMap.put(new Action<C>(component, "up"));
        actionMap.put(new Action<C>(component, "shrinkUp"));
        actionMap.put(new Action<C>(component, "down"));
        actionMap.put(new Action<C>(component, "shrinkDown"));
        actionMap.put(new Action<C>(component, "escape"));
        actionMap.put(new Action<C>(component, "minimize"));
        actionMap.put(new Action<C>(component, "maximize"));
        actionMap.put(new Action<C>(component, "selectNextFrame"));
        actionMap.put(new Action<C>(component, "selectPreviousFrame"));
        actionMap.put(new Action<C>(component, "navigateNext"));
        actionMap.put(new Action<C>(component, "navigatePrevious"));
        SwingUtilities.replaceUIActionMap(component, actionMap);
        InputMap focusedWindowInputMap = LafLookup.getInputMap(component, 2);
        SwingUtilities.replaceUIInputMap(component, 2, focusedWindowInputMap);
        InputMap focusedAncestorInputMap = LafLookup.getInputMap(component, 1);
        SwingUtilities.replaceUIInputMap(component, 1, focusedAncestorInputMap);
    }

    @Override
    public void uninstall(@NotNull C component) {
        SwingUtilities.replaceUIInputMap(component, 1, null);
        SwingUtilities.replaceUIInputMap(component, 2, null);
        SwingUtilities.replaceUIActionMap(component, null);
        super.uninstall(component);
    }

    public static class Action<D extends JDesktopPane>
    extends UIAction<D> {
        public static final String CLOSE = "close";
        public static final String ESCAPE = "escape";
        public static final String MAXIMIZE = "maximize";
        public static final String MINIMIZE = "minimize";
        public static final String MOVE = "move";
        public static final String RESIZE = "resize";
        public static final String RESTORE = "restore";
        public static final String LEFT = "left";
        public static final String RIGHT = "right";
        public static final String UP = "up";
        public static final String DOWN = "down";
        public static final String SHRINK_LEFT = "shrinkLeft";
        public static final String SHRINK_RIGHT = "shrinkRight";
        public static final String SHRINK_UP = "shrinkUp";
        public static final String SHRINK_DOWN = "shrinkDown";
        public static final String NEXT_FRAME = "selectNextFrame";
        public static final String PREVIOUS_FRAME = "selectPreviousFrame";
        public static final String NAVIGATE_NEXT = "navigateNext";
        public static final String NAVIGATE_PREVIOUS = "navigatePrevious";
        private static final int MOVE_RESIZE_INCREMENT = 10;
        private static boolean moving = false;
        private static boolean resizing = false;
        private static JInternalFrame sourceFrame = null;
        private static Component focusOwner = null;

        public Action(@NotNull D desktop, @NotNull String name) {
            super(desktop, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(@NotNull ActionEvent e) {
            FocusTraversalPolicy policy;
            Container cycleRoot;
            JDesktopPane desktop = (JDesktopPane)this.getComponent();
            String action = this.getName();
            if (Objects.equals((Object)action, (Object)CLOSE)) {
                JInternalFrame internalFrame = desktop.getSelectedFrame();
                if (internalFrame != null) {
                    internalFrame.doDefaultCloseAction();
                }
            } else if (Objects.equals((Object)action, (Object)MAXIMIZE)) {
                JInternalFrame internalFrame = desktop.getSelectedFrame();
                if (internalFrame != null && !internalFrame.isMaximum()) {
                    if (internalFrame.isIcon()) {
                        try {
                            internalFrame.setIcon(false);
                            internalFrame.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            internalFrame.setMaximum(true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                }
            } else if (Objects.equals((Object)action, (Object)MINIMIZE)) {
                JInternalFrame internalFrame = desktop.getSelectedFrame();
                if (internalFrame != null && !internalFrame.isIcon()) {
                    try {
                        internalFrame.setIcon(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else if (Objects.equals((Object)action, (Object)RESTORE)) {
                JInternalFrame internalFrame = desktop.getSelectedFrame();
                if (internalFrame != null) {
                    try {
                        if (internalFrame.isIcon()) {
                            internalFrame.setIcon(false);
                        } else if (internalFrame.isMaximum()) {
                            internalFrame.setMaximum(false);
                        }
                        internalFrame.setSelected(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else if (Objects.equals((Object)action, (Object)ESCAPE)) {
                if (sourceFrame == desktop.getSelectedFrame() && focusOwner != null) {
                    focusOwner.requestFocus();
                }
                moving = false;
                resizing = false;
                sourceFrame = null;
                focusOwner = null;
            } else if (Objects.equals((Object)action, (Object[])new Object[]{MOVE, RESIZE})) {
                sourceFrame = desktop.getSelectedFrame();
                if (sourceFrame != null) {
                    moving = Objects.equals((Object)action, (Object)MOVE);
                    resizing = Objects.equals((Object)action, (Object)RESIZE);
                    focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                    if (!SwingUtilities.isDescendingFrom(focusOwner, sourceFrame)) {
                        focusOwner = null;
                    }
                    sourceFrame.requestFocus();
                }
            } else if (Objects.equals((Object)action, (Object[])new Object[]{LEFT, RIGHT, UP, DOWN, SHRINK_RIGHT, SHRINK_LEFT, SHRINK_UP, SHRINK_DOWN})) {
                JInternalFrame internalFrame = desktop.getSelectedFrame();
                if (sourceFrame != null && internalFrame == sourceFrame && KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() == sourceFrame) {
                    Insets minOnScreenInsets = UIManager.getInsets("Desktop.minOnScreenInsets");
                    Dimension size = internalFrame.getSize();
                    Dimension minSize = internalFrame.getMinimumSize();
                    int dpWidth = desktop.getWidth();
                    int dpHeight = desktop.getHeight();
                    Point loc = internalFrame.getLocation();
                    if (Objects.equals((Object)action, (Object)LEFT)) {
                        if (moving) {
                            internalFrame.setLocation(loc.x + size.width - 10 < minOnScreenInsets.right ? -size.width + minOnScreenInsets.right : loc.x - 10, loc.y);
                        } else if (resizing) {
                            internalFrame.setLocation(loc.x - 10, loc.y);
                            internalFrame.setSize(size.width + 10, size.height);
                        }
                    } else if (Objects.equals((Object)action, (Object)RIGHT)) {
                        if (moving) {
                            internalFrame.setLocation(loc.x + 10 > dpWidth - minOnScreenInsets.left ? dpWidth - minOnScreenInsets.left : loc.x + 10, loc.y);
                        } else if (resizing) {
                            internalFrame.setSize(size.width + 10, size.height);
                        }
                    } else if (Objects.equals((Object)action, (Object)UP)) {
                        if (moving) {
                            internalFrame.setLocation(loc.x, loc.y + size.height - 10 < minOnScreenInsets.bottom ? -size.height + minOnScreenInsets.bottom : loc.y - 10);
                        } else if (resizing) {
                            internalFrame.setLocation(loc.x, loc.y - 10);
                            internalFrame.setSize(size.width, size.height + 10);
                        }
                    } else if (Objects.equals((Object)action, (Object)DOWN)) {
                        if (moving) {
                            internalFrame.setLocation(loc.x, loc.y + 10 > dpHeight - minOnScreenInsets.top ? dpHeight - minOnScreenInsets.top : loc.y + 10);
                        } else if (resizing) {
                            internalFrame.setSize(size.width, size.height + 10);
                        }
                    } else if (Objects.equals((Object)action, (Object)SHRINK_LEFT) && resizing) {
                        int delta = minSize.width < size.width - 10 ? 10 : size.width - minSize.width;
                        if (loc.x + size.width - delta < minOnScreenInsets.left) {
                            delta = loc.x + size.width - minOnScreenInsets.left;
                        }
                        internalFrame.setSize(size.width - delta, size.height);
                    } else if (Objects.equals((Object)action, (Object)SHRINK_RIGHT) && resizing) {
                        int delta = minSize.width < size.width - 10 ? 10 : size.width - minSize.width;
                        if (loc.x + delta > dpWidth - minOnScreenInsets.right) {
                            delta = dpWidth - minOnScreenInsets.right - loc.x;
                        }
                        internalFrame.setLocation(loc.x + delta, loc.y);
                        internalFrame.setSize(size.width - delta, size.height);
                    } else if (Objects.equals((Object)action, (Object)SHRINK_UP) && resizing) {
                        int delta = minSize.height < size.height - 10 ? 10 : size.height - minSize.height;
                        if (loc.y + size.height - delta < minOnScreenInsets.bottom) {
                            delta = loc.y + size.height - minOnScreenInsets.bottom;
                        }
                        internalFrame.setSize(size.width, size.height - delta);
                    } else if (Objects.equals((Object)action, (Object)SHRINK_DOWN) && resizing) {
                        int delta = minSize.height < size.height - 10 ? 10 : size.height - minSize.height;
                        if (loc.y + delta > dpHeight - minOnScreenInsets.top) {
                            delta = dpHeight - minOnScreenInsets.top - loc.y;
                        }
                        internalFrame.setLocation(loc.x, loc.y + delta);
                        internalFrame.setSize(size.width, size.height - delta);
                    }
                }
            } else if (Objects.equals((Object)action, (Object[])new Object[]{NEXT_FRAME, PREVIOUS_FRAME})) {
                desktop.selectFrame(Objects.equals((Object)action, (Object)NEXT_FRAME));
            } else if (Objects.equals((Object)action, (Object[])new Object[]{NAVIGATE_NEXT, NAVIGATE_PREVIOUS}) && (cycleRoot = desktop.getFocusCycleRootAncestor()) != null && (policy = cycleRoot.getFocusTraversalPolicy()) != null && policy instanceof SortingFocusTraversalPolicy) {
                SortingFocusTraversalPolicy sPolicy = (SortingFocusTraversalPolicy)policy;
                boolean idc = sPolicy.getImplicitDownCycleTraversal();
                try {
                    sPolicy.setImplicitDownCycleTraversal(false);
                    if (Objects.equals((Object)action, (Object)NAVIGATE_NEXT)) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(desktop);
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(desktop);
                    }
                }
                finally {
                    sPolicy.setImplicitDownCycleTraversal(idc);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            JInternalFrame internalFrame;
            JDesktopPane desktop = (JDesktopPane)this.getComponent();
            String action = this.getName();
            boolean enabled = Objects.equals((Object)action, (Object[])new Object[]{NEXT_FRAME, PREVIOUS_FRAME}) ? true : ((internalFrame = desktop.getSelectedFrame()) == null ? false : (Objects.equals((Object)action, (Object)CLOSE) ? internalFrame.isClosable() : (Objects.equals((Object)action, (Object)MINIMIZE) ? internalFrame.isIconifiable() : (Objects.equals((Object)action, (Object)MAXIMIZE) ? internalFrame.isMaximizable() : true))));
            return enabled;
        }
    }
}

