/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.desktoppane;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.laf.WebUI;
import com.alee.laf.desktoppane.DesktopPaneInputListener;
import com.alee.laf.desktoppane.WDesktopPaneInputListener;
import com.alee.laf.desktoppane.WebDesktopManager;
import com.alee.utils.LafUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;

public abstract class WDesktopPaneUI<C extends JDesktopPane>
extends DesktopPaneUI
implements WebUI<C> {
    protected PropertyChangeListener propertyChangeListener;
    protected DesktopPaneInputListener<C> inputListener;
    protected C desktop;
    protected DesktopManager desktopManager;

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "Desktop.";
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.desktop = (JDesktopPane)c;
        this.installDesktopManager();
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallDesktopManager();
        this.desktop = null;
    }

    protected void installDesktopManager() {
        this.desktopManager = ((JDesktopPane)this.desktop).getDesktopManager();
        if (this.desktopManager == null) {
            this.desktopManager = new WebDesktopManager.UIResource();
            ((JDesktopPane)this.desktop).setDesktopManager(this.desktopManager);
        }
    }

    protected void uninstallDesktopManager() {
        if (((JDesktopPane)this.desktop).getDesktopManager() instanceof UIResource) {
            ((JDesktopPane)this.desktop).setDesktopManager(null);
        }
        this.desktopManager = null;
    }

    protected void installDefaults() {
        LafUtils.installDefaults(this.desktop, this.getPropertyPrefix());
    }

    protected void uninstallDefaults() {
        LafUtils.uninstallDefaults(this.desktop);
    }

    protected void installListeners() {
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String prop = evt.getPropertyName();
                if (Objects.equals((Object)prop, (Object)"desktopManager")) {
                    WDesktopPaneUI.this.installDesktopManager();
                }
            }
        };
        ((Container)this.desktop).addPropertyChangeListener(this.propertyChangeListener);
        this.inputListener = this.createDesktopPaneInputListener();
        this.inputListener.install(this.desktop);
    }

    protected void uninstallListeners() {
        this.inputListener.uninstall(this.desktop);
        this.inputListener = null;
        ((Component)this.desktop).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected DesktopPaneInputListener<C> createDesktopPaneInputListener() {
        return new WDesktopPaneInputListener();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return null;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }
}

