/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.filechooser;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.filechooser.FileChooserListener;
import com.alee.laf.filechooser.FileChooserType;
import com.alee.laf.filechooser.FileSelectionMode;
import com.alee.laf.filechooser.WFileChooserUI;
import com.alee.laf.filechooser.WebFileChooserPanel;
import com.alee.managers.language.LM;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.FileUtils;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.filefilter.AllFilesFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;

public class WebFileChooserUI
extends WFileChooserUI {
    protected transient JFileChooser fileChooser;
    protected transient WebFileView fileView;
    protected transient WebFileChooserPanel fileChooserPanel;
    protected transient boolean ignoreFileSelectionChanges = false;
    protected transient PropertyChangeListener propertyChangeListener;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebFileChooserUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.fileChooser = (JFileChooser)c;
        StyleManager.installSkin(this.fileChooser);
        this.fileView = new WebFileView();
        this.fileChooser.setLayout(new BorderLayout());
        this.fileChooserPanel = this.createPanel(this.fileChooser);
        this.fileChooserPanel.setFileSelectionMode(FileSelectionMode.get(this.fileChooser.getFileSelectionMode()));
        this.fileChooserPanel.setMultiSelectionEnabled(this.fileChooser.isMultiSelectionEnabled());
        this.fileChooserPanel.setShowHiddenFiles(!this.fileChooser.isFileHidingEnabled());
        this.fileChooserPanel.setAcceptListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebFileChooserUI.this.ignoreFileSelectionChanges = true;
                List<File> selectedFiles = WebFileChooserUI.this.fileChooserPanel.getSelectedFiles();
                WebFileChooserUI.this.fileChooser.setSelectedFiles(selectedFiles.toArray(new File[selectedFiles.size()]));
                WebFileChooserUI.this.ignoreFileSelectionChanges = false;
                WebFileChooserUI.this.fileChooser.approveSelection();
            }
        });
        this.fileChooserPanel.setCancelListener(new ActionListener(){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                WebFileChooserUI.this.fileChooser.cancelSelection();
            }
        });
        this.fileChooserPanel.addFileChooserListener(new FileChooserListener(){

            @Override
            public void directoryChanged(File newDirectory) {
                WebFileChooserUI.this.ignoreFileSelectionChanges = true;
                WebFileChooserUI.this.fileChooser.setCurrentDirectory(newDirectory);
                WebFileChooserUI.this.ignoreFileSelectionChanges = false;
            }

            @Override
            public void selectionChanged(List<File> selectedFiles) {
                WebFileChooserUI.this.ignoreFileSelectionChanges = true;
                WebFileChooserUI.this.fileChooser.setSelectedFiles(selectedFiles.toArray(new File[selectedFiles.size()]));
                WebFileChooserUI.this.ignoreFileSelectionChanges = false;
            }

            @Override
            public void fileFilterChanged(FileFilter oldFilter, FileFilter newFilter) {
                WebFileChooserUI.this.ignoreFileSelectionChanges = true;
                WebFileChooserUI.this.fileChooser.setFileFilter(FileUtils.getSwingFileFilter((AbstractFileFilter)WebFileChooserUI.this.fileChooserPanel.getActiveFileFilter()));
                WebFileChooserUI.this.ignoreFileSelectionChanges = false;
            }
        });
        this.fileChooser.add((Component)this.fileChooserPanel, "Center");
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                WebFileChooserUI.this.propertyChanged(evt);
            }
        };
        this.fileChooser.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.fileChooser);
        this.fileChooser.removePropertyChangeListener(this.propertyChangeListener);
        this.fileChooserPanel = null;
        this.fileView = null;
        this.fileChooser = null;
    }

    protected void propertyChanged(@NotNull PropertyChangeEvent event) {
        String prop = event.getPropertyName();
        if (prop.equals("AccessoryChangedProperty")) {
            this.fileChooserPanel.setAccessory((JComponent)event.getNewValue());
        } else if (prop.equals("ApproveButtonTextChangedProperty")) {
            this.fileChooserPanel.setAcceptButtonText(this.fileChooser.getApproveButtonText());
        } else if (prop.equals("ControlButtonsAreShownChangedProperty")) {
            this.fileChooserPanel.setShowControlButtons(this.fileChooser.getControlButtonsAreShown());
        } else if (prop.equals("fileFilterChanged") || prop.equals("ChoosableFileFilterChangedProperty") || prop.equals("acceptAllFileFilterUsedChanged")) {
            if (!this.ignoreFileSelectionChanges) {
                FileFilter filter = this.fileChooser.getFileFilter();
                FileFilter[] filters = this.fileChooser.getChoosableFileFilters();
                int initialCapacity = (filters != null ? filters.length : 0) + (filter != null ? 1 : 0);
                ArrayList<FileFilter> collected = new ArrayList<FileFilter>(initialCapacity);
                if (filter != null) {
                    collected.add(filter);
                }
                if (filters != null && filters.length > 0) {
                    for (FileFilter fileFilter : filters) {
                        if (collected.contains(fileFilter)) continue;
                        collected.add(fileFilter);
                    }
                }
                if (collected.size() > 0) {
                    this.fileChooserPanel.setFileFilters(collected.toArray(new FileFilter[collected.size()]));
                } else {
                    this.fileChooserPanel.setFileFilter((AbstractFileFilter)new AllFilesFilter());
                }
            }
        } else if (prop.equals("fileSelectionChanged")) {
            int mode = this.fileChooser.getFileSelectionMode();
            this.fileChooserPanel.setFileSelectionMode(FileSelectionMode.get(mode));
        } else if (prop.equals("directoryChanged")) {
            if (!this.ignoreFileSelectionChanges) {
                this.fileChooserPanel.setCurrentFolder(this.fileChooser.getCurrentDirectory());
            }
        } else if (prop.equals("SelectedFileChangedProperty")) {
            if (!this.ignoreFileSelectionChanges) {
                if (event.getNewValue() instanceof File) {
                    this.fileChooserPanel.setSelectedFile(this.fileChooser.getSelectedFile());
                } else {
                    this.fileChooserPanel.setSelectedFiles(this.fileChooser.getSelectedFiles());
                }
            }
        } else if (prop.equals("DialogTypeChangedProperty")) {
            this.fileChooserPanel.setChooserType(FileChooserType.forType(this.fileChooser.getDialogType()));
        } else if (prop.equals("FileHidingChanged")) {
            this.fileChooserPanel.setShowHiddenFiles(!this.fileChooser.isFileHidingEnabled());
        } else if (prop.equals("MultiSelectionEnabledChangedProperty")) {
            this.fileChooserPanel.setMultiSelectionEnabled(this.fileChooser.isMultiSelectionEnabled());
        } else if (prop.equals("componentOrientation")) {
            this.fileChooserPanel.applyComponentOrientation(this.fileChooser.getComponentOrientation());
        }
    }

    @NotNull
    protected WebFileChooserPanel createPanel(@NotNull JFileChooser fileChooser) {
        return new WebFileChooserPanel(FileChooserType.forType(fileChooser.getDialogType()), fileChooser.getControlButtonsAreShown());
    }

    @Override
    @NotNull
    public WebFileChooserPanel getFileChooserPanel() {
        return this.fileChooserPanel;
    }

    @Override
    public FileFilter getAcceptAllFileFilter(@NotNull JFileChooser fc) {
        return new AllFilesFilter();
    }

    @Override
    public FileView getFileView(@NotNull JFileChooser fc) {
        return this.fileView;
    }

    @Override
    public String getApproveButtonText(@NotNull JFileChooser fc) {
        return this.fileChooserPanel.getAcceptButtonText();
    }

    @Override
    public String getDialogTitle(@NotNull JFileChooser fc) {
        String dialogTitle = fc.getDialogTitle();
        return dialogTitle != null ? dialogTitle : LM.get((String)"weblaf.filechooser.title", (Object[])new Object[0]);
    }

    @Override
    public void rescanCurrentDirectory(@NotNull JFileChooser fc) {
        this.fileChooserPanel.reloadCurrentFolder();
    }

    @Override
    public void ensureFileIsVisible(@NotNull JFileChooser fc, @NotNull File f) {
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return null;
    }

    protected class WebFileView
    extends FileView {
        protected WebFileView() {
        }

        @Override
        @NotNull
        public String getName(@NotNull File f) {
            return FileUtils.getDisplayFileName((File)f);
        }

        @Override
        @NotNull
        public String getDescription(@NotNull File f) {
            return this.getTypeDescription(f);
        }

        @Override
        @NotNull
        public String getTypeDescription(@NotNull File f) {
            return FileUtils.getFileTypeDescription((File)f);
        }

        @Override
        @Nullable
        public Icon getIcon(@NotNull File f) {
            return FileUtils.getFileIcon((File)f);
        }
    }
}

