/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.grouping;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.laf.grouping.AbstractGroupingLayout;
import com.alee.laf.grouping.GridSize;
import com.alee.laf.grouping.GroupPaneConstraints;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.general.Pair;
import com.alee.utils.swing.SizeType;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingConstants;

@XStreamAlias(value="GroupPaneLayout")
public class GroupPaneLayout
extends AbstractGroupingLayout
implements SwingConstants {
    @XStreamAsAttribute
    protected int orientation;
    @XStreamAsAttribute
    protected int columns;
    @XStreamAsAttribute
    protected int rows;
    @NotNull
    protected final transient Map<Component, GroupPaneConstraints> constraints = new HashMap<Component, GroupPaneConstraints>(5);

    public GroupPaneLayout() {
        this(0, Integer.MAX_VALUE, 1);
    }

    public GroupPaneLayout(int orientation) {
        this(orientation, Integer.MAX_VALUE, 1);
    }

    public GroupPaneLayout(int columns, int rows) {
        this(0, columns, rows);
    }

    public GroupPaneLayout(int orientation, int columns, int rows) {
        this.orientation = orientation;
        this.columns = columns;
        this.rows = rows;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    @NotNull
    protected GroupPaneConstraints getDefaultConstraint() {
        return this.orientation == 0 ? GroupPaneConstraints.VERTICAL_FILL : GroupPaneConstraints.HORIZONTAL_FILL;
    }

    @Override
    public void addComponent(@NotNull Component component, @Nullable Object constraints) {
        if (constraints != null && !(constraints instanceof GroupPaneConstraints)) {
            throw new RuntimeException("Unsupported layout constraints: " + constraints);
        }
        this.constraints.put(component, constraints != null ? (GroupPaneConstraints)constraints : this.getDefaultConstraint());
        super.addComponent(component, constraints);
    }

    @Override
    public void removeComponent(@NotNull Component component) {
        super.removeComponent(component);
        this.constraints.remove(component);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        GridSize gridSize = this.getActualGridSize(container);
        Pair<int[], int[]> sizes = this.calculateSizes(container, gridSize, SizeType.current);
        Insets border = container.getInsets();
        int y = border.top;
        for (int row = 0; row < gridSize.rows; ++row) {
            int x = border.left;
            for (int column = 0; column < gridSize.columns; ++column) {
                int index = this.pointToIndex(container, column, row, gridSize);
                Component component = container.getComponent(index);
                if (component != null) {
                    component.setBounds(x, y, ((int[])sizes.key)[column], ((int[])sizes.value)[row]);
                }
                x += ((int[])sizes.key)[column];
            }
            y += ((int[])sizes.value)[row];
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        int n;
        GridSize gridSize = this.getActualGridSize(container);
        Pair<int[], int[]> sizes = this.calculateSizes(container, gridSize, SizeType.preferred);
        Dimension ps = new Dimension(0, 0);
        int[] nArray = (int[])sizes.key;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer columnWith = nArray[n];
            ps.width += columnWith.intValue();
        }
        nArray = (int[])sizes.value;
        n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer rowHeight = nArray[n];
            ps.height += rowHeight.intValue();
        }
        Insets border = container.getInsets();
        ps.width += border.left + border.right;
        ps.height += border.top + border.bottom;
        return ps;
    }

    @NotNull
    protected GridSize getActualGridSize(@NotNull Container container) {
        int count = container.getComponentCount();
        GridSize gridSize = this.orientation == 0 ? new GridSize(Math.min(count, this.columns), (count - 1) / this.columns + 1) : new GridSize((count - 1) / this.rows + 1, Math.min(count, this.rows));
        return gridSize;
    }

    @Nullable
    protected Component getComponentAt(@NotNull Container container, int column, int row) {
        int count;
        GridSize gridSize = this.getActualGridSize(container);
        int index = this.pointToIndex(container, column, row, gridSize);
        return index < (count = container.getComponentCount()) ? container.getComponent(index) : null;
    }

    protected int indexToColumn(@NotNull Container container, int index, @NotNull GridSize gridSize) {
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        int column = this.orientation == 0 ? index % this.columns : index / this.rows;
        return ltr ? column : gridSize.columns - 1 - column;
    }

    protected int indexToRow(int index) {
        return this.orientation == 0 ? index / this.columns : index % this.rows;
    }

    protected int pointToIndex(@NotNull Container container, int column, int row, @NotNull GridSize gridSize) {
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        int c = ltr ? column : gridSize.columns - 1 - column;
        return this.orientation == 0 ? row * this.columns + c : c * this.rows + row;
    }

    @NotNull
    protected Pair<int[], int[]> calculateSizes(@NotNull Container container, @NotNull GridSize gridSize, @NotNull SizeType type) {
        int row;
        int col;
        int count = container.getComponentCount();
        int cols = gridSize.columns;
        int[] colWidths = new int[cols];
        double[] colPercents = new double[cols];
        int rows = gridSize.rows;
        int[] rowHeights = new int[rows];
        double[] rowPercents = new double[rows];
        for (int i = 0; i < count; ++i) {
            Component component = container.getComponent(i);
            GroupPaneConstraints c = this.constraints.get(component);
            Dimension ps = component.getPreferredSize();
            col = this.indexToColumn(container, i, gridSize);
            row = this.indexToRow(i);
            colWidths[col] = Math.max(colWidths[col], (int)Math.floor(c.width > 1.0 ? c.width : (double)ps.width));
            colPercents[col] = Math.max(colPercents[col], 1.0 >= c.width && c.width > 0.0 ? c.width : 0.0);
            rowHeights[row] = Math.max(rowHeights[row], (int)Math.floor(c.height > 1.0 ? c.height : (double)ps.height));
            rowPercents[row] = Math.max(rowPercents[row], 1.0 >= c.height && c.height > 0.0 ? c.height : 0.0);
        }
        Dimension size = container.getSize();
        Pair<Double, Integer> rc = this.calculateSizes(cols, size.width, colWidths, colPercents);
        Pair<Double, Integer> rr = this.calculateSizes(rows, size.height, rowHeights, rowPercents);
        if (type == SizeType.current) {
            for (int i = 0; i < count; ++i) {
                col = this.indexToColumn(container, i, gridSize);
                if (colPercents[col] > 0.0 && colPercents[col] <= 1.0) {
                    int pw = (int)Math.floor((double)((Integer)rc.getValue()).intValue() * colPercents[col] / (Double)rc.getKey());
                    colWidths[col] = Math.max(pw, colWidths[col]);
                }
                if (!(rowPercents[row = this.indexToRow(i)] > 0.0) || !(rowPercents[row] <= 1.0)) continue;
                int ph = (int)Math.floor((double)((Integer)rr.getValue()).intValue() * rowPercents[row] / (Double)rr.getKey());
                rowHeights[row] = Math.max(ph, rowHeights[row]);
            }
            this.appendDelta(cols, colWidths, size.width);
            this.appendDelta(rows, rowHeights, size.height);
        }
        return new Pair((Object)colWidths, (Object)rowHeights);
    }

    @NotNull
    protected Pair<Double, Integer> calculateSizes(int count, int size, @NotNull int[] sizes, @NotNull double[] percents) {
        double freePercents;
        int freeSize;
        boolean changed;
        int[] initSizes = Arrays.copyOf(sizes, count);
        block0: do {
            int i;
            changed = false;
            double maxWeight = 0.0;
            for (i = 0; i < count; ++i) {
                if (!(percents[i] > 0.0)) continue;
                maxWeight = Math.max(maxWeight, (double)initSizes[i] / percents[i]);
            }
            for (i = 0; i < count; ++i) {
                sizes[i] = percents[i] > 0.0 ? (int)Math.floor(maxWeight * percents[i]) : initSizes[i];
            }
            freeSize = size;
            freePercents = 0.0;
            for (i = 0; i < count; ++i) {
                freeSize -= percents[i] == 0.0 ? sizes[i] : 0;
                freePercents += percents[i];
            }
            for (i = 0; i < count; ++i) {
                double availSize;
                if (!(percents[i] > 0.0) || !((double)sizes[i] > (availSize = (double)freeSize * percents[i] / freePercents)) || !((double)initSizes[i] > availSize)) continue;
                percents[i] = 0.0;
                changed = true;
                continue block0;
            }
        } while (changed);
        return new Pair((Object)freePercents, (Object)freeSize);
    }

    protected void appendDelta(int count, @NotNull int[] sizes, int size) {
        int roughColSize = 0;
        for (int i = 0; i < count; ++i) {
            roughColSize += sizes[i];
        }
        int delta = size - roughColSize;
        if (delta < count) {
            int i = count - 1;
            while (delta > 0) {
                int n = i--;
                sizes[n] = sizes[n] + 1;
                --delta;
            }
        }
    }

    @Override
    @NotNull
    public Pair<String, String> getDescriptors(@NotNull Container container, @NotNull Component component, int index) {
        boolean paintRightLine;
        boolean paintRight;
        boolean paintBottomLine;
        boolean paintBottom;
        boolean paintLeftLine;
        boolean paintLeft;
        boolean paintTopLine;
        boolean paintTop;
        GridSize gridSize = this.getActualGridSize(container);
        int row = this.indexToRow(index);
        int col = this.indexToColumn(container, index, gridSize);
        if (this.isNeighbourDecoratable(container, gridSize, col, row, BoxOrientation.top)) {
            paintTop = false;
            paintTopLine = false;
        } else if (!this.isPaintTop() && this.isAtBorder(container, gridSize, col, row, BoxOrientation.top)) {
            paintTop = false;
            paintTopLine = false;
        } else {
            paintTop = true;
            paintTopLine = false;
        }
        if (this.isNeighbourDecoratable(container, gridSize, col, row, BoxOrientation.left)) {
            paintLeft = false;
            paintLeftLine = false;
        } else if (!this.isPaintLeft() && this.isAtBorder(container, gridSize, col, row, BoxOrientation.left)) {
            paintLeft = false;
            paintLeftLine = false;
        } else {
            paintLeft = true;
            paintLeftLine = false;
        }
        if (this.isNeighbourDecoratable(container, gridSize, col, row, BoxOrientation.bottom)) {
            paintBottom = false;
            paintBottomLine = true;
        } else if (!this.isPaintBottom() && this.isAtBorder(container, gridSize, col, row, BoxOrientation.bottom)) {
            paintBottom = false;
            paintBottomLine = false;
        } else {
            paintBottom = true;
            paintBottomLine = false;
        }
        if (this.isNeighbourDecoratable(container, gridSize, col, row, BoxOrientation.right)) {
            paintRight = false;
            paintRightLine = true;
        } else if (!this.isPaintRight() && this.isAtBorder(container, gridSize, col, row, BoxOrientation.right)) {
            paintRight = false;
            paintRightLine = false;
        } else {
            paintRight = true;
            paintRightLine = true;
        }
        String sides = DecorationUtils.toString(paintTop, paintLeft, paintBottom, paintRight);
        String lines = DecorationUtils.toString(paintTopLine, paintLeftLine, paintBottomLine, paintRightLine);
        return new Pair((Object)sides, (Object)lines);
    }

    protected boolean isNeighbourDecoratable(@NotNull Container container, @NotNull GridSize gridSize, int col, int row, @NotNull BoxOrientation direction) {
        Component neighbour = this.getNeighbour(container, gridSize, col, row, direction);
        return PainterSupport.isDecoratable(neighbour);
    }

    @Nullable
    protected Component getNeighbour(@NotNull Container container, @NotNull GridSize gridSize, int col, int row, @NotNull BoxOrientation direction) {
        Component neighbour;
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        if (direction.isTop()) {
            neighbour = row > 0 ? this.getComponentAt(container, col, row - 1) : null;
        } else if (direction.isBottom()) {
            neighbour = row < gridSize.rows - 1 ? this.getComponentAt(container, col, row + 1) : null;
        } else if (ltr ? direction.isLeft() : direction.isRight()) {
            neighbour = col > 0 ? this.getComponentAt(container, col - 1, row) : null;
        } else if (ltr ? direction.isRight() : direction.isLeft()) {
            neighbour = col < gridSize.columns - 1 ? this.getComponentAt(container, col + 1, row) : null;
        } else {
            throw new IllegalArgumentException("Unknown neighbour direction: " + direction);
        }
        return neighbour;
    }

    protected boolean isAtBorder(@NotNull Container container, @NotNull GridSize gridSize, int col, int row, @NotNull BoxOrientation direction) {
        boolean atBorder;
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        if (direction.isTop()) {
            atBorder = row == 0;
        } else if (direction.isBottom()) {
            atBorder = row == gridSize.rows - 1;
        } else if (direction.isLeft()) {
            atBorder = col == (ltr ? 0 : gridSize.columns - 1);
        } else if (direction.isRight()) {
            atBorder = col == (ltr ? gridSize.columns - 1 : 0);
        } else {
            throw new IllegalArgumentException("Unknown border direction: " + direction);
        }
        return atBorder;
    }
}

