/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.tooltip.AbstractComponentArea;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ListCellArea<V, C extends JList>
extends AbstractComponentArea<V, C> {
    protected final int index;

    public ListCellArea(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    @Override
    public boolean isAvailable(@NotNull C component) {
        return 0 <= this.index && this.index < ((JList)component).getModel().getSize();
    }

    @Override
    @Nullable
    public Rectangle getBounds(@NotNull C component) {
        Rectangle bounds = ((JList)component).getCellBounds(this.index, this.index);
        V value = this.getValue(component);
        boolean isSelected = ((JList)component).isSelectedIndex(this.index);
        boolean cellHasFocus = ((JList)component).getLeadSelectionIndex() == this.index;
        ListCellRenderer<V> cellRenderer = ((JList)component).getCellRenderer();
        Component renderer = cellRenderer.getListCellRendererComponent((JList<V>)component, value, this.index, isSelected, cellHasFocus);
        this.adjustBounds(component, renderer, bounds);
        return bounds;
    }

    @Override
    @Nullable
    public V getValue(@NotNull C component) {
        return (V)((JList)component).getModel().getElementAt(this.index);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ListCellArea && this.index == ((ListCellArea)other).index;
    }
}

