/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.list;

import com.alee.api.jdk.Objects;
import com.alee.api.ui.RenderingParameters;
import com.alee.laf.list.ListCellArea;
import java.awt.Component;
import javax.swing.JList;

public class ListCellParameters<V, C extends JList>
implements RenderingParameters {
    protected final C list;
    protected final V value;
    protected final int index;
    protected final boolean selected;
    protected final boolean focused;

    public ListCellParameters(C list, ListCellArea<V, C> area) {
        this(list, area.index());
    }

    public ListCellParameters(C list, int index) {
        this.list = (JList)Objects.requireNonNull(list, (String)"List must not be null");
        this.value = ((JList)list).getModel().getElementAt(index);
        this.index = index;
        this.selected = ((JList)list).isSelectedIndex(index);
        this.focused = ((Component)list).hasFocus() && ((JList)list).getLeadSelectionIndex() == index;
    }

    public ListCellParameters(C list, V value, int index, boolean selected, boolean focused) {
        this.list = (JList)Objects.requireNonNull(list, (String)"List must not be null");
        this.value = value;
        this.index = index;
        this.selected = selected;
        this.focused = focused;
    }

    public C list() {
        return this.list;
    }

    public V value() {
        return this.value;
    }

    public int index() {
        return this.index;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isFocused() {
        return this.focused;
    }
}

