/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.menu;

import com.alee.api.annotations.NotNull;
import com.alee.laf.WebUI;
import com.alee.laf.menu.MenuBarInputListener;
import com.alee.laf.menu.WMenuBarInputListener;
import com.alee.utils.LafUtils;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.MenuBarUI;

public abstract class WMenuBarUI<C extends JMenuBar>
extends MenuBarUI
implements WebUI<C> {
    protected MenuBarInputListener<C> inputListener;
    protected C menuBar;

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "MenuBar.";
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.menuBar = (JMenuBar)c;
        this.installDefaults();
        this.installListeners();
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.menuBar = null;
    }

    protected void installDefaults() {
        LafUtils.installDefaults(this.menuBar, this.getPropertyPrefix());
    }

    protected void uninstallDefaults() {
        LafUtils.uninstallDefaults(this.menuBar);
    }

    protected void installListeners() {
        this.inputListener = this.createMenuBarInputListener();
        this.inputListener.install(this.menuBar);
    }

    protected void uninstallListeners() {
        this.inputListener.uninstall(this.menuBar);
        this.inputListener = null;
    }

    protected MenuBarInputListener<C> createMenuBarInputListener() {
        return new WMenuBarInputListener();
    }
}

