/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.optionpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.button.WebButton;
import com.alee.laf.label.WebLabel;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.LafLookup;
import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicOptionPaneUI;

public class WebOptionPaneUI
extends BasicOptionPaneUI {
    public static final ImageIcon INFORMATION_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/information.png"));
    public static final ImageIcon WARNING_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/warning.png"));
    public static final ImageIcon ERROR_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/error.png"));
    public static final ImageIcon QUESTION_ICON = new ImageIcon(WebOptionPaneUI.class.getResource("icons/question.png"));

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebOptionPaneUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.optionPane);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.optionPane);
        super.uninstallUI(c);
    }

    @Override
    @NotNull
    protected Container createMessageArea() {
        WebPanel messageArea = new WebPanel(StyleId.optionpaneMessageArea.at(this.optionPane), new BorderLayout(), new Component[0]);
        Icon sideIcon = this.getIcon();
        if (sideIcon != null) {
            WebLabel iconLabel = new WebLabel(StyleId.optionpaneIconLabel.at(messageArea), sideIcon);
            iconLabel.setName("OptionPane.iconLabel");
            iconLabel.setVerticalAlignment(1);
            messageArea.add((Component)iconLabel, (Object)"Before");
        }
        WebPanel realBody = new WebPanel(StyleId.optionpaneRealBody.at(messageArea), new BorderLayout(), new Component[0]);
        realBody.setName("OptionPane.realBody");
        if (sideIcon != null) {
            WebPanel sep = new WebPanel(StyleId.optionpaneSeparator.at(realBody));
            sep.setName("OptionPane.separator");
            realBody.add((Component)sep, (Object)"Before");
        }
        WebPanel body = new WebPanel(StyleId.optionpaneBody.at(realBody), new GridBagLayout(), new Component[0]);
        body.setName("OptionPane.body");
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = LafLookup.getInt(this.optionPane, this, "OptionPane.messageAnchor", 10);
        cons.insets = new Insets(0, 0, 3, 0);
        this.addMessageComponents(body, cons, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        realBody.add((Component)body, (Object)"Center");
        messageArea.add((Component)realBody, (Object)"Center");
        return messageArea;
    }

    @Override
    protected void addIcon(Container messageArea) {
        throw new RuntimeException("This method is not supported by WebLookAndFeel");
    }

    @Override
    protected void addMessageComponents(@NotNull Container body, @NotNull GridBagConstraints cons, @Nullable Object msg, int maxll, boolean internallyCreated) {
        if (msg != null) {
            if (msg instanceof Component) {
                if (msg instanceof JScrollPane || msg instanceof JPanel) {
                    cons.fill = 1;
                    cons.weighty = 1.0;
                } else {
                    cons.fill = 2;
                }
                cons.weightx = 1.0;
                body.add((Component)msg, cons);
                cons.weightx = 0.0;
                cons.weighty = 0.0;
                cons.fill = 0;
                ++cons.gridy;
                if (!internallyCreated) {
                    this.hasCustomComponents = true;
                }
            } else if (msg instanceof Object[]) {
                Object[] msgs;
                for (Object smsg : msgs = (Object[])msg) {
                    this.addMessageComponents(body, cons, smsg, maxll, false);
                }
            } else if (msg instanceof Icon) {
                JLabel label = new JLabel((Icon)msg, 0);
                this.addMessageComponents(body, cons, label, maxll, true);
            } else {
                String s = msg.toString();
                int len = s.length();
                if (len > 0) {
                    int nll = 0;
                    String newline = TextUtils.getSystemLineSeparator();
                    int nl = s.indexOf(newline);
                    if (nl >= 0) {
                        nll = newline.length();
                    } else {
                        nl = s.indexOf("\r\n");
                        if (nl >= 0) {
                            nll = 2;
                        } else {
                            nl = s.indexOf(10);
                            if (nl >= 0) {
                                nll = 1;
                            }
                        }
                    }
                    if (nl >= 0) {
                        if (nl == 0) {
                            JPanel breakPanel = new JPanel(){

                                @Override
                                @NotNull
                                public Dimension getPreferredSize() {
                                    Font f = this.getFont();
                                    Dimension ps = f != null ? new Dimension(1, f.getSize() + 2) : new Dimension(0, 0);
                                    return ps;
                                }
                            };
                            breakPanel.setName("OptionPane.break");
                            this.addMessageComponents(body, cons, breakPanel, maxll, true);
                        } else {
                            this.addMessageComponents(body, cons, s.substring(0, nl), maxll, false);
                        }
                        this.addMessageComponents(body, cons, s.substring(nl + nll), maxll, false);
                    } else if (len > maxll) {
                        Box c = Box.createVerticalBox();
                        c.setName("OptionPane.verticalBox");
                        this.burstStringInto(body, c, s, maxll);
                        this.addMessageComponents(body, cons, c, maxll, true);
                    } else {
                        WebLabel label = this.createMessageLabel(body, s);
                        this.addMessageComponents(body, cons, label, maxll, true);
                    }
                }
            }
        }
    }

    @Override
    protected void burstStringInto(@NotNull Container c, @Nullable String msg, int maxll) {
        throw new RuntimeException("This method is not supported by WebLookAndFeel");
    }

    protected void burstStringInto(@NotNull Container body, @NotNull Container c, @NotNull String msg, int maxll) {
        int len = msg.length();
        if (len > 0) {
            if (len > maxll) {
                int p = msg.lastIndexOf(32, maxll);
                if (p <= 0) {
                    p = msg.indexOf(32, maxll);
                }
                if (p > 0 && p < len) {
                    this.burstStringInto(c, msg.substring(0, p), maxll);
                    this.burstStringInto(c, msg.substring(p + 1), maxll);
                } else {
                    c.add(this.createMessageLabel(body, msg));
                }
            } else {
                c.add(this.createMessageLabel(body, msg));
            }
        }
    }

    @NotNull
    protected WebLabel createMessageLabel(@NotNull Container body, @NotNull String msg) {
        StyleId styleId = StyleId.optionpaneMessageLabel.at((JComponent)body);
        WebLabel label = new WebLabel(styleId, msg, 10, new Object[0]);
        label.setName("OptionPane.label");
        return label;
    }

    @Override
    @NotNull
    protected Container createButtonArea() {
        boolean sameSizeButtons = LafLookup.getBoolean(this.optionPane, this, "OptionPane.sameSizeButtons", true);
        int buttonPadding = LafLookup.getInt(this.optionPane, this, "OptionPane.buttonPadding", 6);
        int buttonOrientation = LafLookup.getInt(this.optionPane, this, "OptionPane.buttonOrientation", 0);
        boolean isYesLast = LafLookup.getBoolean(this.optionPane, this, "OptionPane.isYesLast", false);
        BasicOptionPaneUI.ButtonAreaLayout layout = (BasicOptionPaneUI.ButtonAreaLayout)ReflectUtils.createInstanceSafely(BasicOptionPaneUI.ButtonAreaLayout.class, (Object[])new Object[]{sameSizeButtons, buttonPadding, buttonOrientation, isYesLast});
        WebPanel buttonArea = new WebPanel(StyleId.optionpaneButtonArea.at(this.optionPane), layout, new Component[0]);
        buttonArea.setName("OptionPane.buttonArea");
        this.addButtonComponents(buttonArea, this.getButtons(buttonArea), this.getInitialValueIndex());
        return buttonArea;
    }

    @Override
    protected void addButtonComponents(@NotNull Container container, @Nullable Object[] buttons, int initialIndex) {
        if (container instanceof JComponent) {
            ((JComponent)container).setOpaque(false);
        }
        if (buttons != null && buttons.length > 0) {
            boolean createdAll = true;
            int numButtons = buttons.length;
            for (int counter = 0; counter < numButtons; ++counter) {
                Component newComponent;
                Object button = buttons[counter];
                if (button instanceof Component) {
                    createdAll = false;
                    newComponent = (Component)button;
                    container.add(newComponent);
                    this.hasCustomComponents = true;
                } else {
                    WebButton aButton;
                    if (button instanceof Icon) {
                        Icon icon = (Icon)button;
                        aButton = new WebButton(icon);
                    } else {
                        String text = button.toString();
                        aButton = new WebButton(text);
                    }
                    aButton.setName("OptionPane.button");
                    aButton.setMultiClickThreshhold(UIManager.getInt("OptionPane.buttonClickThreshold"));
                    this.configureButton(aButton);
                    container.add(aButton);
                    ActionListener buttonListener = this.createButtonActionListener(counter);
                    if (buttonListener != null) {
                        aButton.addActionListener(buttonListener);
                    }
                    newComponent = aButton;
                }
                if (counter != initialIndex) continue;
                this.initialFocusComponent = newComponent;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                JButton defaultB = (JButton)this.initialFocusComponent;
                defaultB.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        JButton defaultButton;
                        JRootPane root;
                        if ((e.getChangeFlags() & 1L) != 0L && (root = SwingUtilities.getRootPane(defaultButton = (JButton)e.getComponent())) != null) {
                            root.setDefaultButton(defaultButton);
                        }
                    }
                });
            }
            BasicOptionPaneUI.ButtonAreaLayout layout = (BasicOptionPaneUI.ButtonAreaLayout)container.getLayout();
            layout.setSyncAllWidths(createdAll && this.getSizeButtonsToSameWidth());
        }
    }

    @Override
    protected Object[] getButtons() {
        throw new RuntimeException("This method is not supported by WebLookAndFeel");
    }

    @Nullable
    protected Object[] getButtons(@NotNull WebPanel buttonArea) {
        Object[] buttons = null;
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            if (suppliedOptions == null) {
                int type = this.optionPane.getOptionType();
                WebButton[] defaultOptions = type == 0 ? new WebButton[]{new WebButton(StyleId.optionpaneYesButton.at(buttonArea), "weblaf.optionpane.yes"), new WebButton(StyleId.optionpaneNoButton.at(buttonArea), "weblaf.optionpane.no")} : (type == 1 ? new WebButton[]{new WebButton(StyleId.optionpaneYesButton.at(buttonArea), "weblaf.optionpane.yes"), new WebButton(StyleId.optionpaneNoButton.at(buttonArea), "weblaf.optionpane.no"), new WebButton(StyleId.optionpaneCancelButton.at(buttonArea), "weblaf.optionpane.cancel")} : (type == 2 ? new WebButton[]{new WebButton(StyleId.optionpaneOkButton.at(buttonArea), "weblaf.optionpane.ok"), new WebButton(StyleId.optionpaneCancelButton.at(buttonArea), "weblaf.optionpane.cancel")} : new WebButton[]{new WebButton(StyleId.optionpaneOkButton.at(buttonArea), "weblaf.optionpane.ok")}));
                for (int i = 0; i < defaultOptions.length; ++i) {
                    this.configureButton(defaultOptions[i]);
                    defaultOptions[i].addActionListener(this.createButtonActionListener(i));
                }
                buttons = defaultOptions;
            } else {
                buttons = suppliedOptions;
            }
        }
        return buttons;
    }

    private void configureButton(@NotNull WebButton button) {
        button.setMinimumSize(new Dimension(70, 0));
        Font buttonFont = UIManager.getFont("OptionPane.buttonFont");
        if (buttonFont != null) {
            button.setFont(buttonFont);
        }
    }

    @Override
    protected Icon getIconForType(int messageType) {
        return WebOptionPaneUI.getTypeIcon(messageType);
    }

    @Nullable
    public static ImageIcon getTypeIcon(int messageType) {
        ImageIcon icon = null;
        if (messageType >= 0 && messageType <= 3) {
            switch (messageType) {
                case 0: {
                    icon = ERROR_ICON;
                    break;
                }
                case 1: {
                    icon = INFORMATION_ICON;
                    break;
                }
                case 2: {
                    icon = WARNING_ICON;
                    break;
                }
                case 3: {
                    icon = QUESTION_ICON;
                }
            }
        }
        return icon;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public int getBaseline(@NotNull JComponent c, int width, int height) {
        return PainterSupport.getBaseline(c, this, width, height);
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent c) {
        return PainterSupport.getBaselineResizeBehavior(c, this);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c));
    }
}

