/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.radiobutton;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import javax.swing.AbstractButton;

@XStreamAlias(value="RadioIcon")
public class RadioIcon<C extends AbstractButton, D extends IDecoration<C, D>, I extends RadioIcon<C, D, I>>
extends AbstractContent<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Color leftColor;
    @XStreamAsAttribute
    @Nullable
    protected Color rightColor;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "radio";
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d) {
        return false;
    }

    @NotNull
    public Color getLeftColor(@NotNull C c, @NotNull D d) {
        if (this.leftColor == null) {
            throw new DecorationException("Left side background color must be specified");
        }
        return this.leftColor;
    }

    @NotNull
    public Color getRightColor(@NotNull C c, @NotNull D d) {
        if (this.rightColor == null) {
            throw new DecorationException("Right side background color must be specified");
        }
        return this.rightColor;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        Paint op = GraphicsUtils.setupPaint((Graphics2D)g2d, (Paint)new GradientPaint(bounds.x, 0.0f, this.getLeftColor(c, d), bounds.x + bounds.width, 0.0f, this.getRightColor(c, d)));
        g2d.fill(new Ellipse2D.Double(bounds.x, bounds.y, bounds.width, bounds.height));
        GraphicsUtils.restorePaint((Graphics2D)g2d, (Paint)op);
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        return new Dimension(0, 0);
    }
}

