/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.scroll.IScrollBarPainter;
import com.alee.laf.scroll.ScrollBarPaintParameters;
import com.alee.laf.scroll.WScrollBarUI;
import com.alee.managers.style.Bounds;
import com.alee.painter.AbstractPainter;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JScrollBar;

public class ScrollBarPainter<C extends JScrollBar, U extends WScrollBarUI>
extends AbstractPainter<C, U>
implements IScrollBarPainter<C, U> {
    protected Integer thumbRound;
    protected Insets thumbMargin;
    protected Integer scrollBarWidth;
    protected Color trackBorderColor;
    protected Color trackBackgroundColor;
    protected Color thumbBorderColor;
    protected Color thumbBackgroundColor;
    protected Color thumbDisabledBorderColor;
    protected Color thumbDisabledBackgroundColor;
    protected Color thumbRolloverBorderColor;
    protected Color thumbRolloverBackgroundColor;
    protected Color thumbPressedBorderColor;
    protected Color thumbPressedBackgroundColor;
    protected transient MouseAdapter mouseAdapter;
    protected transient boolean animated;
    protected transient WebTimer rolloverAnimator;
    protected transient float rolloverState;
    protected transient boolean rollover;
    protected transient boolean pressed;
    protected transient ScrollBarPaintParameters paintParameters;
    protected transient Insets thumbMarginR;
    protected transient Insets thumbMarginHL;
    protected transient Insets thumbMarginHR;

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.animated = true;
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                ScrollBarPainter.this.setPressed(true);
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                ScrollBarPainter.this.setPressed(false);
            }

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                ScrollBarPainter.this.setRollover(ScrollBarPainter.this.paintParameters != null && ScrollBarPainter.this.paintParameters.thumbBounds.contains(e.getPoint()));
            }

            @Override
            public void mouseMoved(@NotNull MouseEvent e) {
                ScrollBarPainter.this.setRollover(ScrollBarPainter.this.paintParameters != null && ScrollBarPainter.this.paintParameters.thumbBounds.contains(e.getPoint()));
            }

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                ScrollBarPainter.this.setRollover(false);
            }
        };
        ((JScrollBar)this.component).addMouseListener(this.mouseAdapter);
        ((JScrollBar)this.component).addMouseMotionListener(this.mouseAdapter);
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        ((JScrollBar)this.component).removeMouseListener(this.mouseAdapter);
        ((JScrollBar)this.component).removeMouseMotionListener(this.mouseAdapter);
        super.uninstallPropertiesAndListeners();
    }

    public boolean isRollover() {
        return this.rollover;
    }

    public void setRollover(boolean rollover) {
        if (this.rollover != rollover) {
            this.rollover = rollover;
            if (this.animated) {
                if (rollover) {
                    if (this.rolloverAnimator != null) {
                        this.rolloverAnimator.stop();
                    }
                    this.repaintThumb();
                } else {
                    if (this.rolloverAnimator == null) {
                        this.rolloverAnimator = new WebTimer(SwingUtils.frameRateDelay(36), new ActionListener(){

                            @Override
                            public void actionPerformed(@NotNull ActionEvent e) {
                                if (ScrollBarPainter.this.rolloverState > 0.0f) {
                                    ScrollBarPainter.this.rolloverState -= 0.1f;
                                    ScrollBarPainter.this.repaintThumb();
                                } else {
                                    ScrollBarPainter.this.rolloverState = 0.0f;
                                    ScrollBarPainter.this.rolloverAnimator.stop();
                                }
                            }
                        });
                    }
                    this.rolloverState = 1.0f;
                    this.rolloverAnimator.start();
                }
            } else {
                this.rolloverState = rollover ? 1.0f : 0.0f;
                this.repaintThumb();
            }
        }
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        if (this.pressed != pressed) {
            this.pressed = pressed;
            this.repaintThumb();
        }
    }

    @Override
    @NotNull
    public Boolean isOpaque() {
        return ((WScrollBarUI)this.ui).isDisplayTrack();
    }

    @Override
    @Nullable
    protected Insets getBorder() {
        Insets border;
        if (((WScrollBarUI)this.ui).isDisplayTrack()) {
            boolean hor = ((JScrollBar)this.component).getOrientation() == 0;
            border = new Insets(hor ? 1 : 0, hor ? 0 : 1, 0, 0);
        } else {
            border = super.getBorder();
        }
        return border;
    }

    @Override
    public void prepareToPaint(@NotNull ScrollBarPaintParameters parameters) {
        this.paintParameters = parameters;
    }

    @Override
    public void cleanupAfterPaint() {
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull C scrollbar, @NotNull U ui, @NotNull Bounds bounds) {
        Object aa = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        this.paintBackground(g2d, scrollbar, bounds.get());
        this.paintTrack(g2d, scrollbar, this.paintParameters.trackBounds);
        this.paintThumb(g2d, scrollbar, this.paintParameters.thumbBounds);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)aa);
    }

    protected void paintBackground(@NotNull Graphics2D g2d, @NotNull C scrollbar, @NotNull Rectangle bounds) {
        if (((WScrollBarUI)this.ui).isDisplayTrack()) {
            g2d.setPaint(this.trackBackgroundColor);
            g2d.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            if (((JScrollBar)scrollbar).getOrientation() == 1) {
                int x = this.ltr ? bounds.x : bounds.x + bounds.width - 1;
                g2d.setPaint(this.trackBorderColor);
                g2d.drawLine(x, bounds.y, x, bounds.height - 1);
            } else {
                g2d.setPaint(this.trackBorderColor);
                g2d.drawLine(bounds.x, bounds.y, bounds.x + bounds.width - 1, bounds.y);
            }
        }
    }

    protected void paintTrack(@NotNull Graphics2D g2d, @NotNull C scrollbar, @NotNull Rectangle bounds) {
    }

    protected void paintThumb(@NotNull Graphics2D g2d, @NotNull C scrollbar, @NotNull Rectangle bounds) {
        Insets m = this.getCurrentThumbMargin(scrollbar);
        int w = bounds.width - m.left - m.right;
        int h = bounds.height - m.top - m.bottom;
        int round = MathUtils.min((int[])new int[]{this.thumbRound, w - 1, h - 1});
        g2d.setPaint(this.getCurrentThumbBackgroundColor(scrollbar));
        g2d.fillRoundRect(bounds.x + m.left, bounds.y + m.top, w, h, round, round);
        g2d.setPaint(this.getCurrentThumbBorderColor(scrollbar));
        g2d.drawRoundRect(bounds.x + m.left, bounds.y + m.top, w - 1, h - 1, round, round);
    }

    @NotNull
    protected Insets getCurrentThumbMargin(@NotNull C scrollbar) {
        Insets margin;
        if (this.thumbMargin != null) {
            boolean ver;
            if (this.thumbMarginR == null) {
                this.updateThumbMargins();
            }
            boolean bl = ver = ((JScrollBar)scrollbar).getOrientation() == 1;
            margin = ver ? (this.ltr ? this.thumbMargin : this.thumbMarginR) : (this.ltr ? this.thumbMarginHL : this.thumbMarginHR);
        } else {
            margin = new Insets(0, 0, 0, 0);
        }
        return margin;
    }

    protected void updateThumbMargins() {
        this.thumbMarginR = new Insets(this.thumbMargin.top, this.thumbMargin.right, this.thumbMargin.bottom, this.thumbMargin.left);
        this.thumbMarginHL = new Insets(this.thumbMargin.left, this.thumbMargin.bottom, this.thumbMargin.right, this.thumbMargin.top);
        this.thumbMarginHR = new Insets(this.thumbMargin.right, this.thumbMargin.top, this.thumbMargin.left, this.thumbMargin.bottom);
    }

    @NotNull
    protected Color getCurrentThumbBorderColor(@NotNull C scrollbar) {
        Color color = ((Component)scrollbar).isEnabled() ? (this.pressed || this.paintParameters.dragged ? this.thumbPressedBorderColor : (this.rollover ? this.thumbRolloverBorderColor : ColorUtils.intermediate((Color)this.thumbBorderColor, (Color)this.thumbRolloverBorderColor, (float)this.rolloverState))) : this.thumbDisabledBorderColor;
        return color;
    }

    @NotNull
    protected Color getCurrentThumbBackgroundColor(@NotNull C scrollbar) {
        Color color = ((Component)scrollbar).isEnabled() ? (this.pressed || this.paintParameters.dragged ? this.thumbPressedBackgroundColor : (this.rollover ? this.thumbRolloverBackgroundColor : ColorUtils.intermediate((Color)this.thumbBackgroundColor, (Color)this.thumbRolloverBackgroundColor, (float)this.rolloverState))) : this.thumbDisabledBackgroundColor;
        return color;
    }

    public void repaintThumb() {
        if (this.paintParameters != null) {
            this.repaint(this.paintParameters.thumbBounds);
        } else {
            this.repaint();
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Insets i = ((JScrollBar)this.component).getInsets();
        Dimension ps = ((JScrollBar)this.component).getOrientation() == 1 ? new Dimension(i.left + this.scrollBarWidth + i.right, i.top + 48 + i.bottom) : new Dimension(i.left + 48 + i.right, i.top + this.scrollBarWidth + i.bottom);
        return ps;
    }
}

