/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.scroll;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.Corner;
import com.alee.extended.canvas.WebCanvas;
import com.alee.laf.scroll.ScrollPaneCornerProvider;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class WebScrollPaneUI
extends BasicScrollPaneUI {
    protected transient PropertyChangeListener propertyChangeListener;
    protected transient ContainerAdapter viewListener;
    protected transient Map<Corner, JComponent> cornersCache;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebScrollPaneUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        super.installUI(c);
        StyleManager.installSkin(this.scrollpane);
        StyleId.scrollpaneViewport.at(this.scrollpane).set(this.scrollpane.getViewport());
        StyleId.scrollpaneVerticalBar.at(this.scrollpane).set(this.scrollpane.getVerticalScrollBar());
        StyleId.scrollpaneHorizontalBar.at(this.scrollpane).set(this.scrollpane.getHorizontalScrollBar());
        this.cornersCache = new HashMap<Corner, JComponent>(4);
        this.updateCorners();
        this.viewListener = new ContainerAdapter(){

            @Override
            public void componentAdded(@NotNull ContainerEvent e) {
                WebScrollPaneUI.this.removeCorners();
                WebScrollPaneUI.this.updateCorners();
            }

            @Override
            public void componentRemoved(@NotNull ContainerEvent e) {
                WebScrollPaneUI.this.removeCorners();
                WebScrollPaneUI.this.updateCorners();
            }
        };
        JViewport viewport = this.scrollpane.getViewport();
        if (viewport != null) {
            viewport.addContainerListener(this.viewListener);
        }
        this.propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent evt) {
                JScrollBar hsb;
                String property = evt.getPropertyName();
                if (property.equals("componentOrientation")) {
                    WebScrollPaneUI.this.removeCorners();
                    WebScrollPaneUI.this.updateCorners();
                } else if (property.equals("viewport")) {
                    JViewport viewport;
                    if (evt.getOldValue() != null) {
                        viewport = (JViewport)evt.getOldValue();
                        viewport.removeContainerListener(WebScrollPaneUI.this.viewListener);
                        StyleId.viewport.set(viewport);
                    }
                    if (evt.getNewValue() != null) {
                        viewport = (JViewport)evt.getNewValue();
                        viewport.addContainerListener(WebScrollPaneUI.this.viewListener);
                        StyleId.scrollpaneViewport.at(WebScrollPaneUI.this.scrollpane).set(WebScrollPaneUI.this.scrollpane.getViewport());
                    }
                    WebScrollPaneUI.this.removeCorners();
                    WebScrollPaneUI.this.updateCorners();
                } else if (property.equals("verticalScrollBar")) {
                    JScrollBar vsb = WebScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                    if (vsb != null) {
                        StyleId.scrollpaneVerticalBar.at(WebScrollPaneUI.this.scrollpane).set(vsb);
                    }
                } else if (property.equals("horizontalScrollBar") && (hsb = WebScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null) {
                    StyleId.scrollpaneHorizontalBar.at(WebScrollPaneUI.this.scrollpane).set(hsb);
                }
            }
        };
        this.scrollpane.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.scrollpane);
        this.scrollpane.removePropertyChangeListener(this.propertyChangeListener);
        this.removeCorners();
        this.cornersCache = null;
        this.scrollpane.setLayout(new ScrollPaneLayout.UIResource());
        super.uninstallUI(c);
    }

    @Override
    @NotNull
    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(@NotNull MouseWheelEvent e) {
                if (WebScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getWheelRotation() != 0) {
                    int orientation;
                    JScrollBar toScroll;
                    JScrollBar vsb = WebScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                    if (vsb == null || !vsb.isVisible() || SwingUtils.isShift(e)) {
                        toScroll = WebScrollPaneUI.this.scrollpane.getHorizontalScrollBar();
                        orientation = 0;
                    } else {
                        toScroll = vsb;
                        orientation = 1;
                    }
                    if (toScroll != null && toScroll.isVisible()) {
                        int direction;
                        e.consume();
                        int n = direction = e.getWheelRotation() < 0 ? -1 : 1;
                        if (e.getScrollType() == 0) {
                            JViewport vp = WebScrollPaneUI.this.scrollpane.getViewport();
                            if (vp != null) {
                                Component component = vp.getView();
                                int units = Math.abs(e.getUnitsToScroll());
                                boolean limitScroll = Math.abs(e.getWheelRotation()) == 1;
                                Object fastWheelScroll = toScroll.getClientProperty("JScrollBar.fastWheelScrolling");
                                if (Boolean.TRUE == fastWheelScroll && component instanceof Scrollable) {
                                    Scrollable scrollComp = (Scrollable)((Object)component);
                                    Rectangle viewRect = vp.getViewRect();
                                    int startingX = viewRect.x;
                                    boolean leftToRight = component.getComponentOrientation().isLeftToRight();
                                    int scrollMin = toScroll.getMinimum();
                                    int scrollMax = toScroll.getMaximum() - toScroll.getModel().getExtent();
                                    if (limitScroll) {
                                        int blockIncr = scrollComp.getScrollableBlockIncrement(viewRect, orientation, direction);
                                        if (direction < 0) {
                                            scrollMin = Math.max(scrollMin, toScroll.getValue() - blockIncr);
                                        } else {
                                            scrollMax = Math.min(scrollMax, toScroll.getValue() + blockIncr);
                                        }
                                    }
                                    for (int i = 0; i < units; ++i) {
                                        int unitIncr = scrollComp.getScrollableUnitIncrement(viewRect, orientation, direction);
                                        if (orientation == 1) {
                                            if (direction < 0) {
                                                viewRect.y -= unitIncr;
                                                if (viewRect.y > scrollMin) continue;
                                                viewRect.y = scrollMin;
                                                break;
                                            }
                                            viewRect.y += unitIncr;
                                            if (viewRect.y < scrollMax) continue;
                                            viewRect.y = scrollMax;
                                            break;
                                        }
                                        if (leftToRight ? direction < 0 : direction > 0) {
                                            viewRect.x -= unitIncr;
                                            if (!leftToRight || viewRect.x >= scrollMin) continue;
                                            viewRect.x = scrollMin;
                                            break;
                                        }
                                        viewRect.x += unitIncr;
                                        if (!leftToRight || viewRect.x <= scrollMax) continue;
                                        viewRect.x = scrollMax;
                                        break;
                                    }
                                    if (orientation == 1) {
                                        toScroll.setValue(viewRect.y);
                                    } else if (leftToRight) {
                                        toScroll.setValue(viewRect.x);
                                    } else {
                                        int newPos = toScroll.getValue() - (viewRect.x - startingX);
                                        if (newPos < scrollMin) {
                                            newPos = scrollMin;
                                        } else if (newPos > scrollMax) {
                                            newPos = scrollMax;
                                        }
                                        toScroll.setValue(newPos);
                                    }
                                } else {
                                    WebScrollPaneUI.this.scrollByUnits(toScroll, direction, units, limitScroll);
                                }
                            }
                        } else if (e.getScrollType() == 1) {
                            WebScrollPaneUI.this.scrollByBlock(toScroll, direction);
                        }
                    }
                }
            }
        };
    }

    protected void scrollByUnits(@NotNull JScrollBar scrollbar, int direction, int units, boolean limitToBlock) {
        int limit = -1;
        if (limitToBlock) {
            limit = direction < 0 ? scrollbar.getValue() - scrollbar.getBlockIncrement(direction) : scrollbar.getValue() + scrollbar.getBlockIncrement(direction);
        }
        for (int i = 0; i < units; ++i) {
            int delta = direction > 0 ? scrollbar.getUnitIncrement(direction) : -scrollbar.getUnitIncrement(direction);
            int oldValue = scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = scrollbar.getMinimum();
            }
            if (oldValue == newValue || limitToBlock && i > 0 && (direction < 0 && newValue < limit || direction > 0 && newValue > limit)) break;
            scrollbar.setValue(newValue);
        }
    }

    protected void scrollByBlock(@NotNull JScrollBar scrollbar, int direction) {
        int oldValue = scrollbar.getValue();
        int blockIncrement = scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = scrollbar.getMinimum();
        }
        scrollbar.setValue(newValue);
    }

    protected void updateCorners() {
        ScrollPaneCornerProvider provider = this.getScrollCornerProvider();
        for (Corner type : Corner.values()) {
            JComponent corner = this.cornersCache.get(type);
            if (corner == null) {
                if (provider != null) {
                    corner = provider.getCorner(type);
                }
                if (corner == null && (type == Corner.lowerLeading || type == Corner.lowerTrailing || type == Corner.upperTrailing)) {
                    corner = new WebCanvas(StyleId.scrollpaneCorner.at(this.scrollpane), type.name());
                }
            }
            if (corner == null) continue;
            this.cornersCache.put(type, corner);
            this.scrollpane.setCorner(type.getScrollPaneConstant(), corner);
        }
    }

    protected void removeCorners() {
        for (Corner type : Corner.values()) {
            String key = type.getScrollPaneConstant();
            Component corner = this.scrollpane.getCorner(key);
            if (corner == null || !this.cornersCache.containsValue(corner)) continue;
            this.scrollpane.setCorner(key, null);
        }
        this.cornersCache.clear();
    }

    @Nullable
    protected ScrollPaneCornerProvider getScrollCornerProvider() {
        ScrollPaneCornerProvider scp = null;
        if (this.scrollpane.getViewport() != null && this.scrollpane.getViewport().getView() != null) {
            Object ui;
            JComponent jView;
            Component view = this.scrollpane.getViewport().getView();
            if (view instanceof ScrollPaneCornerProvider) {
                scp = (ScrollPaneCornerProvider)((Object)view);
            } else if (view instanceof JComponent && LafUtils.hasUI(jView = (JComponent)view) && (ui = LafUtils.getUI(jView)) instanceof ScrollPaneCornerProvider) {
                scp = (ScrollPaneCornerProvider)ui;
            }
        }
        return scp;
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        PainterSupport.paint(g, c, this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return null;
    }
}

