/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.slider;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.slider.SliderState;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderSettingsProcessor
extends SettingsProcessor<JSlider, SliderState, Configuration<SliderState>> {
    protected transient ChangeListener changeListener;

    public SliderSettingsProcessor(JSlider slider, Configuration configuration) {
        super(slider, configuration);
    }

    @Override
    protected void register(@NotNull JSlider slider) {
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SliderSettingsProcessor.this.save();
            }
        };
        slider.addChangeListener(this.changeListener);
    }

    @Override
    protected void unregister(@NotNull JSlider slider) {
        slider.removeChangeListener(this.changeListener);
        this.changeListener = null;
    }

    @Override
    @Nullable
    protected SliderState createDefaultValue() {
        return new SliderState((JSlider)this.component());
    }

    @Override
    protected void loadSettings(@NotNull JSlider slider) {
        ((SliderState)this.loadSettings()).apply(slider);
    }

    @Override
    protected void saveSettings(@NotNull JSlider slider) {
        this.saveSettings(new SliderState(slider));
    }
}

