/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.splitpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.extended.canvas.WebCanvas;
import com.alee.laf.WebUI;
import com.alee.laf.splitpane.SplitPaneInputListener;
import com.alee.laf.splitpane.SplitPaneLayout;
import com.alee.laf.splitpane.WSplitPaneInputListener;
import com.alee.laf.splitpane.WebSplitPaneDivider;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.StyleId;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.utils.LafUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;

public abstract class WSplitPaneUI<C extends JSplitPane>
extends SplitPaneUI
implements WebUI<C> {
    protected static final String NON_CONTINUOUS_DIVIDER = "nonContinuousDivider";
    protected SplitPaneLayout layoutManager;
    protected WebSplitPaneDivider divider;
    protected ComponentListener componentListener;
    protected ContainerListener containerListener;
    protected SplitPaneInputListener<C> inputListener;
    protected PropertyChangeListener propertyChangeListener;
    protected int dividerSize;
    protected JComponent nonContinuousLayoutDivider;
    protected int beginDragDividerLocation;
    protected boolean rememberPaneSizes;
    protected boolean keepHidden = false;
    protected boolean painted;
    protected boolean ignoreDividerLocationChange;
    protected C splitPane;
    protected int orientation;
    protected int lastDragLocation;
    protected boolean continuousLayout;
    protected boolean dividerKeyboardResize;
    protected boolean dividerLocationIsSet;

    @Override
    @NotNull
    public String getPropertyPrefix() {
        return "SplitPane.";
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.splitPane = (JSplitPane)c;
        this.setDividerLocationSet(false);
        this.setDividerKeyboardResize(false);
        this.keepHidden = false;
        this.installDefaults();
        this.installListeners();
        this.setLastDragLocation(-1);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.setDividerKeyboardResize(false);
        this.setDividerLocationSet(false);
        this.splitPane = null;
    }

    protected void installDefaults() {
        LafUtils.installDefaults(this.splitPane, this.getPropertyPrefix());
        if (this.divider == null) {
            this.divider = this.createDivider();
        }
        this.divider.setSplitPane((JSplitPane)this.splitPane);
        this.setOrientation(((JSplitPane)this.splitPane).getOrientation());
        Integer dividerSize = (Integer)UIManager.get("SplitPane.dividerSize");
        LookAndFeel.installProperty(this.splitPane, "dividerSize", dividerSize);
        this.divider.setDividerSize(((JSplitPane)this.splitPane).getDividerSize());
        this.updateDividerVisibility();
        ((Container)this.splitPane).add((Component)this.divider, "divider");
        this.setContinuousLayout(((JSplitPane)this.splitPane).isContinuousLayout());
        this.resetLayoutManager();
        if (this.nonContinuousLayoutDivider == null) {
            this.setNonContinuousLayoutDivider(this.createNonContinuousDivider(), true);
        } else {
            this.setNonContinuousLayoutDivider(this.nonContinuousLayoutDivider, true);
        }
    }

    protected void uninstallDefaults() {
        if (((Container)this.splitPane).getLayout() == this.layoutManager) {
            ((Container)this.splitPane).setLayout(null);
        }
        if (this.nonContinuousLayoutDivider != null) {
            ((JSplitPane)this.splitPane).remove(this.nonContinuousLayoutDivider);
        }
        ((JSplitPane)this.splitPane).remove(this.divider);
        this.divider.setSplitPane(null);
        this.layoutManager = null;
        this.divider = null;
        this.nonContinuousLayoutDivider = null;
        this.setNonContinuousLayoutDivider(null);
        LafUtils.uninstallDefaults(this.splitPane);
    }

    protected void installListeners() {
        this.componentListener = this.createComponentListener();
        this.addSideComponentListener(((JSplitPane)this.splitPane).getLeftComponent());
        this.addSideComponentListener(((JSplitPane)this.splitPane).getRightComponent());
        this.containerListener = this.createContainerListener();
        ((Container)this.splitPane).addContainerListener(this.containerListener);
        this.propertyChangeListener = this.createPropertyChangeListener();
        ((Container)this.splitPane).addPropertyChangeListener(this.propertyChangeListener);
        this.inputListener = this.createInputListener();
        this.inputListener.install(this.splitPane);
    }

    protected void uninstallListeners() {
        this.inputListener.uninstall(this.splitPane);
        this.inputListener = null;
        ((Component)this.splitPane).removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        ((Container)this.splitPane).removeContainerListener(this.containerListener);
        this.containerListener = null;
        this.removeSideComponentListener(((JSplitPane)this.splitPane).getRightComponent());
        this.removeSideComponentListener(((JSplitPane)this.splitPane).getLeftComponent());
        this.componentListener = null;
    }

    protected ComponentListener createComponentListener() {
        return new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                WSplitPaneUI.this.updateDividerVisibility();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                WSplitPaneUI.this.updateDividerVisibility();
            }
        };
    }

    protected ContainerListener createContainerListener() {
        return new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component added = e.getChild();
                if (added != WSplitPaneUI.this.getDivider() && added != WSplitPaneUI.this.getNonContinuousLayoutDivider()) {
                    WSplitPaneUI.this.addSideComponentListener(added);
                }
                WSplitPaneUI.this.updateDividerVisibility();
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component removed = e.getChild();
                if (removed != WSplitPaneUI.this.getDivider() && removed != WSplitPaneUI.this.getNonContinuousLayoutDivider()) {
                    WSplitPaneUI.this.removeSideComponentListener(removed);
                }
                WSplitPaneUI.this.updateDividerVisibility();
            }
        };
    }

    protected void addSideComponentListener(Component component) {
        if (component != null) {
            component.addComponentListener(this.componentListener);
        }
    }

    protected void removeSideComponentListener(Component component) {
        if (component != null) {
            component.removeComponentListener(this.componentListener);
        }
    }

    protected void updateDividerVisibility() {
        if (this.getDivider() != null) {
            Component left = ((JSplitPane)this.splitPane).getLeftComponent();
            Component right = ((JSplitPane)this.splitPane).getRightComponent();
            this.getDivider().setVisible(left != null && left.isVisible() && right != null && right.isVisible());
            ((JComponent)this.splitPane).revalidate();
            ((Component)this.splitPane).repaint();
        }
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if (WSplitPaneUI.this.getNonContinuousLayoutDivider() != null && Objects.equals((Object)event.getPropertyName(), (Object[])new Object[]{"orientation", "oneTouchExpandable"})) {
                    DecorationUtils.fireStatesChanged(WSplitPaneUI.this.getNonContinuousLayoutDivider());
                }
            }
        };
    }

    protected SplitPaneInputListener<C> createInputListener() {
        return new WSplitPaneInputListener();
    }

    protected int getOrientation() {
        return this.orientation;
    }

    protected void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    protected boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    protected void setContinuousLayout(boolean continuous) {
        this.continuousLayout = continuous;
    }

    public int getLastDragLocation() {
        return this.lastDragLocation;
    }

    public void setLastDragLocation(int location) {
        this.lastDragLocation = location;
    }

    protected boolean isDividerLocationSet() {
        return this.dividerLocationIsSet;
    }

    protected void setDividerLocationSet(boolean set) {
        this.dividerLocationIsSet = set;
    }

    protected boolean isDividerKeyboardResize() {
        return this.dividerKeyboardResize;
    }

    protected void setDividerKeyboardResize(boolean active) {
        this.dividerKeyboardResize = active;
    }

    protected boolean isIgnoreDividerLocationChange() {
        return this.ignoreDividerLocationChange;
    }

    protected void setIgnoreDividerLocationChange(boolean ignore) {
        this.ignoreDividerLocationChange = ignore;
    }

    protected int getKeyboardMoveIncrement() {
        return 3;
    }

    public JSplitPane getSplitPane() {
        return this.splitPane;
    }

    public void setDividerSize(int dividerSize) {
        this.divider.setDividerSize(dividerSize);
        this.dividerSize = dividerSize;
    }

    public WebSplitPaneDivider getDivider() {
        return this.divider;
    }

    protected WebSplitPaneDivider createDivider() {
        return new WebSplitPaneDivider(StyleId.splitpaneContinuousDivider.at((JComponent)this.splitPane), (JSplitPane)this.splitPane);
    }

    public JComponent getNonContinuousLayoutDivider() {
        return this.nonContinuousLayoutDivider;
    }

    protected JComponent createNonContinuousDivider() {
        return new NonContinuousDivider();
    }

    protected void setNonContinuousLayoutDivider(JComponent divider) {
        this.setNonContinuousLayoutDivider(divider, true);
    }

    protected void setNonContinuousLayoutDivider(JComponent divider, boolean rememberSizes) {
        this.rememberPaneSizes = rememberSizes;
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            ((JSplitPane)this.splitPane).remove(this.nonContinuousLayoutDivider);
        }
        this.nonContinuousLayoutDivider = divider;
    }

    protected void addHeavyweightDivider() {
        if (this.nonContinuousLayoutDivider != null && this.splitPane != null) {
            Component leftC = ((JSplitPane)this.splitPane).getLeftComponent();
            Component rightC = ((JSplitPane)this.splitPane).getRightComponent();
            int lastLocation = ((JSplitPane)this.splitPane).getDividerLocation();
            if (leftC != null) {
                ((JSplitPane)this.splitPane).setLeftComponent(null);
            }
            if (rightC != null) {
                ((JSplitPane)this.splitPane).setRightComponent(null);
            }
            ((JSplitPane)this.splitPane).remove(this.divider);
            ((Container)this.splitPane).add(this.nonContinuousLayoutDivider, NON_CONTINUOUS_DIVIDER, ((Container)this.splitPane).getComponentCount());
            ((JSplitPane)this.splitPane).setLeftComponent(leftC);
            ((JSplitPane)this.splitPane).setRightComponent(rightC);
            ((Container)this.splitPane).add((Component)this.divider, "divider");
            if (this.rememberPaneSizes) {
                ((JSplitPane)this.splitPane).setDividerLocation(lastLocation);
            }
        }
    }

    @Override
    public void resetToPreferredSizes(JSplitPane jc) {
        if (this.splitPane != null) {
            this.layoutManager.resetToPreferredSizes();
            ((JComponent)this.splitPane).revalidate();
            ((Component)this.splitPane).repaint();
        }
    }

    @Override
    public void setDividerLocation(JSplitPane jc, int location) {
        if (!this.isIgnoreDividerLocationChange()) {
            this.setDividerLocationSet(true);
            ((JComponent)this.splitPane).revalidate();
            ((Component)this.splitPane).repaint();
            if (this.keepHidden) {
                Insets insets = ((JComponent)this.splitPane).getInsets();
                int orientation = ((JSplitPane)this.splitPane).getOrientation();
                if (orientation == 0 && location != insets.top && location != ((JComponent)this.splitPane).getHeight() - this.divider.getHeight() - insets.top || orientation == 1 && location != insets.left && location != ((JComponent)this.splitPane).getWidth() - this.divider.getWidth() - insets.left) {
                    this.setKeepHidden(false);
                }
            }
        } else {
            this.setIgnoreDividerLocationChange(false);
        }
    }

    @Override
    public int getDividerLocation(JSplitPane jc) {
        return this.getOrientation() == 1 ? this.divider.getLocation().x : this.divider.getLocation().y;
    }

    @Override
    public int getMinimumDividerLocation(JSplitPane jc) {
        int minLoc = 0;
        Component leftC = ((JSplitPane)this.splitPane).getLeftComponent();
        if (leftC != null && leftC.isVisible()) {
            Insets insets = ((JComponent)this.splitPane).getInsets();
            Dimension minSize = leftC.getMinimumSize();
            minLoc = this.getOrientation() == 1 ? minSize.width : minSize.height;
            if (insets != null) {
                minLoc = this.getOrientation() == 1 ? (minLoc += insets.left) : (minLoc += insets.top);
            }
        }
        return minLoc;
    }

    @Override
    public int getMaximumDividerLocation(JSplitPane jc) {
        Dimension splitPaneSize = ((Component)this.splitPane).getSize();
        int maxLoc = 0;
        Component rightC = ((JSplitPane)this.splitPane).getRightComponent();
        if (rightC != null) {
            Insets insets = ((JComponent)this.splitPane).getInsets();
            Dimension minSize = new Dimension(0, 0);
            if (rightC.isVisible()) {
                minSize = rightC.getMinimumSize();
            }
            maxLoc = this.getOrientation() == 1 ? splitPaneSize.width - minSize.width : splitPaneSize.height - minSize.height;
            maxLoc -= this.dividerSize;
            if (insets != null) {
                maxLoc = this.getOrientation() == 1 ? (maxLoc -= insets.right) : (maxLoc -= insets.top);
            }
        }
        return Math.max(this.getMinimumDividerLocation((JSplitPane)this.splitPane), maxLoc);
    }

    @Override
    public void finishedPaintingChildren(JSplitPane jc, Graphics g) {
    }

    @Override
    public void paint(Graphics g, JComponent jc) {
        if (!this.painted && ((JSplitPane)this.splitPane).getDividerLocation() < 0) {
            this.setIgnoreDividerLocationChange(true);
            ((JSplitPane)this.splitPane).setDividerLocation(this.getDividerLocation((JSplitPane)this.splitPane));
        }
        this.painted = true;
    }

    @Override
    public Dimension getPreferredSize(JComponent jc) {
        return this.splitPane != null ? this.layoutManager.preferredLayoutSize((Container)this.splitPane) : new Dimension(0, 0);
    }

    @Override
    public Dimension getMinimumSize(JComponent jc) {
        return this.splitPane != null ? this.layoutManager.minimumLayoutSize((Container)this.splitPane) : new Dimension(0, 0);
    }

    @Override
    public Dimension getMaximumSize(JComponent jc) {
        return this.splitPane != null ? this.layoutManager.maximumLayoutSize((Container)this.splitPane) : new Dimension(0, 0);
    }

    protected void resetLayoutManager() {
        this.layoutManager = new SplitPaneLayout(this.getOrientation());
        ((Container)this.splitPane).setLayout(this.layoutManager);
        this.layoutManager.updateComponents((JSplitPane)this.splitPane);
        ((JComponent)this.splitPane).revalidate();
        ((Component)this.splitPane).repaint();
    }

    protected void setKeepHidden(boolean keepHidden) {
        this.keepHidden = keepHidden;
    }

    protected boolean isKeepHidden() {
        return this.keepHidden;
    }

    protected boolean isPainted() {
        return this.painted;
    }

    protected void startDragging() {
        this.beginDragDividerLocation = this.getDividerLocation((JSplitPane)this.splitPane);
        if (this.getOrientation() == 1) {
            this.setLastDragLocation(this.divider.getBounds().x);
            this.dividerSize = this.divider.getSize().width;
            if (!this.isContinuousLayout()) {
                Rectangle border = BoundsType.border.bounds((Component)this.splitPane);
                this.getNonContinuousLayoutDivider().setBounds(this.getLastDragLocation(), border.y, this.dividerSize, border.height);
                this.addHeavyweightDivider();
            }
        } else {
            this.setLastDragLocation(this.divider.getBounds().y);
            this.dividerSize = this.divider.getSize().height;
            if (!this.isContinuousLayout()) {
                Rectangle border = BoundsType.border.bounds((Component)this.splitPane);
                this.getNonContinuousLayoutDivider().setBounds(border.x, this.getLastDragLocation(), border.width, this.dividerSize);
                this.addHeavyweightDivider();
            }
        }
    }

    protected void dragDividerTo(int location) {
        if (this.getLastDragLocation() != location) {
            if (this.isContinuousLayout()) {
                ((JSplitPane)this.splitPane).setDividerLocation(location);
                this.setLastDragLocation(location);
            } else {
                this.setLastDragLocation(location);
                Rectangle border = BoundsType.border.bounds((Component)this.splitPane);
                if (this.getOrientation() == 1) {
                    this.getNonContinuousLayoutDivider().setLocation(this.getLastDragLocation(), border.y);
                } else {
                    this.getNonContinuousLayoutDivider().setLocation(border.x, this.getLastDragLocation());
                }
            }
        }
    }

    protected void finishDraggingTo(int location) {
        this.dragDividerTo(location);
        this.setLastDragLocation(-1);
        if (!this.isContinuousLayout()) {
            Rectangle border = BoundsType.border.bounds((Component)this.splitPane);
            if (this.getOrientation() == 1) {
                this.getNonContinuousLayoutDivider().setLocation(-this.dividerSize, border.y);
            } else {
                this.getNonContinuousLayoutDivider().setLocation(border.x, -this.dividerSize);
            }
            ((JSplitPane)this.splitPane).remove(this.getNonContinuousLayoutDivider());
            ((JSplitPane)this.splitPane).setDividerLocation(location);
        }
    }

    public class NonContinuousDivider
    extends WebCanvas {
        public NonContinuousDivider() {
            super(StyleId.splitpaneNonContinuousDivider.at((JComponent)WSplitPaneUI.this.splitPane), new String[0]);
        }

        @Override
        @NotNull
        public List<String> getStates() {
            List<String> states = super.getStates();
            JSplitPane splitPane = WSplitPaneUI.this.getSplitPane();
            if (splitPane != null) {
                boolean vertical = splitPane.getOrientation() == 1;
                states.add(vertical ? "vertical" : "horizontal");
                if (splitPane.isOneTouchExpandable()) {
                    states.add("one-touch");
                }
            }
            return states;
        }
    }
}

