/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.merge.Mergeable;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.button.WebButton;
import com.alee.laf.tabbedpane.TabArea;
import com.alee.laf.tabbedpane.TabMenuButton;
import com.alee.laf.tabbedpane.TabViewport;
import com.alee.laf.tabbedpane.WebTabbedPane;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

@XStreamAlias(value="TabAreaLayout")
public class TabAreaLayout
extends AbstractLayoutManager
implements Mergeable,
Cloneable,
Serializable {
    @Override
    public void layoutContainer(@NotNull Container parent) {
        JComponent trailing;
        TabArea tabArea = (TabArea)parent;
        JTabbedPane tabbedPane = tabArea.getTabbedPane();
        int tabPlacement = tabbedPane.getTabPlacement();
        boolean horizontal = tabPlacement == 1 || tabPlacement == 3;
        boolean ltr = tabbedPane.getComponentOrientation().isLeftToRight();
        TabViewport tabViewport = null;
        TabMenuButton tabMenuButton = null;
        for (int i = 0; i < tabArea.getComponentCount(); ++i) {
            Component component = tabArea.getComponent(i);
            if (component instanceof TabViewport) {
                tabViewport = (TabViewport)component;
                continue;
            }
            if (!(component instanceof TabMenuButton)) continue;
            tabMenuButton = (TabMenuButton)component;
        }
        Insets insets = tabArea.getInsets();
        Rectangle available = SwingUtils.shrink(new Rectangle(0, 0, parent.getWidth(), parent.getHeight()), insets);
        JComponent leading = WebTabbedPane.LEADING_TAB_AREA_COMPONENT_PROPERTY.get(tabbedPane);
        if (leading != null) {
            Dimension lps = leading.getPreferredSize();
            leading.setBounds(horizontal ? (ltr ? available.x : available.x + available.width - lps.width) : available.x, available.y, horizontal ? lps.width : available.width, horizontal ? available.height : lps.height);
            available.x = available.x + (horizontal && ltr ? lps.width : 0);
            available.y = available.y + (horizontal ? 0 : lps.height);
            available.width = available.width - (horizontal ? lps.width : 0);
            available.height = available.height - (horizontal ? 0 : lps.height);
        }
        if ((trailing = WebTabbedPane.TRAILING_TAB_AREA_COMPONENT_PROPERTY.get(tabbedPane)) != null) {
            Dimension tps = trailing.getPreferredSize();
            trailing.setBounds(horizontal ? (ltr ? available.x + available.width - tps.width : available.x) : available.x, horizontal ? available.y : available.y + available.height - tps.height, horizontal ? tps.width : available.width, horizontal ? available.height : tps.height);
            available.x = available.x + (horizontal && !ltr ? tps.width : 0);
            available.width = available.width - (horizontal ? tps.width : 0);
            available.height = available.height - (horizontal ? 0 : tps.height);
        }
        if (tabMenuButton != null && tabMenuButton.isVisible()) {
            Dimension mps = tabMenuButton.getPreferredSize();
            tabMenuButton.setBounds(horizontal ? (ltr ? available.x + available.width - mps.width : available.x) : available.x, horizontal ? available.y : available.y + available.height - mps.height, horizontal ? mps.width : available.width, horizontal ? available.height : mps.height);
            available.x = available.x + (horizontal && !ltr ? mps.width : 0);
            available.width = available.width - (horizontal ? mps.width : 0);
            available.height = available.height - (horizontal ? 0 : mps.height);
        }
        if (tabViewport != null) {
            tabViewport.setBounds(available);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container parent) {
        TabArea tabArea = (TabArea)parent;
        JTabbedPane tabbedPane = tabArea.getTabbedPane();
        JComponent tabViewport = null;
        Component tabMenu = null;
        for (int i = 0; i < tabArea.getComponentCount(); ++i) {
            Component component = tabArea.getComponent(i);
            if (component instanceof TabViewport) {
                tabViewport = (TabViewport)component;
                continue;
            }
            if (!(component instanceof TabMenuButton)) continue;
            tabMenu = (TabMenuButton)component;
        }
        Dimension vps = tabViewport != null ? tabViewport.getPreferredSize() : new Dimension(0, 0);
        Dimension mps = tabMenu != null && tabMenu.isVisible() ? ((WebButton)tabMenu).getPreferredSize() : new Dimension(0, 0);
        JComponent leading = WebTabbedPane.LEADING_TAB_AREA_COMPONENT_PROPERTY.get(tabbedPane);
        Dimension lps = leading != null ? leading.getPreferredSize() : new Dimension(0, 0);
        JComponent trailing = WebTabbedPane.TRAILING_TAB_AREA_COMPONENT_PROPERTY.get(tabbedPane);
        Dimension tps = trailing != null ? trailing.getPreferredSize() : new Dimension(0, 0);
        Insets insets = tabArea.getInsets();
        int tabPlacement = tabbedPane.getTabPlacement();
        boolean horizontal = tabPlacement == 1 || tabPlacement == 3;
        return new Dimension(horizontal ? insets.left + lps.width + Math.max(vps.width, mps.width * 2) + tps.width + insets.right : insets.left + MathUtils.max((int[])new int[]{lps.width, vps.width, mps.width, tps.width}) + insets.right, horizontal ? insets.top + MathUtils.max((int[])new int[]{lps.height, vps.height, mps.height, tps.height}) + insets.bottom : insets.top + lps.height + Math.max(vps.height, mps.height * 2) + tps.height + insets.bottom);
    }

    @XStreamAlias(value="TabAreaLayout$UIResource")
    public static final class UIResource
    extends TabAreaLayout
    implements javax.swing.plaf.UIResource {
    }
}

