/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.tabbedpane.Tab;
import com.alee.laf.tabbedpane.WTabbedPaneUI;
import com.alee.managers.tooltip.AbstractComponentArea;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTabbedPane;
import javax.swing.plaf.TabbedPaneUI;

public class TabbedPaneTabArea<V, C extends JTabbedPane>
extends AbstractComponentArea<V, C> {
    protected final int tab;

    public TabbedPaneTabArea(int tab) {
        this.tab = tab;
    }

    public int tab() {
        return this.tab;
    }

    @Override
    public boolean isAvailable(@NotNull C component) {
        return 0 <= this.tab && this.tab < ((JTabbedPane)component).getTabCount();
    }

    @Override
    @Nullable
    public Rectangle getBounds(@NotNull C component) {
        TabbedPaneUI ui;
        Rectangle bounds = ((JTabbedPane)component).getBoundsAt(this.tab);
        if (bounds != null && (ui = ((JTabbedPane)component).getUI()) instanceof WTabbedPaneUI) {
            Tab tab = ((WTabbedPaneUI)ui).getTab(this.tab);
            this.adjustBounds(component, (Component)tab, bounds);
        }
        return bounds;
    }

    @Override
    @Nullable
    public V getValue(@NotNull C component) {
        return (V)((JTabbedPane)component).getComponentAt(this.tab);
    }

    @Override
    protected void adjustBounds(@NotNull C component, @NotNull Component content, @NotNull Rectangle bounds) {
        if (content instanceof Tab) {
            Tab tab = (Tab)content;
            if (tab.getComponent() == null) {
                int align = tab.getHorizontalAlignment();
                this.adjustBounds(component, tab, bounds, align);
            } else {
                Component tabComponent = tab.getComponent();
                Rectangle tabComponentBounds = tabComponent.getBounds();
                tabComponentBounds.x += bounds.x;
                tabComponentBounds.y += bounds.y;
                this.adjustBounds(component, tabComponent, tabComponentBounds);
            }
        } else {
            super.adjustBounds(component, content, bounds);
        }
    }

    public boolean equals(Object other) {
        return other instanceof TabbedPaneTabArea && this.tab == ((TabbedPaneTabArea)other).tab;
    }
}

