/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tabbedpane;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.laf.AbstractUIInputListener;
import com.alee.laf.UIAction;
import com.alee.laf.UIActionMap;
import com.alee.laf.tabbedpane.Tab;
import com.alee.laf.tabbedpane.TabContainer;
import com.alee.laf.tabbedpane.TabbedPaneInputListener;
import com.alee.laf.tabbedpane.WTabbedPaneUI;
import com.alee.laf.viewport.WebViewport;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.LafLookup;
import com.alee.utils.MathUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.TabbedPaneUI;

public class WTabbedPaneInputListener<C extends JTabbedPane, U extends WTabbedPaneUI<C>>
extends AbstractUIInputListener<C, U>
implements TabbedPaneInputListener<C>,
PropertyChangeListener,
MouseListener,
MouseWheelListener {
    protected InputMap mnemonicInputMap;

    @Override
    public void install(@NotNull C component) {
        super.install(component);
        ((Container)component).addPropertyChangeListener(this);
        ((Component)component).addMouseListener(this);
        ((Component)component).addMouseWheelListener(this);
        UIActionMap actionMap = new UIActionMap();
        actionMap.put(new Actions<C>(component, "navigateNext"));
        actionMap.put(new Actions<C>(component, "navigatePrevious"));
        actionMap.put(new Actions<C>(component, "navigateRight"));
        actionMap.put(new Actions<C>(component, "navigateLeft"));
        actionMap.put(new Actions<C>(component, "navigateUp"));
        actionMap.put(new Actions<C>(component, "navigateDown"));
        actionMap.put(new Actions<C>(component, "navigatePageUp"));
        actionMap.put(new Actions<C>(component, "navigatePageDown"));
        actionMap.put(new Actions<C>(component, "requestFocus"));
        actionMap.put(new Actions<C>(component, "requestFocusForVisibleComponent"));
        actionMap.put(new Actions<C>(component, "setSelectedIndex"));
        actionMap.put(new Actions<C>(component, "scrollTabsForwardAction"));
        actionMap.put(new Actions<C>(component, "scrollTabsBackwardAction"));
        SwingUtilities.replaceUIActionMap(component, actionMap);
        InputMap focusedMap = LafLookup.getInputMap(component, 0);
        SwingUtilities.replaceUIInputMap(component, 0, focusedMap);
        InputMap ancestorMap = LafLookup.getInputMap(component, 1);
        SwingUtilities.replaceUIInputMap(component, 1, ancestorMap);
        this.mnemonicInputMap = new ComponentInputMapUIResource((JComponent)component);
        this.mnemonicInputMap.setParent(SwingUtilities.getUIInputMap(component, 2));
        SwingUtilities.replaceUIInputMap(component, 2, this.mnemonicInputMap);
    }

    @Override
    public void uninstall(@NotNull C component) {
        SwingUtilities.replaceUIInputMap(component, 2, null);
        this.mnemonicInputMap = null;
        SwingUtilities.replaceUIInputMap(component, 1, null);
        SwingUtilities.replaceUIInputMap(component, 0, null);
        SwingUtilities.replaceUIActionMap(component, null);
        ((Component)component).removeMouseWheelListener(this);
        ((Component)component).removeMouseListener(this);
        ((Component)component).removePropertyChangeListener(this);
        super.uninstall(component);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if (Objects.equals((Object)property, (Object)"mnemonicAt")) {
            this.updateMnemonics();
        } else if (Objects.equals((Object)property, (Object)"displayedMnemonicIndexAt")) {
            this.updateDisplayedMnemonics();
        }
    }

    @Override
    public void tabAdded(@NotNull Tab tab, int index) {
        this.updateMnemonics();
    }

    @Override
    public void tabRemoved(int index) {
        this.updateMnemonics();
    }

    protected void updateMnemonics() {
        this.resetMnemonics();
        for (int counter = ((JTabbedPane)this.component).getTabCount() - 1; counter >= 0; --counter) {
            int mnemonic = ((JTabbedPane)this.component).getMnemonicAt(counter);
            if (mnemonic <= 0) continue;
            this.mnemonicInputMap.put(KeyStroke.getKeyStroke(mnemonic, 8), "setSelectedIndex");
        }
    }

    protected void resetMnemonics() {
        this.mnemonicInputMap.clear();
    }

    protected void updateDisplayedMnemonics() {
        TabContainer tabContainer = ((WTabbedPaneUI)this.componentUI).getTabContainer();
        if (tabContainer != null) {
            for (int i = 0; i < tabContainer.getComponentCount(); ++i) {
                Tab tab = (Tab)tabContainer.getComponent(i);
                tab.setDisplayedMnemonicIndex(((JTabbedPane)this.component).getDisplayedMnemonicIndexAt(i));
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int tabIndex;
        if (((JTabbedPane)this.component).isEnabled() && (tabIndex = ((WTabbedPaneUI)this.componentUI).tabForCoordinate((JTabbedPane)this.component, e.getX(), e.getY())) >= 0 && ((JTabbedPane)this.component).isEnabledAt(tabIndex)) {
            if (tabIndex != ((JTabbedPane)this.component).getSelectedIndex()) {
                ((JTabbedPane)this.component).setSelectedIndex(tabIndex);
            } else if (((JTabbedPane)this.component).isRequestFocusEnabled()) {
                ((JTabbedPane)this.component).requestFocusInWindow();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        WebViewport tabViewport = ((WTabbedPaneUI)this.componentUI).getTabViewport();
        TabContainer tabContainer = ((WTabbedPaneUI)this.componentUI).getTabContainer();
        if (tabViewport != null && tabContainer != null && tabViewport.isShowing() && CoreSwingUtils.getRelativeBounds((Component)tabContainer, (Component)this.component).contains(e.getPoint())) {
            int tabPlacement = ((JTabbedPane)this.component).getTabPlacement();
            boolean horizontal = tabPlacement == 1 || tabPlacement == 3;
            Point viewPosition = tabViewport.getViewPosition();
            tabViewport.setViewPosition(new Point(horizontal ? MathUtils.limit((int)0, (int)(viewPosition.x + 5 * e.getUnitsToScroll()), (int)(tabViewport.getViewSize().width - tabViewport.getExtentSize().width)) : viewPosition.x, horizontal ? viewPosition.y : MathUtils.limit((int)0, (int)(viewPosition.y + 5 * e.getUnitsToScroll()), (int)(tabViewport.getViewSize().height - tabViewport.getExtentSize().height))));
        }
    }

    public static class Actions<T extends JTabbedPane>
    extends UIAction<T> {
        public static final String NEXT = "navigateNext";
        public static final String PREVIOUS = "navigatePrevious";
        public static final String RIGHT = "navigateRight";
        public static final String LEFT = "navigateLeft";
        public static final String UP = "navigateUp";
        public static final String DOWN = "navigateDown";
        public static final String PAGE_UP = "navigatePageUp";
        public static final String PAGE_DOWN = "navigatePageDown";
        public static final String REQUEST_FOCUS = "requestFocus";
        public static final String REQUEST_FOCUS_FOR_VISIBLE = "requestFocusForVisibleComponent";
        public static final String SET_SELECTED = "setSelectedIndex";
        public static final String SCROLL_FORWARD = "scrollTabsForwardAction";
        public static final String SCROLL_BACKWARD = "scrollTabsBackwardAction";

        public Actions(@NotNull T tabbedPane, @NotNull String name) {
            super(tabbedPane, name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String key = this.getName();
            JTabbedPane tabbedPane = (JTabbedPane)this.getComponent();
            if (key.equals(NEXT)) {
                this.selectTab(tabbedPane, 12);
            } else if (key.equals(PREVIOUS)) {
                this.selectTab(tabbedPane, 13);
            } else if (key.equals(RIGHT)) {
                this.selectTab(tabbedPane, 3);
            } else if (key.equals(LEFT)) {
                this.selectTab(tabbedPane, 7);
            } else if (key.equals(UP)) {
                this.selectTab(tabbedPane, 1);
            } else if (key.equals(DOWN)) {
                this.selectTab(tabbedPane, 5);
            } else if (key.equals(PAGE_UP)) {
                int tabPlacement = tabbedPane.getTabPlacement();
                if (tabPlacement == 1 || tabPlacement == 3) {
                    this.selectTab(tabbedPane, 7);
                } else {
                    this.selectTab(tabbedPane, 1);
                }
            } else if (key.equals(PAGE_DOWN)) {
                int tabPlacement = tabbedPane.getTabPlacement();
                if (tabPlacement == 1 || tabPlacement == 3) {
                    this.selectTab(tabbedPane, 3);
                } else {
                    this.selectTab(tabbedPane, 5);
                }
            } else if (key.equals(REQUEST_FOCUS)) {
                tabbedPane.requestFocusInWindow();
            } else if (key.equals(REQUEST_FOCUS_FOR_VISIBLE)) {
                this.requestFocusForVisibleComponent(tabbedPane);
            } else if (key.equals(SET_SELECTED)) {
                String command = e.getActionCommand();
                if (command != null && command.length() > 0) {
                    int mnemonic = e.getActionCommand().charAt(0);
                    if (mnemonic >= 97 && mnemonic <= 122) {
                        mnemonic -= 32;
                    }
                    for (int i = 0; i < tabbedPane.getTabCount(); ++i) {
                        if (mnemonic != tabbedPane.getMnemonicAt(i)) continue;
                        tabbedPane.setSelectedIndex(i);
                        break;
                    }
                }
            } else if (key.equals(SCROLL_FORWARD)) {
                if (tabbedPane.getTabLayoutPolicy() == 1) {
                    this.scrollForward(tabbedPane);
                }
            } else if (key.equals(SCROLL_BACKWARD) && tabbedPane.getTabLayoutPolicy() == 1) {
                this.scrollBackward(tabbedPane);
            }
        }

        protected void selectTab(T tabbedPane, int direction) {
            int tabCount = ((JTabbedPane)tabbedPane).getTabCount();
            if (tabCount > 0) {
                int tabPlacement = ((JTabbedPane)tabbedPane).getTabPlacement();
                int current = ((JTabbedPane)tabbedPane).getSelectedIndex();
                boolean leftToRight = ((Component)tabbedPane).getComponentOrientation().isLeftToRight();
                block0 : switch (tabPlacement) {
                    case 1: 
                    case 3: {
                        switch (direction) {
                            case 5: 
                            case 12: {
                                this.selectNextTab(tabbedPane, current);
                                break;
                            }
                            case 1: 
                            case 13: {
                                this.selectPreviousTab(tabbedPane, current);
                                break;
                            }
                            case 7: {
                                if (leftToRight) {
                                    this.selectPreviousTab(tabbedPane, current);
                                    break;
                                }
                                this.selectNextTab(tabbedPane, current);
                                break;
                            }
                            case 3: {
                                if (leftToRight) {
                                    this.selectNextTab(tabbedPane, current);
                                    break;
                                }
                                this.selectPreviousTab(tabbedPane, current);
                            }
                        }
                        break;
                    }
                    case 2: 
                    case 4: {
                        switch (direction) {
                            case 5: 
                            case 12: {
                                this.selectNextTab(tabbedPane, current);
                                break block0;
                            }
                            case 1: 
                            case 13: {
                                this.selectPreviousTab(tabbedPane, current);
                                break block0;
                            }
                            case 7: {
                                if (tabPlacement == 2 == leftToRight) {
                                    this.selectPreviousTab(tabbedPane, current);
                                    break block0;
                                }
                                this.selectNextTab(tabbedPane, current);
                                break block0;
                            }
                            case 3: {
                                if (tabPlacement == 2 == leftToRight) {
                                    this.selectNextTab(tabbedPane, current);
                                    break block0;
                                }
                                this.selectPreviousTab(tabbedPane, current);
                            }
                        }
                    }
                }
            }
        }

        protected void selectNextTab(@NotNull T tabbedPane, int current) {
            int tabIndex = this.getNextTabIndex(tabbedPane, current);
            while (tabIndex != current && !((JTabbedPane)tabbedPane).isEnabledAt(tabIndex)) {
                tabIndex = this.getNextTabIndex(tabbedPane, tabIndex);
            }
            ((JTabbedPane)tabbedPane).setSelectedIndex(tabIndex);
        }

        protected void selectPreviousTab(@NotNull T tabbedPane, int current) {
            int tabIndex = this.getPreviousTabIndex(tabbedPane, current);
            while (tabIndex != current && !((JTabbedPane)tabbedPane).isEnabledAt(tabIndex)) {
                tabIndex = this.getPreviousTabIndex(tabbedPane, tabIndex);
            }
            ((JTabbedPane)tabbedPane).setSelectedIndex(tabIndex);
        }

        protected int getPreviousTabIndex(@NotNull T tabbedPane, int base) {
            return base > 0 ? base - 1 : 0;
        }

        protected int getNextTabIndex(@NotNull T tabbedPane, int base) {
            return base < ((JTabbedPane)tabbedPane).getTabCount() - 1 ? base + 1 : ((JTabbedPane)tabbedPane).getTabCount() - 1;
        }

        protected void requestFocusForVisibleComponent(@NotNull T tabbedPane) {
            Component component = ((JTabbedPane)tabbedPane).getSelectedComponent();
            if (component != null) {
                component.transferFocus();
            }
        }

        protected void scrollForward(T tabbedPane) {
            this.scroll(tabbedPane, 1);
        }

        protected void scrollBackward(T tabbedPane) {
            this.scroll(tabbedPane, -1);
        }

        protected void scroll(T tabbedPane, int scrollAmount) {
            TabContainer tabContainer;
            TabbedPaneUI ui = ((JTabbedPane)tabbedPane).getUI();
            if (ui instanceof WTabbedPaneUI && (tabContainer = ((WTabbedPaneUI)ui).getTabContainer()) != null) {
                boolean horizontal = ((JTabbedPane)tabbedPane).getTabPlacement() == 1 || ((JTabbedPane)tabbedPane).getTabPlacement() == 3;
                Rectangle vr = tabContainer.getVisibleRect();
                Rectangle bounds = new Rectangle(tabContainer.getSize());
                if (horizontal) {
                    vr.x += scrollAmount * vr.width;
                } else {
                    vr.y += scrollAmount * vr.height;
                }
                tabContainer.scrollRectToVisible(bounds.intersection(vr));
            }
        }
    }
}

