/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.table.ITablePainter;
import com.alee.laf.table.WebTable;
import com.alee.laf.table.WebTableUI;
import com.alee.managers.style.AbstractComponentDescriptor;
import com.alee.managers.style.StyleId;
import com.alee.utils.ReflectUtils;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public abstract class AbstractTableDescriptor<C extends JTable, U extends WebTableUI, P extends ITablePainter>
extends AbstractComponentDescriptor<C, U, P> {
    public AbstractTableDescriptor(@NotNull String id, @NotNull Class<C> componentClass, @NotNull String uiClassId, @NotNull Class<U> baseUIClass, @NotNull Class<? extends U> uiClass, @NotNull Class<P> painterInterface, @NotNull Class<? extends P> painterClass, @NotNull Class<? extends P> painterAdapterClass, @NotNull StyleId defaultStyleId) {
        super(id, componentClass, uiClassId, baseUIClass, uiClass, painterInterface, painterClass, painterAdapterClass, defaultStyleId);
    }

    @Override
    public void updateUI(@NotNull C component) {
        JTableHeader header;
        Hashtable defaultEditorsByColumnClass;
        TableColumnModel cm = ((JTable)component).getColumnModel();
        for (int column = 0; column < cm.getColumnCount(); ++column) {
            TableColumn aColumn = cm.getColumn(column);
            this.updateRendererOrEditorUI(aColumn.getCellRenderer());
            this.updateRendererOrEditorUI(aColumn.getCellEditor());
            this.updateRendererOrEditorUI(aColumn.getHeaderRenderer());
        }
        Hashtable defaultRenderersByColumnClass = (Hashtable)ReflectUtils.getFieldValueSafely(component, (String)"defaultRenderersByColumnClass");
        if (defaultRenderersByColumnClass != null) {
            Enumeration defaultRenderers = defaultRenderersByColumnClass.elements();
            while (defaultRenderers.hasMoreElements()) {
                this.updateRendererOrEditorUI(defaultRenderers.nextElement());
            }
        }
        if ((defaultEditorsByColumnClass = (Hashtable)ReflectUtils.getFieldValueSafely(component, (String)"defaultEditorsByColumnClass")) != null) {
            Enumeration defaultEditors = defaultEditorsByColumnClass.elements();
            while (defaultEditors.hasMoreElements()) {
                this.updateRendererOrEditorUI(defaultEditors.nextElement());
            }
        }
        if ((header = ((JTable)component).getTableHeader()) != null) {
            header.updateUI();
        }
        if (component instanceof WebTable) {
            ((WebTable)component).configureScrollPane();
        } else {
            ReflectUtils.callMethodSafely(component, (String)"configureEnclosingScrollPaneUI", (Object[])new Object[0]);
        }
        super.updateUI(component);
    }

    private void updateRendererOrEditorUI(@Nullable Object rendererOrEditor) {
        if (rendererOrEditor != null) {
            Component component = null;
            if (rendererOrEditor instanceof Component) {
                component = (Component)rendererOrEditor;
            }
            if (rendererOrEditor instanceof DefaultCellEditor) {
                component = ((DefaultCellEditor)rendererOrEditor).getComponent();
            }
            if (component != null) {
                SwingUtilities.updateComponentTreeUI(component);
            }
        }
    }
}

