/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.tooltip.AbstractComponentArea;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TableCellArea<V, C extends JTable>
extends AbstractComponentArea<V, C> {
    protected final int row;
    protected final int column;

    public TableCellArea(int row, int column) {
        this.row = row;
        this.column = column;
    }

    public int row() {
        return this.row;
    }

    public int column() {
        return this.column;
    }

    @Override
    public boolean isAvailable(@NotNull C component) {
        return 0 <= this.row && this.row < ((JTable)component).getRowCount() && 0 <= this.column && this.column < ((JTable)component).getColumnCount();
    }

    @Override
    @Nullable
    public Rectangle getBounds(@NotNull C component) {
        Rectangle bounds = ((JTable)component).getCellRect(this.row, this.column, false);
        TableCellRenderer cellRenderer = ((JTable)component).getCellRenderer(this.row, this.column);
        Component renderer = ((JTable)component).prepareRenderer(cellRenderer, this.row, this.column);
        this.adjustBounds(component, renderer, bounds);
        return bounds;
    }

    @Override
    @Nullable
    public V getValue(@NotNull C component) {
        return (V)((JTable)component).getValueAt(this.row, this.column);
    }

    public boolean equals(Object other) {
        return other instanceof TableCellArea && this.row == ((TableCellArea)other).row && this.column == ((TableCellArea)other).column;
    }
}

