/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.api.jdk.Objects;
import com.alee.api.ui.RenderingParameters;
import com.alee.laf.table.TableCellArea;
import java.awt.Component;
import javax.swing.JTable;

public class TableCellParameters<V, C extends JTable>
implements RenderingParameters {
    protected final C table;
    protected final V value;
    protected final int row;
    protected final int column;
    protected final boolean selected;
    protected final boolean focused;

    public TableCellParameters(C table, TableCellArea<V, C> area) {
        this(table, area.row(), area.column());
    }

    public TableCellParameters(C table, int row, int column) {
        this.table = (JTable)Objects.requireNonNull(table, (String)"Table must not be null");
        this.value = ((JTable)table).getModel().getValueAt(row, column);
        this.row = row;
        this.column = column;
        this.selected = ((JTable)table).isCellSelected(row, column);
        this.focused = ((Component)table).hasFocus() && ((JTable)table).getSelectionModel().getLeadSelectionIndex() == row && ((JTable)table).getColumnModel().getSelectionModel().getLeadSelectionIndex() == column;
    }

    public TableCellParameters(C table, V value, int row, int column, boolean selected, boolean focused) {
        this.table = (JTable)Objects.requireNonNull(table, (String)"Table must not be null");
        this.value = value;
        this.row = row;
        this.column = column;
        this.selected = selected;
        this.focused = focused;
    }

    public C table() {
        return this.table;
    }

    public V value() {
        return this.value;
    }

    public int row() {
        return this.row;
    }

    public int column() {
        return this.column;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isFocused() {
        return this.focused;
    }
}

