/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.table;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.table.ITableCellPainter;
import com.alee.laf.table.ITableColumnPainter;
import com.alee.laf.table.ITablePainter;
import com.alee.laf.table.ITableRowPainter;
import com.alee.laf.table.ITableSelectionPainter;
import com.alee.laf.table.TableCellArea;
import com.alee.laf.table.TableCellPainter;
import com.alee.laf.table.TableColumnPainter;
import com.alee.laf.table.TableRowPainter;
import com.alee.laf.table.TableSelectionPainter;
import com.alee.laf.table.TableToolTipProvider;
import com.alee.laf.table.WTableUI;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageSensitive;
import com.alee.managers.language.UILanguageManager;
import com.alee.painter.DefaultPainter;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GeometryUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.general.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class TablePainter<C extends JTable, U extends WTableUI, D extends IDecoration<C, D>>
extends AbstractDecorationPainter<C, U, D>
implements ITablePainter<C, U> {
    @DefaultPainter(value=TableRowPainter.class)
    protected ITableRowPainter rowPainter;
    @DefaultPainter(value=TableColumnPainter.class)
    protected ITableColumnPainter columnPainter;
    @DefaultPainter(value=TableCellPainter.class)
    protected ITableCellPainter cellPainter;
    @DefaultPainter(value=TableSelectionPainter.class)
    protected ITableSelectionPainter selectionPainter;
    @DefaultPainter(value=TableColumnPainter.class)
    protected ITableColumnPainter draggedColumnPainter;
    protected transient MouseAdapter mouseAdapter;
    protected transient LanguageListener languageSensitive;
    protected transient TableCellArea rolloverCell;
    protected transient CellRendererPane rendererPane = null;

    @Override
    @Nullable
    protected List<SectionPainter<C, U>> getSectionPainters() {
        return this.asList(this.rowPainter, this.columnPainter, this.cellPainter, this.selectionPainter, this.draggedColumnPainter);
    }

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installTableMouseListeners();
        this.installLanguageListeners();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallLanguageListeners();
        this.uninstallTableMouseListeners();
        super.uninstallPropertiesAndListeners();
    }

    protected void installTableMouseListeners() {
        this.mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (TablePainter.this.component != null) {
                    this.updateMouseover(e);
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TablePainter.this.component != null) {
                    this.updateMouseover(e);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (TablePainter.this.component != null) {
                    this.clearMouseover();
                }
            }

            private void updateMouseover(MouseEvent e) {
                Point point = e.getPoint();
                int row = ((JTable)TablePainter.this.component).rowAtPoint(point);
                int column = ((JTable)TablePainter.this.component).columnAtPoint(point);
                if (row != -1 && column != -1) {
                    TableCellArea cell = new TableCellArea(row, column);
                    if (Objects.notEquals((Object)TablePainter.this.rolloverCell, cell)) {
                        this.updateRolloverCell(TablePainter.this.rolloverCell, cell);
                    }
                } else {
                    this.clearMouseover();
                }
            }

            private void clearMouseover() {
                if (TablePainter.this.rolloverCell != null) {
                    this.updateRolloverCell(TablePainter.this.rolloverCell, null);
                }
            }

            private void updateRolloverCell(TableCellArea oldCell, TableCellArea newCell) {
                TablePainter.this.rolloverCell = newCell;
                TableToolTipProvider provider = TablePainter.this.getToolTipProvider();
                if (provider != null) {
                    provider.hoverAreaChanged(TablePainter.this.component, oldCell, newCell);
                }
            }
        };
        ((JTable)this.component).addMouseListener(this.mouseAdapter);
        ((JTable)this.component).addMouseMotionListener(this.mouseAdapter);
    }

    protected void uninstallTableMouseListeners() {
        ((JTable)this.component).removeMouseListener(this.mouseAdapter);
        ((JTable)this.component).removeMouseMotionListener(this.mouseAdapter);
        this.mouseAdapter = null;
    }

    @Nullable
    protected TableToolTipProvider getToolTipProvider() {
        return this.component != null ? (TableToolTipProvider)((JTable)this.component).getClientProperty("tooltipProvider") : null;
    }

    protected void installLanguageListeners() {
        this.languageSensitive = new LanguageListener(){

            public void languageChanged(@NotNull Language oldLanguage, @NotNull Language newLanguage) {
                TableModel model;
                if (TablePainter.this.isLanguageSensitive() && (model = ((JTable)TablePainter.this.component).getModel()).getRowCount() > 0) {
                    if (model instanceof AbstractTableModel) {
                        ((AbstractTableModel)model).fireTableRowsUpdated(0, model.getRowCount() - 1);
                    } else {
                        ((JTable)TablePainter.this.component).repaint();
                    }
                }
            }
        };
        UILanguageManager.addLanguageListener(this.component, this.languageSensitive);
    }

    protected boolean isLanguageSensitive() {
        boolean sensitive = false;
        if (this.component instanceof LanguageSensitive || ((JTable)this.component).getModel() instanceof LanguageSensitive) {
            sensitive = true;
        } else {
            TableColumnModel columnModel = ((JTable)this.component).getColumnModel();
            for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                if (!(columnModel.getColumn(i).getCellRenderer() instanceof LanguageSensitive)) continue;
                sensitive = true;
                break;
            }
            if (!sensitive) {
                Hashtable defaultRenderers = (Hashtable)ReflectUtils.getFieldValueSafely((Object)this.component, (String)"defaultRenderersByColumnClass");
                if (defaultRenderers != null) {
                    for (Object renderer : defaultRenderers.values()) {
                        if (!(renderer instanceof LanguageSensitive)) continue;
                        sensitive = true;
                        break;
                    }
                }
                if (!sensitive) {
                    TableModel model = ((JTable)this.component).getModel();
                    for (int row = 0; row < model.getRowCount(); ++row) {
                        for (int col = 0; col < model.getColumnCount(); ++col) {
                            if (!(model.getValueAt(row, col) instanceof LanguageSensitive)) continue;
                            sensitive = true;
                            break;
                        }
                        if (sensitive) break;
                    }
                }
            }
        }
        return sensitive;
    }

    protected void uninstallLanguageListeners() {
        UILanguageManager.removeLanguageListener(this.component, this.languageSensitive);
        this.languageSensitive = null;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
        this.rendererPane = ((WTableUI)ui).getCellRendererPane();
        Rectangle clip = g2d.getClipBounds();
        if (((JTable)this.component).getRowCount() > 0 && ((JTable)this.component).getColumnCount() > 0 && bounds.intersects(clip)) {
            Point upperLeft = clip.getLocation();
            if (!this.ltr) {
                ++upperLeft.x;
            }
            Point lowerRight = new Point(clip.x + clip.width - (this.ltr ? 1 : 0), clip.y + clip.height);
            int rMin = ((JTable)this.component).rowAtPoint(upperLeft);
            int rMax = ((JTable)this.component).rowAtPoint(lowerRight);
            if (rMin == -1) {
                rMin = 0;
            }
            if (rMax == -1) {
                rMax = ((JTable)this.component).getRowCount() - 1;
            }
            int cMin = ((JTable)this.component).columnAtPoint(this.ltr ? upperLeft : lowerRight);
            int cMax = ((JTable)this.component).columnAtPoint(this.ltr ? lowerRight : upperLeft);
            if (cMin == -1) {
                cMin = 0;
            }
            if (cMax == -1) {
                cMax = ((JTable)this.component).getColumnCount() - 1;
            }
            this.paintBackground(g2d, bounds, rMin, rMax, cMin, cMax);
            this.paintGrid(g2d, rMin, rMax, cMin, cMax);
            this.paintSelection(g2d);
            this.paintContent(g2d, rMin, rMax, cMin, cMax);
            this.rendererPane = null;
        }
        this.paintDropLocation(g2d);
    }

    protected void paintBackground(Graphics2D g2d, Rectangle bounds, int rMin, int rMax, int cMin, int cMax) {
        int columnWidth;
        TableColumn aColumn;
        int column;
        Rectangle cellRect;
        TableColumnModel cm = ((JTable)this.component).getColumnModel();
        int columnMargin = cm.getColumnMargin();
        if (this.rowPainter != null) {
            for (int row = rMin; row <= rMax; ++row) {
                cellRect = ((JTable)this.component).getCellRect(row, cMin, false);
                Rectangle rowRect = new Rectangle(bounds.x, cellRect.y, bounds.width, cellRect.height);
                this.rowPainter.prepareToPaint(row);
                this.paintSection(this.rowPainter, g2d, rowRect);
            }
        }
        if (this.columnPainter != null) {
            cellRect = ((JTable)this.component).getCellRect(rMin, cMin, false);
            for (column = cMin; column <= cMax; ++column) {
                aColumn = cm.getColumn(column);
                columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                Rectangle colRect = new Rectangle(cellRect.x, bounds.y, cellRect.width, bounds.height);
                this.columnPainter.prepareToPaint(column);
                this.paintSection(this.columnPainter, g2d, colRect);
                cellRect.x += columnWidth;
            }
        }
        if (this.cellPainter != null) {
            for (int row = rMin; row <= rMax; ++row) {
                cellRect = ((JTable)this.component).getCellRect(row, cMin, false);
                for (column = cMin; column <= cMax; ++column) {
                    aColumn = cm.getColumn(column);
                    columnWidth = aColumn.getWidth();
                    cellRect.width = columnWidth - columnMargin;
                    if (!this.ltr && column != cMin) {
                        cellRect.x -= columnWidth;
                    }
                    if (this.cellPainter != null) {
                        this.cellPainter.prepareToPaint(row, column);
                        this.paintSection(this.cellPainter, g2d, cellRect);
                    }
                    if (!this.ltr) continue;
                    cellRect.x += columnWidth;
                }
            }
        }
    }

    protected void paintGrid(Graphics2D g2d, int rMin, int rMax, int cMin, int cMax) {
        block6: {
            int x;
            g2d.setColor(((JTable)this.component).getGridColor());
            Rectangle minCell = ((JTable)this.component).getCellRect(rMin, cMin, true);
            Rectangle maxCell = ((JTable)this.component).getCellRect(rMax, cMax, true);
            Rectangle damagedArea = minCell.union(maxCell);
            if (((JTable)this.component).getShowHorizontalLines()) {
                int tableWidth = damagedArea.x + damagedArea.width;
                int y = damagedArea.y;
                for (int row = rMin; row <= rMax; ++row) {
                    g2d.drawLine(damagedArea.x, (y += ((JTable)this.component).getRowHeight(row)) - 1, tableWidth - 1, y - 1);
                }
            }
            if (!((JTable)this.component).getShowVerticalLines()) break block6;
            TableColumnModel cm = ((JTable)this.component).getColumnModel();
            int tableHeight = damagedArea.y + damagedArea.height;
            if (this.ltr) {
                x = damagedArea.x;
                for (int column = cMin; column <= cMax; ++column) {
                    int w = cm.getColumn(column).getWidth();
                    g2d.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            } else {
                x = damagedArea.x;
                for (int column = cMax; column >= cMin; --column) {
                    int w = cm.getColumn(column).getWidth();
                    g2d.drawLine((x += w) - 1, 0, x - 1, tableHeight - 1);
                }
            }
        }
    }

    protected void paintSelection(Graphics2D g2d) {
        block10: {
            if (this.selectionPainter == null) break block10;
            JTableHeader header = ((JTable)this.component).getTableHeader();
            TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
            int draggedIndex = ((JTable)this.component).convertColumnIndexToView(draggedColumn != null ? draggedColumn.getModelIndex() : -1);
            int[] rows = ((JTable)this.component).getSelectedRows();
            int[] cols = ((JTable)this.component).getSelectedColumns();
            if (rows.length > 0 || cols.length > 0) {
                boolean rs = ((JTable)this.component).getRowSelectionAllowed();
                boolean cs = ((JTable)this.component).getColumnSelectionAllowed();
                if (rs && cs) {
                    List<Pair<Integer, Integer>> rowSections = this.getSections(rows, -1);
                    List<Pair<Integer, Integer>> colSections = this.getSections(cols, draggedIndex);
                    for (Pair<Integer, Integer> rowSection : rowSections) {
                        for (Pair<Integer, Integer> colSection : colSections) {
                            Rectangle first = ((JTable)this.component).getCellRect((Integer)rowSection.getKey(), (Integer)colSection.getKey(), false);
                            Rectangle last = ((JTable)this.component).getCellRect((Integer)rowSection.getValue(), (Integer)colSection.getValue(), false);
                            Rectangle selection = GeometryUtils.getNonNullContainingRect((Rectangle)first, (Rectangle)last);
                            this.paintSection(this.selectionPainter, g2d, selection);
                        }
                    }
                } else if (rs) {
                    List<Pair<Integer, Integer>> rowSections = this.getSections(rows, -1);
                    for (Pair<Integer, Integer> rowSection : rowSections) {
                        Rectangle first = ((JTable)this.component).getCellRect((Integer)rowSection.getKey(), 0, false);
                        Rectangle last = ((JTable)this.component).getCellRect((Integer)rowSection.getValue(), ((JTable)this.component).getColumnCount() - 1, false);
                        Rectangle selection = GeometryUtils.getNonNullContainingRect((Rectangle)first, (Rectangle)last);
                        this.paintSection(this.selectionPainter, g2d, selection);
                    }
                } else if (cs) {
                    List<Pair<Integer, Integer>> colSections = this.getSections(cols, draggedIndex);
                    for (Pair<Integer, Integer> colSection : colSections) {
                        Rectangle first = ((JTable)this.component).getCellRect(0, (Integer)colSection.getKey(), false);
                        Rectangle last = ((JTable)this.component).getCellRect(((JTable)this.component).getRowCount() - 1, (Integer)colSection.getValue(), false);
                        Rectangle selection = GeometryUtils.getNonNullContainingRect((Rectangle)first, (Rectangle)last);
                        this.paintSection(this.selectionPainter, g2d, selection);
                    }
                }
            }
        }
    }

    protected void paintContent(Graphics2D g2d, int rMin, int rMax, int cMin, int cMax) {
        JTableHeader header = ((JTable)this.component).getTableHeader();
        TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
        TableColumnModel cm = ((JTable)this.component).getColumnModel();
        int columnMargin = cm.getColumnMargin();
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle cellRect = ((JTable)this.component).getCellRect(row, cMin, false);
            for (int column = cMin; column <= cMax; ++column) {
                TableColumn aColumn = cm.getColumn(column);
                int columnWidth = aColumn.getWidth();
                cellRect.width = columnWidth - columnMargin;
                if (!this.ltr && column != cMin) {
                    cellRect.x -= columnWidth;
                }
                if (aColumn != draggedColumn) {
                    this.paintCell(g2d, cellRect, row, column);
                }
                if (!this.ltr) continue;
                cellRect.x += columnWidth;
            }
        }
        if (draggedColumn != null) {
            this.paintDraggedColumn(g2d, rMin, rMax, draggedColumn, header.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    protected List<Pair<Integer, Integer>> getSections(int[] indices, int excluded) {
        Arrays.sort(indices);
        ArrayList inx = CollectionUtils.asList((int[])indices);
        inx.remove((Object)excluded);
        ArrayList<Pair<Integer, Integer>> sections = new ArrayList<Pair<Integer, Integer>>(1);
        int first = -1;
        for (int i = 0; i < inx.size(); ++i) {
            if (first != -1) {
                if ((Integer)inx.get(i) - 1 != (Integer)inx.get(i - 1)) {
                    sections.add((Pair<Integer, Integer>)new Pair((Object)first, inx.get(i - 1)));
                    first = (Integer)inx.get(i);
                }
            } else {
                first = (Integer)inx.get(i);
            }
            if (i != inx.size() - 1) continue;
            sections.add((Pair<Integer, Integer>)new Pair((Object)first, inx.get(i)));
        }
        return sections;
    }

    protected void paintCell(Graphics2D g2d, Rectangle bounds, int row, int column) {
        if (((JTable)this.component).isEditing() && ((JTable)this.component).getEditingRow() == row && ((JTable)this.component).getEditingColumn() == column) {
            Component editor = ((JTable)this.component).getEditorComponent();
            editor.setBounds(bounds);
            editor.validate();
        } else {
            TableCellRenderer renderer = ((JTable)this.component).getCellRenderer(row, column);
            Component prepareRenderer = ((JTable)this.component).prepareRenderer(renderer, row, column);
            this.rendererPane.paintComponent(g2d, prepareRenderer, this.component, bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
    }

    protected void paintDraggedColumn(Graphics2D g2d, int rMin, int rMax, TableColumn column, int distance) {
        int index = ((JTable)this.component).convertColumnIndexToView(column.getModelIndex());
        Rectangle minCell = ((JTable)this.component).getCellRect(rMin, index, true);
        Rectangle maxCell = ((JTable)this.component).getCellRect(rMax, index, true);
        Rectangle vcr = minCell.union(maxCell);
        vcr.x += distance;
        if (this.draggedColumnPainter != null) {
            Rectangle b = new Rectangle(vcr.x, vcr.y, vcr.width, vcr.height);
            this.draggedColumnPainter.prepareToPaint(index);
            this.paintSection(this.draggedColumnPainter, g2d, b);
        }
        if (((JTable)this.component).getShowVerticalLines()) {
            g2d.setColor(((JTable)this.component).getGridColor());
            int x1 = vcr.x;
            int y1 = vcr.y;
            int x2 = x1 + vcr.width - 1;
            int y2 = y1 + vcr.height - 1;
            g2d.drawLine(x1 - 1, y1, x1 - 1, y2);
            g2d.drawLine(x2, y1, x2, y2);
        }
        for (int row = rMin; row <= rMax; ++row) {
            Rectangle r = ((JTable)this.component).getCellRect(row, index, false);
            r.x += distance;
            this.paintCell(g2d, r, row, index);
            if (!((JTable)this.component).getShowHorizontalLines()) continue;
            g2d.setColor(((JTable)this.component).getGridColor());
            Rectangle rcr = ((JTable)this.component).getCellRect(row, index, true);
            rcr.x += distance;
            int x1 = rcr.x;
            int y1 = rcr.y;
            int x2 = x1 + rcr.width - 1;
            int y2 = y1 + rcr.height - 1;
            g2d.drawLine(x1, y2, x2, y2);
        }
    }

    protected void paintDropLocation(Graphics2D g2d) {
        JTable.DropLocation loc = ((JTable)this.component).getDropLocation();
        if (loc != null) {
            Color color = UIManager.getColor("Table.dropLineColor");
            Color shortColor = UIManager.getColor("Table.dropLineShortColor");
            if (color != null || shortColor != null) {
                Rectangle vDropLine;
                Rectangle hDropLine = this.getHDropLineRect(loc);
                if (hDropLine != null) {
                    int x = hDropLine.x;
                    int w = hDropLine.width;
                    if (color != null) {
                        this.extendRect(hDropLine, true);
                        g2d.setColor(color);
                        g2d.fillRect(hDropLine.x, hDropLine.y, hDropLine.width, hDropLine.height);
                    }
                    if (!loc.isInsertColumn() && shortColor != null) {
                        g2d.setColor(shortColor);
                        g2d.fillRect(x, hDropLine.y, w, hDropLine.height);
                    }
                }
                if ((vDropLine = this.getVDropLineRect(loc)) != null) {
                    int y = vDropLine.y;
                    int h = vDropLine.height;
                    if (color != null) {
                        this.extendRect(vDropLine, false);
                        g2d.setColor(color);
                        g2d.fillRect(vDropLine.x, vDropLine.y, vDropLine.width, vDropLine.height);
                    }
                    if (!loc.isInsertRow() && shortColor != null) {
                        g2d.setColor(shortColor);
                        g2d.fillRect(vDropLine.x, y, vDropLine.width, h);
                    }
                }
            }
        }
    }

    @Nullable
    protected Rectangle getHDropLineRect(@NotNull JTable.DropLocation location) {
        Rectangle rect = null;
        if (location.isInsertRow()) {
            int row = location.getRow();
            int col = location.getColumn();
            if (col >= ((JTable)this.component).getColumnCount()) {
                --col;
            }
            rect = ((JTable)this.component).getCellRect(row, col, true);
            if (row >= ((JTable)this.component).getRowCount()) {
                Rectangle prevRect = ((JTable)this.component).getCellRect(--row, col, true);
                rect.y = prevRect.y + prevRect.height;
            }
            rect.y = rect.y == 0 ? -1 : (rect.y -= 2);
            rect.height = 3;
        }
        return rect;
    }

    @Nullable
    protected Rectangle getVDropLineRect(@NotNull JTable.DropLocation location) {
        Rectangle rect = null;
        if (location.isInsertColumn()) {
            int col = location.getColumn();
            rect = ((JTable)this.component).getCellRect(location.getRow(), col, true);
            if (col >= ((JTable)this.component).getColumnCount()) {
                rect = ((JTable)this.component).getCellRect(location.getRow(), --col, true);
                if (this.ltr) {
                    rect.x += rect.width;
                }
            } else if (!this.ltr) {
                rect.x += rect.width;
            }
            rect.x = rect.x == 0 ? -1 : (rect.x -= 2);
            rect.width = 3;
        }
        return rect;
    }

    protected Rectangle extendRect(Rectangle rect, boolean horizontal) {
        if (rect != null) {
            if (horizontal) {
                rect.x = 0;
                rect.width = ((JTable)this.component).getWidth();
            } else {
                rect.y = 0;
                if (((JTable)this.component).getRowCount() != 0) {
                    Rectangle lastRect = ((JTable)this.component).getCellRect(((JTable)this.component).getRowCount() - 1, 0, true);
                    rect.height = lastRect.y + lastRect.height;
                } else {
                    rect.height = ((JTable)this.component).getHeight();
                }
            }
        }
        return rect;
    }
}

