/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.laf.text.IAbstractTextFieldPainter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;

public class TextFieldLayout
extends AbstractLayoutManager {
    @NotNull
    private final IAbstractTextFieldPainter painter;

    public TextFieldLayout(@NotNull IAbstractTextFieldPainter painter) {
        this.painter = painter;
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container container) {
        Insets b = container.getInsets();
        Component leading = this.painter.getLeadingComponent();
        Component trailing = this.painter.getTrailingComponent();
        Dimension l = leading != null ? leading.getPreferredSize() : new Dimension();
        Dimension t = trailing != null ? trailing.getPreferredSize() : new Dimension();
        return new Dimension(b.left + l.width + t.width + b.right, b.top + Math.max(l.height, t.height) + b.bottom);
    }

    @Override
    public void layoutContainer(@NotNull Container container) {
        int w;
        Insets b = container.getInsets();
        boolean ltr = container.getComponentOrientation().isLeftToRight();
        Component leading = this.painter.getLeadingComponent();
        Component trailing = this.painter.getTrailingComponent();
        if (leading != null) {
            w = leading.getPreferredSize().width;
            if (ltr) {
                leading.setBounds(b.left - w, b.top, w, container.getHeight() - b.top - b.bottom);
            } else {
                leading.setBounds(container.getWidth() - b.right, b.top, w, container.getHeight() - b.top - b.bottom);
            }
        }
        if (trailing != null) {
            w = trailing.getPreferredSize().width;
            if (ltr) {
                trailing.setBounds(container.getWidth() - b.right, b.top, w, container.getHeight() - b.top - b.bottom);
            } else {
                trailing.setBounds(b.left - w, b.top, w, container.getHeight() - b.top - b.bottom);
            }
        }
    }
}

