/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.text.WEditorPaneUI;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.ReflectUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.plaf.ComponentUI;

public class WebEditorPaneUI
extends WEditorPaneUI {
    protected String inputPrompt;
    protected transient JEditorPane editorPane = null;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebEditorPaneUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.editorPane = (JEditorPane)c;
        super.installUI(c);
        StyleManager.installSkin(this.editorPane);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.editorPane);
        super.uninstallUI(c);
        this.editorPane = null;
    }

    @Override
    @Nullable
    public String getInputPrompt() {
        return this.inputPrompt;
    }

    @Override
    public void setInputPrompt(@Nullable String text) {
        if (Objects.notEquals((Object)text, (Object)this.inputPrompt)) {
            this.inputPrompt = text;
            this.editorPane.repaint();
        }
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    protected void paintSafely(@NotNull Graphics g) {
        ReflectUtils.setFieldValueSafely((Object)this, (String)"painted", (Object)true);
        PainterSupport.paint(g, this.getComponent(), this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c));
    }
}

