/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.text;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.text.WTextAreaUI;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PainterSupport;
import com.alee.utils.ReflectUtils;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.plaf.ComponentUI;

public class WebTextAreaUI
extends WTextAreaUI {
    protected String inputPrompt;
    protected transient JTextArea textArea = null;

    @NotNull
    public static ComponentUI createUI(@NotNull JComponent c) {
        return new WebTextAreaUI();
    }

    @Override
    public void installUI(@NotNull JComponent c) {
        this.textArea = (JTextArea)c;
        super.installUI(c);
        StyleManager.installSkin(this.textArea);
    }

    @Override
    public void uninstallUI(@NotNull JComponent c) {
        StyleManager.uninstallSkin(this.textArea);
        super.uninstallUI(c);
        this.textArea = null;
    }

    @Override
    @Nullable
    public String getInputPrompt() {
        return this.inputPrompt;
    }

    @Override
    public void setInputPrompt(@Nullable String text) {
        if (Objects.notEquals((Object)text, (Object)this.inputPrompt)) {
            this.inputPrompt = text;
            this.textArea.repaint();
        }
    }

    @Override
    public boolean contains(@NotNull JComponent c, int x, int y) {
        return PainterSupport.contains(c, this, x, y);
    }

    @Override
    protected void paintSafely(@NotNull Graphics g) {
        ReflectUtils.setFieldValueSafely((Object)this, (String)"painted", (Object)true);
        PainterSupport.paint(g, this.getComponent(), this);
    }

    @Override
    @Nullable
    public Dimension getPreferredSize(@NotNull JComponent c) {
        return PainterSupport.getPreferredSize(c, super.getPreferredSize(c));
    }
}

