/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tooltip;

import com.alee.api.jdk.Objects;
import com.alee.managers.language.AbstractToolTipLanguage;
import com.alee.managers.language.Language;
import com.alee.managers.language.data.Text;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public class SwingToolTipLanguage<C extends JComponent>
extends AbstractToolTipLanguage<C> {
    public static final String TYPE = "SWING";
    protected static final String SWING_TOOLTIP_MARKER = "swing.tooltip.marker";

    @Override
    public Class getComponentClass() {
        return JToolTip.class;
    }

    @Override
    public void update(C component, Language language, String key, Object ... data) {
        Text toolTipText = this.getToolTipText(language, key);
        if (toolTipText != null) {
            ((JComponent)component).setToolTipText(toolTipText.getText(new Object[0]));
            ((JComponent)component).putClientProperty(SWING_TOOLTIP_MARKER, true);
        } else if (((JComponent)component).getClientProperty(SWING_TOOLTIP_MARKER) != null) {
            ((JComponent)component).setToolTipText(null);
            ((JComponent)component).putClientProperty(SWING_TOOLTIP_MARKER, null);
        }
    }

    protected Text getToolTipText(Language language, String key) {
        Text tooltip = language.getText(key, "swing-tooltip");
        if (tooltip == null && Objects.equals((Object)SwingToolTipLanguage.getDefaultToolTipType(), (Object)TYPE)) {
            tooltip = language.getText(key, "tooltip");
        }
        return tooltip;
    }
}

