/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.tree.ITreeDropLocationPainter;
import com.alee.laf.tree.WTreeUI;
import com.alee.painter.decoration.AbstractSectionDecorationPainter;
import com.alee.painter.decoration.IDecoration;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeDropLocationPainter<C extends JTree, U extends WTreeUI, D extends IDecoration<C, D>>
extends AbstractSectionDecorationPainter<C, U, D>
implements ITreeDropLocationPainter<C, U> {
    @Nullable
    protected JTree.DropLocation location;

    @Override
    public String getSectionId() {
        return "drop.location";
    }

    @Override
    @Nullable
    public Rectangle getDropViewBounds(@NotNull JTree.DropLocation location) {
        Rectangle dropViewBounds = null;
        if (((JTree)this.component).getRowCount() > 0) {
            TreeModel model = ((JTree)this.component).getModel();
            TreePath path = location.getPath();
            if (model != null && path != null) {
                dropViewBounds = this.isDropBetween(location, model, path) ? this.getDropBetweenViewBounds(location, model, path, location.getChildIndex()) : this.getDropOnViewBounds(location, model, path);
            }
        }
        return dropViewBounds;
    }

    protected boolean isDropBetween(@NotNull JTree.DropLocation location, @NotNull TreeModel model, @NotNull TreePath path) {
        return location.getChildIndex() != -1 && model.getChildCount(path.getLastPathComponent()) > 0;
    }

    @Nullable
    protected Rectangle getDropOnViewBounds(@NotNull JTree.DropLocation location, @NotNull TreeModel model, @NotNull TreePath path) {
        return ((JTree)this.component).getPathBounds(path);
    }

    @Nullable
    protected Rectangle getDropBetweenViewBounds(@NotNull JTree.DropLocation location, @NotNull TreeModel model, @NotNull TreePath path, int index) {
        boolean atStart;
        int actualIndex;
        Object parent = path.getLastPathComponent();
        int childCount = model.getChildCount(parent);
        if (index < childCount) {
            actualIndex = index;
            atStart = true;
        } else {
            actualIndex = childCount - 1;
            atStart = false;
        }
        Object child = model.getChild(parent, actualIndex);
        TreePath childPath = path.pathByAddingChild(child);
        Rectangle bounds = ((JTree)this.component).getPathBounds(childPath);
        if (bounds != null) {
            Dimension ps = this.getPreferredSize();
            if (!this.ltr) {
                bounds.x = bounds.x + bounds.width - ps.width;
            }
            bounds.y = atStart ? (bounds.y -= ps.height / 2) : (bounds.y += bounds.height - ps.height / 2);
            bounds.width = ps.width;
            bounds.height = ps.height;
        }
        return bounds;
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        if (this.location != null) {
            TreeModel model = ((JTree)this.component).getModel();
            TreePath path = this.location.getPath();
            if (model != null && path != null) {
                states.add(this.isDropBetween(this.location, model, path) ? "drop-between" : "drop-on");
            }
        }
        return states;
    }

    @Override
    public void prepareToPaint(@NotNull JTree.DropLocation location) {
        this.location = location;
        this.updateDecorationState();
    }

    @Override
    protected boolean isDecorationAvailable(@NotNull D decoration) {
        return this.location != null && super.isDecorationAvailable(decoration);
    }
}

