/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.laf.tree.ITreeRowPainter;
import com.alee.laf.tree.WTreeUI;
import com.alee.painter.decoration.AbstractSectionDecorationPainter;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.IDecoration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class TreeRowPainter<C extends JTree, U extends WTreeUI, D extends IDecoration<C, D>>
extends AbstractSectionDecorationPainter<C, U, D>
implements ITreeRowPainter<C, U> {
    protected transient Integer row;

    @Override
    public String getSectionId() {
        return "row";
    }

    @Override
    protected boolean isFocused() {
        return false;
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        List<String> states = super.getDecorationStates();
        this.addRowStates(states);
        return states;
    }

    protected void addRowStates(List<String> states) {
        TreePath path;
        if (this.row != null && (path = ((JTree)this.component).getPathForRow(this.row)) != null) {
            this.addPathStates(states, path);
        }
    }

    protected void addPathStates(List<String> states, TreePath path) {
        this.addNumerationStates(states, path);
        states.add(((JTree)this.component).isExpanded(this.row) ? "expanded" : "collapsed");
        states.add(((JTree)this.component).isRowSelected(this.row) ? "selected" : "unselected");
        if (this.row.intValue() == ((WTreeUI)this.ui).getHoverRow()) {
            states.add("hover");
        } else {
            states.remove("hover");
        }
        Object value = path.getLastPathComponent();
        states.addAll(DecorationUtils.getExtraStates(value));
    }

    protected void addNumerationStates(List<String> states, TreePath path) {
        states.add(this.row % 2 == 0 ? "odd" : "even");
    }

    @Override
    public void prepareToPaint(int row) {
        this.row = row;
        this.updateDecorationState();
    }
}

