/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.laf.tree.TreeState;
import com.alee.laf.tree.UniqueNode;
import com.alee.laf.tree.WebTree;
import com.alee.managers.settings.Configuration;
import com.alee.managers.settings.SettingsProcessor;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class TreeSettingsProcessor
extends SettingsProcessor<WebTree<? extends UniqueNode>, TreeState, Configuration<TreeState>> {
    protected transient TreeSelectionListener treeSelectionListener;
    protected transient TreeExpansionListener treeExpansionListener;

    public TreeSettingsProcessor(WebTree<? extends UniqueNode> tree, Configuration configuration) {
        super(tree, configuration);
    }

    @Override
    protected void register(@NotNull WebTree<? extends UniqueNode> tree) {
        this.treeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeSettingsProcessor.this.save();
            }
        };
        tree.addTreeSelectionListener(this.treeSelectionListener);
        this.treeExpansionListener = new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                TreeSettingsProcessor.this.save();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                TreeSettingsProcessor.this.save();
            }
        };
        tree.addTreeExpansionListener(this.treeExpansionListener);
    }

    @Override
    protected void unregister(@NotNull WebTree<? extends UniqueNode> tree) {
        tree.removeTreeExpansionListener(this.treeExpansionListener);
        this.treeExpansionListener = null;
        tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.treeSelectionListener = null;
    }

    @Override
    protected void loadSettings(@NotNull WebTree<? extends UniqueNode> tree) {
        tree.setTreeState((TreeState)this.loadSettings());
    }

    @Override
    protected void saveSettings(@NotNull WebTree<? extends UniqueNode> tree) {
        this.saveSettings(tree.getTreeState());
    }
}

