/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.extended.image.WebImage;
import com.alee.laf.checkbox.WebCheckBox;
import com.alee.laf.combobox.WebComboBox;
import com.alee.laf.text.WebTextField;
import com.alee.managers.style.StyleId;
import com.alee.utils.swing.WebDefaultCellEditor;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;

public class WebTreeCellEditor<C extends JComponent>
extends WebDefaultCellEditor<C>
implements FocusListener {
    protected boolean autoUpdateLeadingIcon = true;

    public WebTreeCellEditor() {
        this(new WebTextField());
    }

    public WebTreeCellEditor(WebTextField textField) {
        super(textField);
    }

    public WebTreeCellEditor(WebCheckBox checkBox) {
        super(checkBox);
    }

    public WebTreeCellEditor(WebComboBox comboBox) {
        super(comboBox);
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.stopCellEditing();
    }

    @Override
    public boolean stopCellEditing() {
        boolean stopped = super.stopCellEditing();
        if (stopped) {
            this.editorComponent.removeFocusListener(this);
        }
        return stopped;
    }

    @Override
    public void cancelCellEditing() {
        this.editorComponent.removeFocusListener(this);
        super.cancelCellEditing();
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        Component cellEditor = super.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
        cellEditor.addFocusListener(this);
        TreeCellRenderer r = tree.getCellRenderer();
        Component component = r.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
        cellEditor.setPreferredSize(component.getPreferredSize());
        if (cellEditor instanceof WebTextField) {
            WebTextField editor = (WebTextField)cellEditor;
            editor.setStyleId(StyleId.treeCellEditor.at(tree));
            if (component instanceof JLabel && ((JLabel)component).getIcon() != null) {
                JLabel label = (JLabel)component;
                if (this.autoUpdateLeadingIcon) {
                    WebImage image = new WebImage(StyleId.treeCellEditorIcon.at(editor), label.getIcon());
                    editor.setLeadingComponent(image);
                }
            }
        }
        cellEditor.applyComponentOrientation(tree.getComponentOrientation());
        return cellEditor;
    }
}

