/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.tree.TreeUtils;
import com.alee.utils.CollectionUtils;
import com.alee.utils.compare.IntegerComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class WebTreeModel<N extends MutableTreeNode>
extends DefaultTreeModel {
    public WebTreeModel(@Nullable N root) {
        super((TreeNode)root);
    }

    public WebTreeModel(@Nullable N root, boolean asksAllowsChildren) {
        super((TreeNode)root, asksAllowsChildren);
    }

    @Nullable
    public N getRoot() {
        return (N)((MutableTreeNode)super.getRoot());
    }

    @Override
    public void insertNodeInto(@NotNull MutableTreeNode child, @NotNull MutableTreeNode parent, int index) {
        parent.insert(child, index);
        this.nodesWereInserted(parent, new int[]{index});
    }

    public void insertNodesInto(@NotNull List<N> children, @NotNull N parent, int index) {
        int count = children.size();
        if (count > 0) {
            int[] indices = new int[count];
            int i = index;
            while (i < index + count) {
                int sourceIndex = i - index;
                parent.insert((MutableTreeNode)children.get(sourceIndex), i);
                indices[sourceIndex] = i++;
            }
            this.nodesWereInserted((TreeNode)parent, indices);
        }
    }

    public void insertNodesInto(@NotNull N[] children, @NotNull N parent, int index) {
        int count = children.length;
        if (count > 0) {
            int[] indices = new int[count];
            int i = index;
            while (i < index + count) {
                int sourceIndex = i - index;
                parent.insert((MutableTreeNode)children[sourceIndex], i);
                indices[sourceIndex] = i++;
            }
            this.nodesWereInserted((TreeNode)parent, indices);
        }
    }

    @Override
    public void removeNodeFromParent(@NotNull MutableTreeNode node) {
        MutableTreeNode parent = (MutableTreeNode)node.getParent();
        if (parent == null) {
            throw new IllegalArgumentException("Removed node does not have a parent");
        }
        int index = parent.getIndex(node);
        parent.remove(index);
        this.nodesWereRemoved(parent, new int[]{index}, new Object[]{node});
    }

    public void removeNodesFromParent(@NotNull N parent) {
        int count = parent.getChildCount();
        if (count > 0) {
            int[] indices = new int[count];
            Object[] removed = new Object[count];
            for (int index = 0; index < count; ++index) {
                indices[index] = index;
                removed[index] = parent.getChildAt(index);
                parent.remove(index);
            }
            this.nodesWereRemoved((TreeNode)parent, indices, removed);
        }
    }

    public void removeNodesFromParent(@NotNull N[] nodes) {
        this.removeNodesFromParent(CollectionUtils.toList((Object[])nodes));
    }

    public void removeNodesFromParent(@NotNull List<N> nodes) {
        if (nodes.size() > 0) {
            MutableTreeNode parent;
            HashMap<MutableTreeNode, ArrayList<Integer>> mappedNodes = new HashMap<MutableTreeNode, ArrayList<Integer>>();
            for (MutableTreeNode mutableTreeNode : nodes) {
                parent = (MutableTreeNode)mutableTreeNode.getParent();
                if (parent == null) continue;
                ArrayList<Integer> parentNodes = (ArrayList<Integer>)mappedNodes.get(parent);
                if (parentNodes == null) {
                    parentNodes = new ArrayList<Integer>(nodes.size());
                    mappedNodes.put(parent, parentNodes);
                }
                parentNodes.add(parent.getIndex(mutableTreeNode));
            }
            for (Map.Entry entry : mappedNodes.entrySet()) {
                parent = (MutableTreeNode)entry.getKey();
                List removedIndices = CollectionUtils.sort((List)((List)entry.getValue()), (Comparator)IntegerComparator.instance());
                ArrayList<MutableTreeNode> removedNodes = new ArrayList<MutableTreeNode>(removedIndices.size());
                for (int i = removedIndices.size() - 1; i >= 0; --i) {
                    int index = (Integer)removedIndices.get(i);
                    removedNodes.add((MutableTreeNode)parent.getChildAt(index));
                    parent.remove(index);
                }
                int[] indices = CollectionUtils.toIntArray((Collection)removedIndices);
                Object[] removed = CollectionUtils.toObjectArray(removedNodes);
                this.nodesWereRemoved(parent, indices, removed);
            }
        }
    }

    public void updateNode(@Nullable N node) {
        if (node != null) {
            this.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)node), null, null);
        }
    }

    public void updateNodes(N ... nodes) {
        if (nodes != null && nodes.length > 0) {
            for (N node : nodes) {
                this.fireTreeNodesChanged(this, this.getPathToRoot((TreeNode)node), null, null);
            }
        }
    }

    public void updateNodes(@Nullable List<N> nodes) {
        if (CollectionUtils.notEmpty(nodes)) {
            for (MutableTreeNode node : nodes) {
                this.fireTreeNodesChanged(this, this.getPathToRoot(node), null, null);
            }
        }
    }

    public void updateNodeStructure(@Nullable N node) {
        if (node != null) {
            this.fireTreeStructureChanged(this, this.getPathToRoot((TreeNode)node), null, null);
        }
    }

    public void updateTree() {
        Object rootNode = this.getRoot();
        if (rootNode != null) {
            Object[] path = TreeUtils.getPath((TreeNode)rootNode);
            this.fireTreeStructureChanged(this, path, null, null);
        }
    }
}

