/*
 * Decompiled with CFR 0.152.
 */
package com.alee.laf.tree.behavior;

import com.alee.extended.behavior.Behavior;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class TreeSelectionExpandBehavior
implements TreeSelectionListener,
Behavior {
    protected final JTree tree;

    public TreeSelectionExpandBehavior(JTree tree) {
        this.tree = tree;
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.tree.getSelectionCount() > 0) {
            this.tree.expandPath(this.tree.getSelectionPath());
        }
    }

    public static TreeSelectionExpandBehavior install(JTree tree) {
        TreeSelectionExpandBehavior.uninstall(tree);
        TreeSelectionExpandBehavior behavior = new TreeSelectionExpandBehavior(tree);
        tree.addTreeSelectionListener(behavior);
        return behavior;
    }

    public static void uninstall(JTree tree) {
        for (TreeSelectionListener listener : tree.getTreeSelectionListeners()) {
            if (!(listener instanceof TreeSelectionExpandBehavior)) continue;
            tree.removeTreeSelectionListener(listener);
        }
    }

    public static boolean isInstalled(JTree tree) {
        for (TreeSelectionListener listener : tree.getTreeSelectionListeners()) {
            if (!(listener instanceof TreeSelectionExpandBehavior)) continue;
            return true;
        }
        return false;
    }
}

