/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation;

import com.alee.managers.animation.AnimationException;
import com.alee.managers.animation.event.EventDispatchThreadHandler;
import com.alee.managers.animation.event.EventHandler;
import com.alee.managers.animation.pipeline.AnimationPipelineFactory;
import com.alee.managers.animation.pipeline.TimedAnimationPipelineFactory;
import com.alee.managers.animation.transition.Transition;
import com.alee.managers.animation.types.ColorTransitionType;
import com.alee.managers.animation.types.DoubleTransitionType;
import com.alee.managers.animation.types.FloatTransitionType;
import com.alee.managers.animation.types.IntegerTransitionType;
import com.alee.managers.animation.types.LongTransitionType;
import com.alee.managers.animation.types.TransitionType;
import com.alee.utils.ReflectUtils;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AnimationManager {
    private static Map<Class, TransitionType> transitionTypes;
    private static AnimationPipelineFactory pipelineFactory;
    private static EventHandler eventHandler;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            transitionTypes = new HashMap<Class, TransitionType>();
            transitionTypes.put(Integer.TYPE, new IntegerTransitionType());
            transitionTypes.put(Integer.class, new IntegerTransitionType());
            transitionTypes.put(Long.TYPE, new LongTransitionType());
            transitionTypes.put(Long.class, new LongTransitionType());
            transitionTypes.put(Float.TYPE, new FloatTransitionType());
            transitionTypes.put(Float.class, new FloatTransitionType());
            transitionTypes.put(Double.TYPE, new DoubleTransitionType());
            transitionTypes.put(Double.class, new DoubleTransitionType());
            transitionTypes.put(Color.class, new ColorTransitionType());
            pipelineFactory = new TimedAnimationPipelineFactory();
            eventHandler = EventDispatchThreadHandler.get();
            initialized = true;
        }
    }

    public static AnimationPipelineFactory getPipelineFactory() {
        return pipelineFactory;
    }

    public static void setPipelineFactory(AnimationPipelineFactory factory) {
        pipelineFactory = factory;
    }

    public static EventHandler getEventHandler() {
        return eventHandler;
    }

    public static void setEventHandler(EventHandler eventHandler) {
        AnimationManager.eventHandler = eventHandler;
    }

    public static <V> TransitionType<V> getTransitionType(Class<V> type) {
        TransitionType transitionType = transitionTypes.get(type);
        if (transitionType == null) {
            Class superType = null;
            for (Map.Entry<Class, TransitionType> entry : transitionTypes.entrySet()) {
                if (!entry.getKey().isAssignableFrom(type)) continue;
                superType = entry.getKey();
                break;
            }
            if (superType != null) {
                transitionType = transitionTypes.get(superType);
                transitionTypes.put(type, transitionType);
            } else {
                String cls = ReflectUtils.getClassName(TransitionType.class);
                throw new AnimationException("Unable to find " + cls + " implementation for value type: " + type);
            }
        }
        return transitionType;
    }

    public static void play(Transition ... transitions) {
        for (Transition transition : transitions) {
            pipelineFactory.getPipeline(transition).play(transition);
        }
    }

    public static void play(List<Transition> transitions) {
        for (Transition transition : transitions) {
            pipelineFactory.getPipeline(transition).play(transition);
        }
    }

    public static void stop(Transition ... transitions) {
        for (Transition transition : transitions) {
            pipelineFactory.getPipeline(transition).stop(transition);
        }
    }

    public static void stop(List<Transition> transitions) {
        for (Transition transition : transitions) {
            pipelineFactory.getPipeline(transition).stop(transition);
        }
    }

    static {
        initialized = false;
    }
}

