/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.framerate;

import com.alee.managers.animation.AnimationException;
import com.alee.managers.animation.framerate.FrameRate;

public final class FixedFrameRate
implements FrameRate {
    private final double frameRate;

    public FixedFrameRate(double frameRate) {
        if (frameRate == 0.0) {
            throw new AnimationException("Frame rate should never be zero");
        }
        if (Double.isInfinite(frameRate) || Double.isNaN(frameRate)) {
            throw new AnimationException("Incorrect frame rate specified: " + frameRate);
        }
        this.frameRate = frameRate;
    }

    @Override
    public double value() {
        return this.frameRate;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    public String toString() {
        return "Fixed frame rate [ value = " + this.value() + " ]";
    }
}

