/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.pipeline;

import com.alee.managers.animation.pipeline.AbstractAnimationPipeline;
import com.alee.managers.animation.transition.Transition;
import com.alee.utils.ReflectUtils;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.slf4j.LoggerFactory;

public final class TimedAnimationPipeline
extends AbstractAnimationPipeline
implements Runnable {
    private final Set<Transition> transitions = new ConcurrentSkipListSet<Transition>();
    private final Thread animator = new Thread(this);

    public TimedAnimationPipeline() {
        this.animator.setName(ReflectUtils.getClassName(this.getClass()));
        this.animator.setDaemon(true);
        this.animator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            long previousFrame = -1L;
            while (!this.isTerminated()) {
                long currentFrame = System.nanoTime();
                long delay = -1L;
                TimedAnimationPipeline timedAnimationPipeline = this;
                synchronized (timedAnimationPipeline) {
                    if (previousFrame > 0L) {
                        for (Transition transition : this.transitions) {
                            long untilNextFrame = transition.proceed(previousFrame, currentFrame);
                            if (untilNextFrame <= 0L) {
                                this.transitions.remove(transition);
                                continue;
                            }
                            if (delay > 0L && untilNextFrame >= delay) continue;
                            delay = untilNextFrame;
                        }
                    }
                    previousFrame = currentFrame;
                    if (delay > 0L) {
                        long nextDelayMs = Math.round(delay / 1000000L);
                        this.wait(Math.max(1L, nextDelayMs));
                    } else {
                        this.wait();
                    }
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void play(Transition transition) {
        try {
            transition.start(System.nanoTime());
            this.transitions.add(transition);
            this.reset();
        }
        catch (Exception e) {
            String msg = "Unable to play transition: %s";
            LoggerFactory.getLogger(TimedAnimationPipeline.class).error(String.format("Unable to play transition: %s", transition), (Throwable)e);
        }
    }

    @Override
    public void stop(Transition transition) {
        try {
            transition.abort();
            this.transitions.remove(transition);
            this.reset();
        }
        catch (Exception e) {
            String msg = "Unable to stop transition: %s";
            LoggerFactory.getLogger(TimedAnimationPipeline.class).error(String.format("Unable to stop transition: %s", transition), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            super.shutdown();
            TimedAnimationPipeline timedAnimationPipeline = this;
            synchronized (timedAnimationPipeline) {
                this.transitions.clear();
                this.animator.interrupt();
            }
        }
        catch (Exception e) {
            String msg = "Unable to shutdown pipeline";
            LoggerFactory.getLogger(TimedAnimationPipeline.class).error("Unable to shutdown pipeline", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reset() {
        TimedAnimationPipeline timedAnimationPipeline = this;
        synchronized (timedAnimationPipeline) {
            this.notifyAll();
        }
    }
}

