/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.transition;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.managers.animation.AnimationException;
import com.alee.managers.animation.AnimationManager;
import com.alee.managers.animation.event.EventHandler;
import com.alee.managers.animation.framerate.FixedFrameRate;
import com.alee.managers.animation.framerate.FrameRate;
import com.alee.managers.animation.transition.Transition;
import com.alee.managers.animation.transition.TransitionListener;
import com.alee.managers.animation.transition.TransitionListenerComparator;
import com.alee.managers.animation.transition.TransitionState;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public abstract class AbstractTransition<V>
implements Transition<V> {
    protected static final FrameRate DEFAULT_FRAME_RATE = new FixedFrameRate(60.0);
    protected TransitionState state = TransitionState.constructed;
    protected final Set<TransitionListener<V>> listeners = new ConcurrentSkipListSet(new TransitionListenerComparator());
    protected FrameRate frameRate;
    protected EventHandler eventHandler;
    protected boolean optimizeEvents;
    protected V latest;

    public AbstractTransition() {
        this(DEFAULT_FRAME_RATE);
    }

    public AbstractTransition(FrameRate frameRate) {
        this.setFrameRate(frameRate != null ? frameRate : DEFAULT_FRAME_RATE);
        this.setEventHandler(null);
        this.setOptimizeEvents(true);
    }

    @Override
    public FrameRate getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(FrameRate frameRate) {
        this.frameRate = frameRate;
    }

    public EventHandler getEventHandler() {
        return this.eventHandler != null ? this.eventHandler : AnimationManager.getEventHandler();
    }

    public void setEventHandler(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public boolean isOptimizeEvents() {
        return this.optimizeEvents;
    }

    public void setOptimizeEvents(boolean optimizeEvents) {
        this.optimizeEvents = optimizeEvents;
    }

    @Override
    public TransitionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(TransitionState state) {
        AbstractTransition abstractTransition = this;
        synchronized (abstractTransition) {
            if (this.state != state) {
                if (!TransitionState.isValid(this.state, state)) {
                    throw new AnimationException("Invalid state change performed: " + (Object)((Object)this.state) + " -> " + (Object)((Object)state) + " for transition: " + this);
                }
                TransitionState previous = this.state;
                this.state = state;
                Object value = this.getValue();
                this.fireStateChanged(value, previous, state);
                if (state == TransitionState.playing) {
                    this.fireStarted(this.getStart());
                } else if (state == TransitionState.finished) {
                    this.fireFinished(this.getGoal());
                } else if (state == TransitionState.aborted) {
                    this.fireAborted(value);
                } else if (state == TransitionState.ready && (previous == TransitionState.finished || previous == TransitionState.aborted)) {
                    this.fireReset(value);
                }
            }
        }
    }

    public V getLatest() {
        return this.latest;
    }

    public int compareTo(@NotNull Object object) {
        return this == object ? 0 : -1;
    }

    @Override
    public void addListener(TransitionListener<V> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(TransitionListener<V> listener) {
        this.listeners.remove(listener);
    }

    public void fireStarted(final V value) {
        this.latest = value;
        this.submit(new Runnable(){

            @Override
            public void run() {
                for (TransitionListener<Object> transitionListener : AbstractTransition.this.listeners) {
                    transitionListener.started(AbstractTransition.this, value);
                }
            }
        });
    }

    public void fireAdjusted(final V value) {
        if (!this.isOptimizeEvents() || Objects.notEquals(value, this.latest)) {
            this.latest = value;
            this.submit(new Runnable(){

                @Override
                public void run() {
                    for (TransitionListener<Object> transitionListener : AbstractTransition.this.listeners) {
                        transitionListener.adjusted(AbstractTransition.this, value);
                    }
                }
            });
        }
    }

    public void fireFinished(final V value) {
        this.latest = value;
        this.submit(new Runnable(){

            @Override
            public void run() {
                for (TransitionListener<Object> transitionListener : AbstractTransition.this.listeners) {
                    transitionListener.finished(AbstractTransition.this, value);
                }
            }
        });
    }

    public void fireAborted(final V value) {
        this.submit(new Runnable(){

            @Override
            public void run() {
                for (TransitionListener<Object> transitionListener : AbstractTransition.this.listeners) {
                    transitionListener.aborted(AbstractTransition.this, value);
                }
            }
        });
    }

    public void fireReset(final V value) {
        this.latest = null;
        this.submit(new Runnable(){

            @Override
            public void run() {
                for (TransitionListener<Object> transitionListener : AbstractTransition.this.listeners) {
                    transitionListener.reset(AbstractTransition.this, value);
                }
            }
        });
    }

    public void fireStateChanged(final V value, final TransitionState previous, final TransitionState current) {
        this.submit(new Runnable(){

            @Override
            public void run() {
                for (TransitionListener<Object> transitionListener : AbstractTransition.this.listeners) {
                    transitionListener.stateChanged(AbstractTransition.this, value, previous, current);
                }
            }
        });
    }

    protected void submit(Runnable event) {
        this.getEventHandler().handle(event);
    }

    public final void play() {
        AnimationManager.play(this);
    }

    public final void stop() {
        AnimationManager.stop(this);
    }
}

