/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag;

import com.alee.api.jdk.BiConsumer;
import com.alee.managers.drag.DragListener;
import com.alee.managers.drag.view.DragViewHandler;
import com.alee.managers.glasspane.GlassPaneManager;
import com.alee.managers.glasspane.WebGlassPane;
import com.alee.utils.ArrayUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.swing.WeakComponentDataList;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.slf4j.LoggerFactory;

public final class DragManager {
    private static final WeakComponentDataList<JComponent, DragListener> dragListeners = new WeakComponentDataList("DragManager.DragListener", 50);
    private static final Map<DataFlavor, List<DragViewHandler>> viewHandlers = new HashMap<DataFlavor, List<DragViewHandler>>();
    private static boolean dragging = false;
    private static DataFlavor[] flavors = null;
    private static Transferable transferable = null;
    private static WebGlassPane glassPane;
    private static Object data;
    private static BufferedImage view;
    private static DragViewHandler dragViewHandler;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            DragSourceAdapter dsa = new DragSourceAdapter(){

                protected void dragStarted(final DragSourceDragEvent event) {
                    DataFlavor[] flavors;
                    DragSourceContext dsc = event.getDragSourceContext();
                    Transferable transferable = dsc.getTransferable();
                    for (DataFlavor flavor : flavors = transferable.getTransferDataFlavors()) {
                        if (!viewHandlers.containsKey(flavor)) continue;
                        try {
                            data = transferable.getTransferData(flavor);
                            for (DragViewHandler handler : (List)viewHandlers.get(flavor)) {
                                if (!handler.supports(data, event)) continue;
                                dragViewHandler = handler;
                                break;
                            }
                            if (dragViewHandler == null) continue;
                            view = dragViewHandler.getView(data, event);
                            glassPane = GlassPaneManager.getGlassPane(dsc.getComponent());
                            glassPane.setPaintedImage(view, this.getLocation(glassPane, event, view));
                            break;
                        }
                        catch (Exception e) {
                            LoggerFactory.getLogger(DragManager.class).error(e.toString(), (Throwable)e);
                        }
                    }
                    transferable = transferable;
                    DragManager.access$602(flavors);
                    dragging = true;
                    dragListeners.forEachData((BiConsumer)new BiConsumer<JComponent, DragListener>(){

                        public void accept(JComponent component, DragListener dragListener) {
                            dragListener.started(event);
                        }
                    });
                }

                @Override
                public void dragEnter(final DragSourceDragEvent event) {
                    dragListeners.forEachData((BiConsumer)new BiConsumer<JComponent, DragListener>(){

                        public void accept(JComponent component, DragListener dragListener) {
                            dragListener.entered(event);
                        }
                    });
                }

                @Override
                public void dragExit(final DragSourceEvent event) {
                    dragListeners.forEachData((BiConsumer)new BiConsumer<JComponent, DragListener>(){

                        public void accept(JComponent component, DragListener dragListener) {
                            dragListener.exited(event);
                        }
                    });
                }

                @Override
                public void dragMouseMoved(final DragSourceDragEvent event) {
                    if (!dragging) {
                        this.dragStarted(event);
                    }
                    if (view != null) {
                        WebGlassPane gp = GlassPaneManager.getGlassPane(event.getDragSourceContext().getComponent());
                        if (gp != glassPane) {
                            glassPane.clearPaintedImage();
                            glassPane = gp;
                        }
                        glassPane.setPaintedImage(view, this.getLocation(glassPane, event, view));
                    }
                    dragListeners.forEachData((BiConsumer)new BiConsumer<JComponent, DragListener>(){

                        public void accept(JComponent component, DragListener dragListener) {
                            dragListener.moved(event);
                        }
                    });
                }

                @Override
                public void dragDropEnd(final DragSourceDropEvent event) {
                    dragging = false;
                    DragManager.access$602(null);
                    transferable = null;
                    if (view != null) {
                        dragViewHandler.dragEnded(data, event);
                        glassPane.clearPaintedImage();
                        glassPane = null;
                        data = null;
                        view = null;
                        dragViewHandler = null;
                    }
                    dragListeners.forEachData((BiConsumer)new BiConsumer<JComponent, DragListener>(){

                        public void accept(JComponent component, DragListener dragListener) {
                            dragListener.finished(event);
                        }
                    });
                }

                public Point getLocation(WebGlassPane gp, DragSourceDragEvent dsde, BufferedImage view) {
                    Point mp = CoreSwingUtils.getMouseLocation((Component)gp);
                    Point vp = dragViewHandler.getViewRelativeLocation(data, dsde, view);
                    return new Point(mp.x + vp.x, mp.y + vp.y);
                }
            };
            if (!GraphicsEnvironment.isHeadless()) {
                DragSource.getDefaultDragSource().addDragSourceListener(dsa);
                DragSource.getDefaultDragSource().addDragSourceMotionListener(dsa);
            }
        }
    }

    public static boolean isDragging() {
        return dragging;
    }

    public static boolean isDragging(DataFlavor flavor) {
        return dragging && ArrayUtils.contains((Object)flavor, (Object[])flavors);
    }

    public static DataFlavor[] getFlavors() {
        return dragging ? flavors : null;
    }

    public static Transferable getTransferable() {
        return transferable;
    }

    public static void registerViewHandler(DragViewHandler handler) {
        DataFlavor flavor = handler.getObjectFlavor();
        List<DragViewHandler> handlers = viewHandlers.get(flavor);
        if (handlers == null) {
            handlers = new ArrayList<DragViewHandler>(1);
            viewHandlers.put(flavor, handlers);
        }
        handlers.add(handler);
    }

    public static void unregisterViewHandler(DragViewHandler handler) {
        List<DragViewHandler> handlers = viewHandlers.get(handler.getObjectFlavor());
        if (handlers != null) {
            handlers.remove(handler);
        }
    }

    public static void addDragListener(JComponent component, DragListener listener) {
        dragListeners.add(component, (Object)listener);
    }

    public static void removeDragListener(JComponent component, DragListener listener) {
        dragListeners.remove(component, (Object)listener);
    }

    static /* synthetic */ DataFlavor[] access$602(DataFlavor[] x0) {
        flavors = x0;
        return x0;
    }

    static {
        initialized = false;
    }
}

