/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.icon.set;

import com.alee.api.annotations.NotNull;
import com.alee.managers.icon.IconException;
import com.alee.managers.icon.data.IconSource;
import com.alee.managers.icon.set.XmlIconSet;
import com.alee.utils.ReflectUtils;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;

public class XmlIconSetConverter
extends ReflectionConverter {
    public static final String ID_ATTRIBUTE = "id";

    public XmlIconSetConverter(@NotNull Mapper mapper, @NotNull ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(@NotNull Class type) {
        return type.equals(XmlIconSet.class);
    }

    @NotNull
    public Object unmarshal(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context) {
        try {
            XmlIconSet iconSetData = (XmlIconSet)context.currentObject();
            ReflectUtils.setFieldValue((Object)iconSetData, (String)ID_ATTRIBUTE, (Object)reader.getAttribute(ID_ATTRIBUTE));
            context.put((Object)"Resource.nearClass", (Object)reader.getAttribute("nearClass"));
            context.put((Object)"Resource.base", (Object)reader.getAttribute("base"));
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String nodeName = reader.getNodeName();
                Class iconSourceClass = this.mapper.realClass(nodeName);
                if (IconSource.class.isAssignableFrom(iconSourceClass)) {
                    iconSetData.addIcon((IconSource)context.convertAnother((Object)iconSetData, iconSourceClass));
                }
                reader.moveUp();
            }
            context.put((Object)"Resource.base", null);
            context.put((Object)"Resource.nearClass", null);
            return iconSetData;
        }
        catch (Exception e) {
            throw new IconException("Unable to load XmlIconSet", e);
        }
    }
}

