/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.Function;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.ShadeLayer;
import com.alee.managers.popup.WebInnerPopup;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.swing.WeakComponentData;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;

public final class PopupManager {
    protected static final WeakComponentData<JComponent, ShadeLayer> shadeLayers = new WeakComponentData("PopupManager.ShadeLayer", 3);
    protected static final WeakComponentData<JComponent, PopupLayer> popupLayers = new WeakComponentData("PopupManager.PopupLayer", 3);
    protected static StyleId defaultPopupStyleId = StyleId.innerpopup;

    public static void hideAllPopups() {
        shadeLayers.forEach((BiConsumer)new BiConsumer<JComponent, ShadeLayer>(){

            public void accept(JComponent component, ShadeLayer shadeLayer) {
                shadeLayer.hideAllPopups();
            }
        });
        popupLayers.forEach((BiConsumer)new BiConsumer<JComponent, PopupLayer>(){

            public void accept(JComponent component, PopupLayer popupLayer) {
                popupLayer.hideAllPopups();
            }
        });
    }

    public static void hideAllPopups(JComponent component) {
        PopupManager.hideAllPopups(CoreSwingUtils.getRootPane((Component)component));
    }

    public static void hideAllPopups(JRootPane rootPane) {
        if (shadeLayers.contains((JComponent)rootPane)) {
            ((ShadeLayer)shadeLayers.get((JComponent)rootPane)).hideAllPopups();
        }
        if (popupLayers.contains((JComponent)rootPane)) {
            ((PopupLayer)popupLayers.get((JComponent)rootPane)).hideAllPopups();
        }
    }

    public static StyleId getDefaultPopupStyleId() {
        return defaultPopupStyleId;
    }

    public static void setDefaultPopupStyleId(StyleId id) {
        defaultPopupStyleId = id;
    }

    public static void showPopup(Component component, WebInnerPopup popup) {
        PopupManager.showPopup(component, popup, true);
    }

    public static void showPopup(Component component, WebInnerPopup popup, boolean transferFocus) {
        JRootPane rootPane = CoreSwingUtils.getRootPane((Component)component);
        if (rootPane != null) {
            PopupManager.showPopup(rootPane, popup, transferFocus);
        }
    }

    public static void showPopup(JRootPane rootPane, WebInnerPopup popup, boolean transferFocus) {
        PopupManager.getPopupLayer(rootPane).showPopup(popup);
        if (transferFocus) {
            popup.transferFocus();
        }
    }

    public static void showModalPopup(Component component, WebInnerPopup popup, boolean hfill, boolean vfill) {
        PopupManager.showModalPopup(component, popup, hfill, vfill, false);
    }

    public static void showModalPopup(Component component, WebInnerPopup popup, boolean hfill, boolean vfill, boolean blockClose) {
        JRootPane rootPane = CoreSwingUtils.getRootPane((Component)component);
        if (rootPane != null) {
            PopupManager.showModalPopup(rootPane, popup, hfill, vfill, blockClose);
        }
    }

    public static void showModalPopup(JRootPane rootPane, WebInnerPopup popup, boolean hfill, boolean vfill) {
        PopupManager.showModalPopup(rootPane, popup, hfill, vfill, false);
    }

    public static void showModalPopup(JRootPane rootPane, WebInnerPopup popup, boolean hfill, boolean vfill, boolean blockClose) {
        PopupManager.hideAllPopups(rootPane);
        ShadeLayer shadeLayer = PopupManager.getShadeLayer(rootPane);
        shadeLayer.setBlockClose(blockClose);
        shadeLayer.showPopup(popup, hfill, vfill);
        popup.transferFocus();
    }

    public static PopupLayer getPopupLayer(Component component) {
        return PopupManager.getPopupLayer(CoreSwingUtils.getRootPane((Component)component));
    }

    public static PopupLayer getPopupLayer(final JRootPane rootPane) {
        if (rootPane != null) {
            return (PopupLayer)popupLayers.get((JComponent)rootPane, (Function)new Function<JComponent, PopupLayer>(){

                public PopupLayer apply(JComponent component) {
                    JLayeredPane layeredPane = rootPane.getLayeredPane();
                    if (layeredPane == null) {
                        throw new RuntimeException("PopupLayer can be installed only into window or applet with JLayeredPane");
                    }
                    PopupLayer popupLayer = new PopupLayer();
                    PopupManager.installPopupLayer(popupLayer, rootPane, layeredPane);
                    return popupLayer;
                }
            });
        }
        throw new RuntimeException("JRootPane for PopupLayer was not specified");
    }

    public static ShadeLayer getShadeLayer(final JRootPane rootPane) {
        if (rootPane != null) {
            return (ShadeLayer)shadeLayers.get((JComponent)rootPane, (Function)new Function<JComponent, ShadeLayer>(){

                public ShadeLayer apply(JComponent component) {
                    JLayeredPane layeredPane = rootPane.getLayeredPane();
                    if (layeredPane != null) {
                        throw new RuntimeException("ShadeLayer can be installed only into window or applet with JLayeredPane");
                    }
                    ShadeLayer shadeLayer = new ShadeLayer();
                    PopupManager.installPopupLayer(shadeLayer, rootPane, layeredPane);
                    return shadeLayer;
                }
            });
        }
        throw new RuntimeException("JRootPane for ShadeLayer was not specified");
    }

    protected static void installPopupLayer(final PopupLayer popupLayer, JRootPane rootPane, final JLayeredPane layeredPane) {
        popupLayer.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
        popupLayer.setVisible(true);
        layeredPane.add((Component)popupLayer, JLayeredPane.PALETTE_LAYER);
        layeredPane.revalidate();
        layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                popupLayer.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
                popupLayer.revalidate();
            }
        });
        Window window = CoreSwingUtils.getWindowAncestor((Component)rootPane);
        if (window != null) {
            window.addWindowStateListener(new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    popupLayer.setBounds(0, 0, layeredPane.getWidth(), layeredPane.getHeight());
                    popupLayer.revalidate();
                }
            });
        }
    }
}

