/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.AlignLayout;
import com.alee.managers.popup.PopupLayer;
import com.alee.managers.popup.WebInnerPopup;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WebTimer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class ShadeLayer
extends PopupLayer {
    protected boolean animate = true;
    protected int opacity = 0;
    protected WebTimer animator;
    protected boolean blockClose = false;

    public ShadeLayer() {
        super(new AlignLayout());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (!ShadeLayer.this.blockClose) {
                    ShadeLayer.this.hideAllPopups();
                }
            }
        };
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
    }

    @Override
    public void showPopup(@NotNull WebInnerPopup popup) {
        this.showPopup(popup, false, false);
    }

    public void showPopup(@NotNull WebInnerPopup popup, boolean hfill, boolean vfill) {
        popup.firePopupWillBeOpened();
        LayoutManager layoutManager = this.getLayout();
        if (layoutManager instanceof AlignLayout) {
            AlignLayout layout = (AlignLayout)layoutManager;
            layout.setHfill(hfill);
            layout.setVfill(vfill);
        }
        this.setBounds(new Rectangle(0, 0, this.getParent().getWidth(), this.getParent().getHeight()));
        this.removeAll();
        this.add((Component)popup, "0,0", 0);
        this.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    public boolean isAnimate() {
        return this.animate;
    }

    public void setAnimate(boolean animate) {
        this.animate = animate;
    }

    public boolean isBlockClose() {
        return this.blockClose;
    }

    public void setBlockClose(boolean blockClose) {
        this.blockClose = blockClose;
    }

    @Override
    public void paint(@NotNull Graphics g) {
        GraphicsUtils.setupAlphaComposite((Graphics2D)((Graphics2D)g), (Float)Float.valueOf((float)this.opacity / 100.0f), (this.opacity < 100 ? 1 : 0) != 0);
        super.paint(g);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Object old = GraphicsUtils.setupAntialias((Graphics2D)g2d);
        Composite comp = GraphicsUtils.setupAlphaComposite((Graphics2D)g2d, (Float)Float.valueOf(0.8f));
        g2d.setPaint(Color.LIGHT_GRAY);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        GraphicsUtils.restoreComposite((Graphics2D)g2d, (Composite)comp);
        GraphicsUtils.restoreAntialias((Graphics2D)g2d, (Object)old);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.animator != null) {
                this.animator.stop();
            }
            if (this.animate) {
                this.opacity = 0;
                this.animator = new WebTimer("ShadeLayer.fadeIn", SwingUtils.frameRateDelay(24), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ShadeLayer.this.opacity < 100) {
                            ShadeLayer.this.opacity += 25;
                            ShadeLayer.this.repaint();
                        } else {
                            ShadeLayer.this.animator.stop();
                        }
                    }
                });
                this.animator.start();
            } else {
                this.opacity = 100;
                this.repaint();
            }
        }
    }

    @Override
    public boolean contains(int x, int y) {
        return this.normalContains(x, y);
    }
}

