/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.api.annotations.NotNull;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleException;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SystemUtils;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractSkin
implements Skin {
    public static final String ALL_SYSTEMS_SUPPORTED = "all";

    @NotNull
    public abstract List<String> getSupportedSystems();

    @Override
    public boolean isSupported() {
        List<String> systems = this.getSupportedSystems();
        if (CollectionUtils.isEmpty(systems)) {
            throw new StyleException("Skin must support at least one system");
        }
        return systems.contains(ALL_SYSTEMS_SUPPORTED) || systems.contains(SystemUtils.getShortOsName());
    }

    @Override
    public void applySkin(@NotNull JComponent component) {
        this.getStyle(component).apply(component);
        component.repaint();
    }

    @Override
    public void updateSkin(@NotNull JComponent component) {
        this.removeSkin(component);
        this.applySkin(component);
    }

    @Override
    public void removeSkin(@NotNull JComponent component) {
        this.getStyle(component).remove(component);
    }
}

