/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.style.StyleException;
import com.alee.painter.PainterSupport;
import com.alee.painter.decoration.IDecoration;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;

public enum BoundsType {
    component,
    margin,
    border,
    padding,
    section;


    @Nullable
    public Insets insets(@NotNull JComponent component) {
        Insets insets;
        switch (this) {
            case section: {
                throw new StyleException("Section bounds are specific for each component");
            }
            case margin: {
                insets = PainterSupport.getMargin(component);
                break;
            }
            case border: {
                insets = PainterSupport.getInsets(component);
                if (insets == null) break;
                SwingUtils.decrease(insets, PainterSupport.getMargin(component));
                SwingUtils.decrease(insets, PainterSupport.getPadding(component));
                break;
            }
            case padding: {
                insets = PainterSupport.getPadding(component);
                break;
            }
            default: {
                insets = new Insets(0, 0, 0, 0);
            }
        }
        return insets;
    }

    @NotNull
    public Insets border(@NotNull JComponent component) {
        Insets i = new Insets(0, 0, 0, 0);
        switch (this) {
            case padding: {
                SwingUtils.increase(i, PainterSupport.getInsets(component));
                break;
            }
            case border: {
                SwingUtils.increase(i, PainterSupport.getInsets(component));
                SwingUtils.decrease(i, PainterSupport.getPadding(component));
                break;
            }
            case margin: {
                SwingUtils.increase(i, PainterSupport.getMargin(component));
            }
        }
        return i;
    }

    @NotNull
    public Insets insets(@NotNull JComponent component, @NotNull IDecoration decoration) {
        Insets i;
        switch (this) {
            case section: {
                throw new StyleException("Section insets are specific for each component");
            }
            case border: {
                i = decoration.getBorderInsets(component);
                break;
            }
            default: {
                i = new Insets(0, 0, 0, 0);
            }
        }
        return i;
    }

    @NotNull
    public Insets border(@NotNull JComponent component, @NotNull IDecoration decoration) {
        Insets i = new Insets(0, 0, 0, 0);
        switch (this) {
            case section: {
                throw new StyleException("Section border is specific for each component");
            }
            case border: 
            case padding: {
                SwingUtils.increase(i, decoration.getBorderInsets(component));
            }
        }
        return i;
    }

    @NotNull
    public Rectangle bounds(@NotNull Component component) {
        Insets insets = component instanceof JComponent ? this.border((JComponent)component) : new Insets(0, 0, 0, 0);
        return new Rectangle(insets.left, insets.top, component.getWidth() - insets.left - insets.right, component.getHeight() - insets.top - insets.bottom);
    }
}

