/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.style.Skin;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.StyleManager;
import com.alee.painter.Painter;
import com.alee.utils.CollectionUtils;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;

public final class StyleData
implements PropertyChangeListener {
    @NotNull
    private final WeakReference<JComponent> component;
    @Nullable
    private Skin skin;
    private boolean pinnedSkin;
    @Nullable
    private StyleId styleId;
    @Nullable
    private Painter customPainter;
    @Nullable
    private List<WeakReference<JComponent>> children;
    @Nullable
    private List<StyleListener> listeners;

    protected StyleData(@NotNull JComponent component) {
        WebLookAndFeel.checkEventDispatchThread();
        this.component = new WeakReference<JComponent>(component);
        this.skin = null;
        this.pinnedSkin = false;
        this.styleId = null;
        this.customPainter = null;
        this.children = null;
        this.listeners = null;
    }

    public void install() {
        WebLookAndFeel.checkEventDispatchThread();
        JComponent component = this.getComponent();
        component.addPropertyChangeListener("styleId", this);
        component.addPropertyChangeListener("parent", this);
        this.applySkin(StyleManager.getSkin(), false);
    }

    public void uninstall() {
        this.removeSkin();
        WebLookAndFeel.checkEventDispatchThread();
        JComponent component = this.getComponent();
        component.removePropertyChangeListener("parent", this);
        component.removePropertyChangeListener("styleId", this);
    }

    @Override
    public void propertyChange(@NotNull PropertyChangeEvent event) {
        WebLookAndFeel.checkEventDispatchThread();
        JComponent component = this.getComponent();
        Object styleId = component.getClientProperty("styleId");
        if (styleId != null) {
            if (styleId instanceof StyleId) {
                this.setStyleId((StyleId)styleId);
            } else if (styleId instanceof String) {
                String id = (String)styleId;
                Object parent = component.getClientProperty("parent");
                if (parent != null) {
                    if (parent instanceof JComponent) {
                        this.setStyleId(StyleId.of(id, (JComponent)parent));
                    } else if (parent instanceof WeakReference) {
                        Object p = ((WeakReference)parent).get();
                        if (p != null && p instanceof JComponent) {
                            this.setStyleId(StyleId.of(id, (JComponent)p));
                        } else {
                            this.setStyleId(StyleId.of(id));
                        }
                    } else {
                        this.setStyleId(StyleId.of(id));
                    }
                } else {
                    this.setStyleId(StyleId.of(id));
                }
            }
        } else {
            this.resetStyleId(false);
        }
    }

    @NotNull
    protected JComponent getComponent() {
        JComponent component = (JComponent)this.component.get();
        if (component == null) {
            throw new StyleException(String.format("Component for style identifier '%s' has been destroyed", this.getStyleId().getCompleteId()));
        }
        return component;
    }

    protected Skin getSkin() {
        return this.skin;
    }

    protected boolean isPinnedSkin() {
        return this.pinnedSkin;
    }

    protected void setPinnedSkin(boolean pinnedSkin) {
        this.pinnedSkin = pinnedSkin;
    }

    @Nullable
    protected Skin applySkin(@NotNull Skin skin, boolean children) {
        Skin oldSkin;
        WebLookAndFeel.checkEventDispatchThread();
        JComponent component = this.getComponent();
        if (skin != this.skin) {
            oldSkin = this.removeSkin();
            this.skin = skin;
            skin.applySkin(component);
            this.setPinnedSkin(false);
            if (children && CollectionUtils.notEmpty(this.children)) {
                for (WeakReference<JComponent> reference : this.children) {
                    JComponent child = (JComponent)reference.get();
                    if (child == null) continue;
                    StyleManager.setSkin(child, skin, false);
                }
            }
            this.fireSkinChanged(component, oldSkin, skin);
            this.fireSkinUpdated(component, this.getStyleId());
        } else {
            oldSkin = this.skin;
        }
        return oldSkin;
    }

    @Nullable
    protected Skin applyCustomSkin(@NotNull Skin skin, boolean recursively) {
        WebLookAndFeel.checkEventDispatchThread();
        Skin previousSkin = this.applySkin(skin, true);
        this.setPinnedSkin(true);
        if (recursively) {
            JComponent component = this.getComponent();
            for (int i = 0; i < component.getComponentCount(); ++i) {
                Component child = component.getComponent(i);
                if (!(child instanceof JComponent)) continue;
                StyleManager.setSkin((JComponent)child, skin, true);
            }
        }
        return previousSkin;
    }

    protected void updateSkin(boolean children) {
        WebLookAndFeel.checkEventDispatchThread();
        JComponent component = this.getComponent();
        this.getSkin().updateSkin(component);
        if (children && CollectionUtils.notEmpty(this.children)) {
            for (WeakReference<JComponent> reference : this.children) {
                JComponent child = (JComponent)reference.get();
                if (child == null) continue;
                StyleManager.updateSkin(child);
            }
        }
        this.fireSkinUpdated(component, this.getStyleId());
    }

    @Nullable
    protected Skin resetSkin() {
        Skin result;
        WebLookAndFeel.checkEventDispatchThread();
        Skin skin = this.getSkin();
        Skin globalSkin = StyleManager.getSkin();
        if (globalSkin == skin) {
            this.applySkin(globalSkin, true);
            result = globalSkin;
        } else {
            result = skin;
        }
        return result;
    }

    @Nullable
    protected Skin removeSkin() {
        WebLookAndFeel.checkEventDispatchThread();
        Skin oldSkin = this.skin;
        if (this.skin != null) {
            JComponent component = this.getComponent();
            this.skin.removeSkin(component);
            this.skin = null;
        }
        return oldSkin;
    }

    @NotNull
    protected StyleId getStyleId() {
        return this.styleId != null ? this.styleId : StyleId.getDefault(this.getComponent());
    }

    @NotNull
    protected StyleId setStyleId(@NotNull StyleId id) {
        WebLookAndFeel.checkEventDispatchThread();
        JComponent component = this.getComponent();
        StyleId styleId = id.getId() != null ? id : StyleId.getDefault(component);
        StyleId old = this.getStyleId();
        if (Objects.notEquals((Object)styleId, (Object)old)) {
            JComponent parent;
            StyleId oldStyleId = this.styleId;
            this.styleId = styleId;
            JComponent oldParent = old.getParent();
            if (oldParent != null) {
                StyleManager.getData(oldParent).removeChild(component);
            }
            if ((parent = styleId.getParent()) != null) {
                StyleManager.getData(parent).addChild(component);
            }
            if (parent != null) {
                Skin parentSkin = StyleManager.getSkin(parent);
                if (parentSkin != null && parentSkin != this.getSkin()) {
                    this.applySkin(parentSkin, false);
                } else {
                    this.updateSkin(true);
                }
            } else {
                this.updateSkin(true);
            }
            this.fireStyleChanged(component, oldStyleId, styleId);
        }
        return old;
    }

    @NotNull
    protected StyleId resetStyleId(boolean recursively) {
        WebLookAndFeel.checkEventDispatchThread();
        if (recursively && CollectionUtils.notEmpty(this.children)) {
            for (WeakReference reference : CollectionUtils.copy(this.children)) {
                JComponent child = (JComponent)reference.get();
                if (child == null) continue;
                StyleManager.resetStyleId(child);
            }
        }
        return this.setStyleId(StyleId.auto);
    }

    @Nullable
    protected Painter getCustomPainter() {
        return this.customPainter;
    }

    @Nullable
    protected Painter setCustomPainter(@NotNull Painter painter) {
        WebLookAndFeel.checkEventDispatchThread();
        Painter oldPainter = this.customPainter;
        this.customPainter = painter;
        JComponent component = this.getComponent();
        this.getSkin().applySkin(component);
        this.fireSkinUpdated(component, this.getStyleId());
        return oldPainter;
    }

    public boolean resetCustomPainter() {
        WebLookAndFeel.checkEventDispatchThread();
        boolean successful = this.customPainter != null;
        this.customPainter = null;
        JComponent component = this.getComponent();
        this.getSkin().applySkin(component);
        this.fireSkinUpdated(component, this.getStyleId());
        return successful;
    }

    protected void addChild(@NotNull JComponent child) {
        WebLookAndFeel.checkEventDispatchThread();
        if (this.children == null) {
            this.children = new ArrayList<WeakReference<JComponent>>(1);
        }
        this.children.add(new WeakReference<JComponent>(child));
    }

    protected void removeChild(@NotNull JComponent child) {
        WebLookAndFeel.checkEventDispatchThread();
        if (this.children != null) {
            Iterator<WeakReference<JComponent>> iterator = this.children.iterator();
            while (iterator.hasNext()) {
                WeakReference<JComponent> next = iterator.next();
                if (next.get() != child) continue;
                iterator.remove();
            }
        }
    }

    protected void addStyleListener(@NotNull StyleListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<StyleListener>(1);
        }
        this.listeners.add(listener);
    }

    protected void removeStyleListener(@NotNull StyleListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void fireSkinChanged(@NotNull JComponent component, @Nullable Skin oldSkin, @NotNull Skin newSkin) {
        if (this.listeners != null) {
            for (StyleListener listener : this.listeners) {
                listener.skinChanged(component, oldSkin, newSkin);
            }
        }
    }

    private void fireStyleChanged(@NotNull JComponent component, @Nullable StyleId oldStyleId, @NotNull StyleId newStyleId) {
        if (this.listeners != null) {
            for (StyleListener listener : this.listeners) {
                listener.styleChanged(component, oldStyleId, newStyleId);
            }
        }
    }

    private void fireSkinUpdated(@NotNull JComponent component, @NotNull StyleId styleId) {
        if (this.listeners != null) {
            for (StyleListener listener : this.listeners) {
                listener.skinUpdated(component, styleId);
            }
        }
    }
}

