/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.api.Identifiable;
import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.managers.style.ChildStyleId;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.StyleManager;
import com.alee.utils.CoreSwingUtils;
import java.awt.Component;
import java.awt.Window;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;

public final class StyleId
implements Identifiable {
    public static final String STYLE_PROPERTY = "styleId";
    public static final String PARENT_STYLE_PROPERTY = "parent";
    public static final String styleSeparator = ".";
    public static final StyleId auto = new StyleId(null);
    public static final StyleId canvas = StyleId.of("canvas");
    public static final StyleId canvasGripperNW = StyleId.of("gripper-nw");
    public static final StyleId canvasGripperN = StyleId.of("gripper-n");
    public static final StyleId canvasGripperNE = StyleId.of("gripper-ne");
    public static final StyleId canvasGripperW = StyleId.of("gripper-e");
    public static final StyleId canvasGripperC = StyleId.of("gripper-c");
    public static final StyleId canvasGripperE = StyleId.of("gripper-w");
    public static final StyleId canvasGripperSW = StyleId.of("gripper-sw");
    public static final StyleId canvasGripperS = StyleId.of("gripper-s");
    public static final StyleId canvasGripperSE = StyleId.of("gripper-se");
    public static final StyleId image = StyleId.of("image");
    public static final StyleId imagePortrait = StyleId.of("portrait");
    public static final StyleId label = StyleId.of("label");
    public static final StyleId labelIcon = StyleId.of("icon");
    public static final StyleId labelShadow = StyleId.of("shadow");
    public static final StyleId labelTag = StyleId.of("tag");
    public static final StyleId labelVerticalCCW = StyleId.of("vertical-ccw");
    public static final StyleId labelVerticalCW = StyleId.of("vertical-cw");
    public static final StyleId labelSeparator = StyleId.of("separator");
    public static final StyleId styledlabel = StyleId.of("styledlabel");
    public static final StyleId styledlabelIcon = StyleId.of("icon");
    public static final StyleId styledlabelShadow = StyleId.of("shadow");
    public static final StyleId styledlabelTag = StyleId.of("tag");
    public static final StyleId styledlabelVerticalCCW = StyleId.of("vertical-ccw");
    public static final StyleId styledlabelVerticalCW = StyleId.of("vertical-cw");
    public static final StyleId styledlabelSeparator = StyleId.of("separator");
    public static final StyleId tooltip = StyleId.of("tooltip");
    public static final StyleId tooltipStyled = StyleId.of("styled");
    public static final StyleId link = StyleId.of("link");
    public static final StyleId linkShadow = StyleId.of("shadow");
    public static final StyleId linkTag = StyleId.of("tag");
    public static final StyleId linkVerticalCCW = StyleId.of("vertical-ccw");
    public static final StyleId linkVerticalCW = StyleId.of("vertical-cw");
    public static final StyleId button = StyleId.of("button");
    public static final StyleId buttonStyled = StyleId.of("styled");
    public static final StyleId buttonHover = StyleId.of("hover");
    public static final StyleId buttonIcon = StyleId.of("icon");
    public static final StyleId buttonIconHover = StyleId.of("icon-hover");
    public static final StyleId buttonUndecorated = StyleId.of("undecorated");
    public static final StyleId splitbutton = StyleId.of("splitbutton");
    public static final StyleId splitbuttonStyled = StyleId.of("styled");
    public static final StyleId splitbuttonHover = StyleId.of("hover");
    public static final StyleId splitbuttonIcon = StyleId.of("icon");
    public static final StyleId splitbuttonIconHover = StyleId.of("icon-hover");
    public static final StyleId splitbuttonUndecorated = StyleId.of("undecorated");
    public static final StyleId togglebutton = StyleId.of("togglebutton");
    public static final StyleId togglebuttonStyled = StyleId.of("styled");
    public static final StyleId togglebuttonHover = StyleId.of("hover");
    public static final StyleId togglebuttonIcon = StyleId.of("icon");
    public static final StyleId togglebuttonIconHover = StyleId.of("icon-hover");
    public static final StyleId togglebuttonUndecorated = StyleId.of("undecorated");
    public static final StyleId checkbox = StyleId.of("checkbox");
    public static final StyleId checkboxStyled = StyleId.of("styled");
    public static final StyleId checkboxLink = StyleId.of("link");
    public static final StyleId tristatecheckbox = StyleId.of("tristatecheckbox");
    public static final StyleId tristatecheckboxStyled = StyleId.of("styled");
    public static final StyleId tristatecheckboxLink = StyleId.of("link");
    public static final StyleId radiobutton = StyleId.of("radiobutton");
    public static final StyleId radiobuttonStyled = StyleId.of("styled");
    public static final StyleId radiobuttonLink = StyleId.of("link");
    public static final StyleId separator = StyleId.of("separator");
    public static final StyleId separatorHorizontal = StyleId.of("horizontal");
    public static final StyleId separatorVertical = StyleId.of("vertical");
    public static final StyleId popupmenu = StyleId.of("popupmenu");
    public static final StyleId popupmenuseparator = StyleId.of("popupmenuseparator");
    public static final StyleId menubar = StyleId.of("menubar");
    public static final StyleId menubarUndecorated = StyleId.of("undecorated");
    public static final StyleId menu = StyleId.of("menu");
    public static final StyleId menuStyled = StyleId.of("styled");
    public static final ChildStyleId menuPopupMenu = ChildStyleId.of("popupmenu");
    public static final StyleId menuitem = StyleId.of("menuitem");
    public static final StyleId menuitemStyled = StyleId.of("styled");
    public static final StyleId checkboxmenuitem = StyleId.of("checkboxmenuitem");
    public static final StyleId checkboxmenuitemStyled = StyleId.of("styled");
    public static final StyleId radiobuttonmenuitem = StyleId.of("radiobuttonmenuitem");
    public static final StyleId radiobuttonmenuitemStyled = StyleId.of("styled");
    public static final StyleId panel = StyleId.of("panel");
    public static final StyleId panelNonOpaque = StyleId.of("non-opaque");
    public static final StyleId panelTransparent = StyleId.of("transparent");
    public static final StyleId panelDecorated = StyleId.of("decorated");
    public static final StyleId panelFocusable = StyleId.of("focusable");
    public static final StyleId lazypanel = StyleId.of("lazypanel");
    public static final StyleId lazypanelNonOpaque = StyleId.of("lazypanel-non-opaque");
    public static final StyleId lazypanelTransparent = StyleId.of("lazypanel-transparent");
    public static final StyleId lazypanelDecorated = StyleId.of("lazypanel-decorated");
    public static final StyleId lazypanelFocusable = StyleId.of("lazypanel-focusable");
    public static final StyleId grouppane = StyleId.of("grouppane");
    public static final StyleId overlay = StyleId.of("overlay");
    public static final StyleId progressoverlay = StyleId.of("progressoverlay");
    public static final ChildStyleId progressoverlayLayer = ChildStyleId.of("layer");
    public static final StyleId rootpane = StyleId.of("rootpane");
    public static final ChildStyleId rootpaneTitlePanel = ChildStyleId.of("title");
    public static final ChildStyleId rootpaneTitleIcon = ChildStyleId.of("icon");
    public static final ChildStyleId rootpaneTitleLabel = ChildStyleId.of("title");
    public static final ChildStyleId rootpaneButtonsPanel = ChildStyleId.of("buttons");
    public static final ChildStyleId rootpaneMinimizeButton = ChildStyleId.of("minimize");
    public static final ChildStyleId rootpaneMaximizeButton = ChildStyleId.of("maximize");
    public static final ChildStyleId rootpaneCloseButton = ChildStyleId.of("close");
    public static final ChildStyleId rootpaneContent = ChildStyleId.of("content");
    public static final StyleId window = StyleId.of("window");
    public static final StyleId windowTransparent = StyleId.of("window-transparent");
    public static final StyleId frame = StyleId.of("frame");
    public static final StyleId frameDecorated = StyleId.of("frame-decorated");
    public static final StyleId frameUndecorated = StyleId.of("frame-undecorated");
    public static final StyleId frameTransparent = StyleId.of("frame-transparent");
    public static final ChildStyleId frameGlassDialog = ChildStyleId.of("glass-dialog");
    public static final StyleId dialog = StyleId.of("dialog");
    public static final StyleId dialogDecorated = StyleId.of("dialog-decorated");
    public static final StyleId dialogUndecorated = StyleId.of("dialog-undecorated");
    public static final StyleId dialogTransparent = StyleId.of("dialog-transparent");
    public static final StyleId tabbedpane = StyleId.of("tabbedpane");
    public static final StyleId tabbedpaneEqual = StyleId.of("equal");
    public static final StyleId tabbedpaneVertical = StyleId.of("vertical");
    public static final ChildStyleId tabbedpaneTabArea = ChildStyleId.of("tab-area");
    public static final ChildStyleId tabbedpaneTabMenuButton = ChildStyleId.of("tab-menu-button");
    public static final ChildStyleId tabbedpaneTabMenu = ChildStyleId.of("menu");
    public static final ChildStyleId tabbedpaneTabMenuItem = ChildStyleId.of("item");
    public static final ChildStyleId tabbedpaneTabViewport = ChildStyleId.of("viewport");
    public static final ChildStyleId tabbedpaneTabContainer = ChildStyleId.of("container");
    public static final ChildStyleId tabbedpaneTabTitle = ChildStyleId.of("tab");
    public static final StyleId splitpanedivider = StyleId.of("splitpanedivider");
    public static final ChildStyleId splitpanedividerOneTouchButton = ChildStyleId.of("onetouch");
    public static final ChildStyleId splitpanedividerOneTouchLeftButton = ChildStyleId.of("onetouch-left");
    public static final ChildStyleId splitpanedividerOneTouchRightButton = ChildStyleId.of("onetouch-right");
    public static final StyleId splitpane = StyleId.of("splitpane");
    public static final StyleId splitpaneNonOpaque = StyleId.of("non-opaque");
    public static final StyleId splitpaneTransparent = StyleId.of("transparent");
    public static final StyleId splitpaneUndecorated = StyleId.of("undecorated");
    public static final StyleId splitpaneDecorated = StyleId.of("decorated");
    public static final StyleId splitpaneFocusable = StyleId.of("focusable");
    public static final ChildStyleId splitpaneContinuousDivider = ChildStyleId.of("continuous");
    public static final ChildStyleId splitpaneNonContinuousDivider = ChildStyleId.of("non-continuous");
    public static final StyleId multisplitpanedivider = StyleId.of("multisplitpanedivider");
    public static final ChildStyleId multisplitpanedividerOneTouchButton = ChildStyleId.of("onetouch");
    public static final ChildStyleId multisplitpanedividerOneTouchLeftButton = ChildStyleId.of("onetouch-left");
    public static final ChildStyleId multisplitpanedividerOneTouchRightButton = ChildStyleId.of("onetouch-right");
    public static final StyleId multisplitpane = StyleId.of("multisplitpane");
    public static final StyleId multisplitpaneNonOpaque = StyleId.of("non-opaque");
    public static final StyleId multisplitpaneTransparent = StyleId.of("transparent");
    public static final StyleId multisplitpaneUndecorated = StyleId.of("undecorated");
    public static final StyleId multisplitpaneDecorated = StyleId.of("decorated");
    public static final StyleId multisplitpaneFocusable = StyleId.of("focusable");
    public static final ChildStyleId multisplitpaneContinuousDivider = ChildStyleId.of("continuous");
    public static final ChildStyleId multisplitpaneNonContinuousDivider = ChildStyleId.of("non-continuous");
    public static final StyleId toolbar = StyleId.of("toolbar");
    public static final StyleId toolbarAttachedNorth = StyleId.of("attached-north");
    public static final StyleId toolbarAttachedWest = StyleId.of("attached-west");
    public static final StyleId toolbarAttachedEast = StyleId.of("attached-east");
    public static final StyleId toolbarAttachedSouth = StyleId.of("attached-south");
    public static final StyleId toolbarUndecorated = StyleId.of("undecorated");
    public static final StyleId toolbarseparator = StyleId.of("toolbarseparator");
    public static final StyleId statusbar = StyleId.of("statusbar");
    public static final StyleId memorybar = StyleId.of("memorybar");
    public static final StyleId memorybarUndecorated = StyleId.of("undecorated");
    public static final ChildStyleId memorybarToolTip = ChildStyleId.of("tooltip");
    public static final StyleId scrollbar = StyleId.of("scrollbar");
    public static final StyleId scrollbarUndecorated = StyleId.of("undecorated");
    public static final StyleId scrollbarButtonless = StyleId.of("buttonless");
    public static final StyleId scrollbarUndecoratedButtonless = StyleId.of("undecorated-buttonless");
    public static final ChildStyleId scrollbarButton = ChildStyleId.of("button");
    public static final ChildStyleId scrollbarDecreaseButton = ChildStyleId.of("decrease");
    public static final ChildStyleId scrollbarIncreaseButton = ChildStyleId.of("increase");
    public static final StyleId viewport = StyleId.of("viewport");
    public static final StyleId viewportTransparent = StyleId.of("transparent");
    public static final StyleId scrollpane = StyleId.of("scrollpane");
    public static final StyleId scrollpaneUndecorated = StyleId.of("undecorated");
    public static final StyleId scrollpaneNoFocus = StyleId.of("nofocus");
    public static final StyleId scrollpaneTransparent = StyleId.of("transparent");
    public static final StyleId scrollpaneButtonless = StyleId.of("buttonless");
    public static final StyleId scrollpaneUndecoratedButtonless = StyleId.of("undecorated-buttonless");
    public static final StyleId scrollpaneTransparentButtonless = StyleId.of("transparent-buttonless");
    public static final StyleId scrollpaneHovering = StyleId.of("hovering");
    public static final StyleId scrollpaneHoveringExtending = StyleId.of("hovering-extending");
    public static final StyleId scrollpaneTransparentHovering = StyleId.of("transparent-hovering");
    public static final StyleId scrollpaneTransparentHoveringExtending = StyleId.of("transparent-hovering-extending");
    public static final StyleId scrollpanePopup = StyleId.of("popup");
    public static final ChildStyleId scrollpaneViewport = ChildStyleId.of("viewport");
    public static final ChildStyleId scrollpaneBar = ChildStyleId.of("scrollbar");
    public static final ChildStyleId scrollpaneVerticalBar = ChildStyleId.of("vertical");
    public static final ChildStyleId scrollpaneHorizontalBar = ChildStyleId.of("horizontal");
    public static final ChildStyleId scrollpaneCorner = ChildStyleId.of("corner");
    public static final StyleId progressbar = StyleId.of("progressbar");
    public static final StyleId textfield = StyleId.of("textfield");
    public static final StyleId textfieldNonOpaque = StyleId.of("non-opaque");
    public static final StyleId textfieldTransparent = StyleId.of("transparent");
    public static final StyleId textfieldNoFocus = StyleId.of("nofocus");
    public static final StyleId passwordfield = StyleId.of("passwordfield");
    public static final StyleId passwordfieldNonOpaque = StyleId.of("non-opaque");
    public static final StyleId passwordfieldTransparent = StyleId.of("transparent");
    public static final StyleId passwordfieldNoFocus = StyleId.of("nofocus");
    public static final StyleId formattedtextfield = StyleId.of("formattedtextfield");
    public static final StyleId formattedtextfieldNonOpaque = StyleId.of("non-opaque");
    public static final StyleId formattedtextfieldTransparent = StyleId.of("transparent");
    public static final StyleId formattedtextfieldNoFocus = StyleId.of("nofocus");
    public static final StyleId pathfield = StyleId.of("pathfield");
    public static final StyleId pathfieldNonOpaque = StyleId.of("pathfield-non-opaque");
    public static final StyleId pathfieldTransparent = StyleId.of("pathfield-transparent");
    public static final ChildStyleId pathfieldContentPanel = ChildStyleId.of("content");
    public static final ChildStyleId pathfieldPathField = ChildStyleId.of("path-field");
    public static final ChildStyleId pathfieldPopupScroll = ChildStyleId.of("scroll");
    public static final ChildStyleId pathfieldRootButton = ChildStyleId.of("root");
    public static final ChildStyleId pathfieldElementButton = ChildStyleId.of("element");
    public static final ChildStyleId pathfieldMenuToggleButton = ChildStyleId.of("menu");
    public static final StyleId filechooserfield = StyleId.of("filechooserfield");
    public static final StyleId filechooserfieldUndecorated = StyleId.of("filechooserfield-undecorated");
    public static final ChildStyleId filechooserfieldContentPanel = ChildStyleId.of("content");
    public static final ChildStyleId filechooserfieldContentScroll = ChildStyleId.of("scroll");
    public static final ChildStyleId filechooserfieldFilePlate = ChildStyleId.of("file");
    public static final ChildStyleId filechooserfieldFileNameLabel = ChildStyleId.of("name");
    public static final ChildStyleId filechooserfieldFileRemoveButton = ChildStyleId.of("remove");
    public static final ChildStyleId filechooserfieldChooseButton = ChildStyleId.of("choose");
    public static final StyleId colorchooserfield = StyleId.of("colorchooserfield");
    public static final ChildStyleId colorchooserfieldEyedropperButton = ChildStyleId.of("eyedropper");
    public static final ChildStyleId colorchooserfieldColorButton = ChildStyleId.of("choose");
    public static final StyleId textarea = StyleId.of("textarea");
    public static final StyleId textareaNonOpaque = StyleId.of("non-opaque");
    public static final StyleId textareaTransparent = StyleId.of("transparent");
    public static final StyleId textareaDecorated = StyleId.of("decorated");
    public static final StyleId editorpane = StyleId.of("editorpane");
    public static final StyleId editorpaneNonOpaque = StyleId.of("non-opaque");
    public static final StyleId editorpaneTransparent = StyleId.of("transparent");
    public static final StyleId editorpaneDecorated = StyleId.of("decorated");
    public static final StyleId textpane = StyleId.of("textpane");
    public static final StyleId textpaneNonOpaque = StyleId.of("non-opaque");
    public static final StyleId textpaneTransparent = StyleId.of("transparent");
    public static final StyleId textpaneDecorated = StyleId.of("decorated");
    public static final StyleId tableheader = StyleId.of("tableheader");
    public static final ChildStyleId tableheaderCellRenderer = ChildStyleId.of("renderer");
    public static final StyleId table = StyleId.of("table");
    public static final StyleId tableNonOpaque = StyleId.of("non-opaque");
    public static final StyleId tableTransparent = StyleId.of("transparent");
    public static final ChildStyleId tableHeader = ChildStyleId.of("header");
    public static final ChildStyleId tableHeaderCellRenderer = ChildStyleId.of("renderer");
    public static final ChildStyleId tableCorner = ChildStyleId.of("corner");
    public static final ChildStyleId tableCellRenderer = ChildStyleId.of("renderer");
    public static final ChildStyleId tableCellRendererNumber = ChildStyleId.of("renderer-number");
    public static final ChildStyleId tableCellRendererDouble = ChildStyleId.of("renderer-double");
    public static final ChildStyleId tableCellRendererFloat = ChildStyleId.of("renderer-float");
    public static final ChildStyleId tableCellRendererDate = ChildStyleId.of("renderer-date");
    public static final ChildStyleId tableCellRendererIcon = ChildStyleId.of("renderer-icon");
    public static final ChildStyleId tableCellRendererBoolean = ChildStyleId.of("renderer-boolean");
    public static final ChildStyleId tableCellEditor = ChildStyleId.of("editor");
    public static final ChildStyleId tableCellEditorGemeric = ChildStyleId.of("editor-generic");
    public static final ChildStyleId tableCellEditorBoolean = ChildStyleId.of("editor-boolean");
    public static final ChildStyleId tableCellEditorDate = ChildStyleId.of("editor-date");
    public static final StyleId filetable = StyleId.of("filetable");
    public static final StyleId filetableNonOpaque = StyleId.of("filetable-non-opaque");
    public static final StyleId filetableTransparent = StyleId.of("filetable-transparent");
    public static final StyleId slider = StyleId.of("slider");
    public static final ChildStyleId sliderTickLabel = ChildStyleId.of("tick");
    public static final StyleId spinner = StyleId.of("spinner");
    public static final ChildStyleId spinnerEditorContainer = ChildStyleId.of("editor-container");
    public static final ChildStyleId spinnerEditor = ChildStyleId.of("editor");
    public static final ChildStyleId spinnerButton = ChildStyleId.of("button");
    public static final ChildStyleId spinnerNextButton = ChildStyleId.of("next");
    public static final ChildStyleId spinnerPreviousButton = ChildStyleId.of("previous");
    public static final StyleId combobox = StyleId.of("combobox");
    public static final StyleId comboboxHover = StyleId.of("hover");
    public static final StyleId comboboxUndecorated = StyleId.of("undecorated");
    public static final ChildStyleId comboboxEditor = ChildStyleId.of("editor");
    public static final ChildStyleId comboboxSeparator = ChildStyleId.of("separator");
    public static final ChildStyleId comboboxArrowButton = ChildStyleId.of("arrow");
    public static final ChildStyleId comboboxPopup = ChildStyleId.of("popup");
    public static final ChildStyleId comboboxPopupScrollPane = ChildStyleId.of("scrollpane");
    public static final ChildStyleId comboboxPopupList = ChildStyleId.of("list");
    public static final ChildStyleId comboboxBoxRenderer = ChildStyleId.of("box-renderer");
    public static final ChildStyleId comboboxListRenderer = ChildStyleId.of("list-renderer");
    public static final StyleId list = StyleId.of("list");
    public static final StyleId listNonOpaque = StyleId.of("non-opaque");
    public static final StyleId listTransparent = StyleId.of("transparent");
    public static final ChildStyleId listCellRenderer = ChildStyleId.of("renderer");
    public static final ChildStyleId listTextCellRenderer = ChildStyleId.of("text-renderer");
    public static final ChildStyleId listIconCellRenderer = ChildStyleId.of("icon-renderer");
    public static final ChildStyleId listTextCellEditor = ChildStyleId.of("editor");
    public static final StyleId tree = StyleId.of("tree");
    public static final StyleId treeNonOpaque = StyleId.of("non-opaque");
    public static final StyleId treeTransparent = StyleId.of("transparent");
    public static final ChildStyleId treeCellRenderer = ChildStyleId.of("renderer");
    public static final ChildStyleId treeCellEditor = ChildStyleId.of("editor");
    public static final ChildStyleId treeCellEditorIcon = ChildStyleId.of("icon");
    public static final StyleId extree = StyleId.of("extree");
    public static final StyleId extreeNonOpaque = StyleId.of("extree-non-opaque");
    public static final StyleId extreeTransparent = StyleId.of("extree-transparent");
    public static final StyleId asynctree = StyleId.of("asynctree");
    public static final StyleId asynctreeNonOpaque = StyleId.of("asynctree-non-opaque");
    public static final StyleId asynctreeTransparent = StyleId.of("asynctree-transparent");
    public static final StyleId filetree = StyleId.of("filetree");
    public static final StyleId filetreeNonOpaque = StyleId.of("filetree-non-opaque");
    public static final StyleId filetreeTransparent = StyleId.of("filetree-transparent");
    public static final StyleId checkboxtree = StyleId.of("checkboxtree");
    public static final StyleId checkboxtreeNonOpaque = StyleId.of("checkboxtree-non-opaque");
    public static final StyleId checkboxtreeTransparent = StyleId.of("checkboxtree-transparent");
    public static final ChildStyleId checkboxtreeCellRenderer = ChildStyleId.of("renderer");
    public static final ChildStyleId checkboxtreeCheckBox = ChildStyleId.of("check");
    public static final StyleId excheckboxtree = StyleId.of("excheckboxtree");
    public static final StyleId excheckboxtreeNonOpaque = StyleId.of("excheckboxtree-non-opaque");
    public static final StyleId excheckboxtreeTransparent = StyleId.of("excheckboxtree-transparent");
    public static final StyleId interfacetree = StyleId.of("interfacetree");
    public static final StyleId interfacetreeNonOpaque = StyleId.of("interfacetree-non-opaque");
    public static final StyleId interfacetreeTransparent = StyleId.of("interfacetree-transparent");
    public static final StyleId colorchooserpanel = StyleId.of("colorchooser");
    public static final StyleId colorchooser = StyleId.of("colorchooser");
    public static final StyleId colorchooserDialog = StyleId.of("colorchooser");
    public static final ChildStyleId colorchooserContent = ChildStyleId.of("content");
    public static final ChildStyleId colorchooserLabel = ChildStyleId.of("label");
    public static final ChildStyleId colorchooserControlsPanel = ChildStyleId.of("controls");
    public static final ChildStyleId colorchooserWebonlyCheck = ChildStyleId.of("webonly");
    public static final ChildStyleId colorchooserOkButton = ChildStyleId.of("ok");
    public static final ChildStyleId colorchooserResetButton = ChildStyleId.of("reset");
    public static final ChildStyleId colorchooserCancelButton = ChildStyleId.of("cancel");
    public static final StyleId filechooser = StyleId.of("filechooser");
    public static final StyleId filechooserDialog = StyleId.of("filechooser");
    public static final StyleId filechooserPanel = StyleId.of("filechooser");
    public static final ChildStyleId filechooserToolbar = ChildStyleId.of("decorated-bar");
    public static final ChildStyleId filechooserUndecoratedToolbar = ChildStyleId.of("undecorated-bar");
    public static final ChildStyleId filechooserToolbarButton = ChildStyleId.of("tool");
    public static final ChildStyleId filechooserPathField = ChildStyleId.of("path");
    public static final ChildStyleId filechooserHistoryScrollPane = ChildStyleId.of("history");
    public static final ChildStyleId filechooserCenterPanel = ChildStyleId.of("center");
    public static final ChildStyleId filechooserCenterSplit = ChildStyleId.of("center");
    public static final ChildStyleId filechooserNavScroll = ChildStyleId.of("nav");
    public static final ChildStyleId filechooserFileTree = ChildStyleId.of("file");
    public static final ChildStyleId filechooserViewScroll = ChildStyleId.of("view");
    public static final ChildStyleId filechooserFileListTiles = ChildStyleId.of("file-tiles");
    public static final ChildStyleId filechooserFileListIcons = ChildStyleId.of("file-icons");
    public static final ChildStyleId filechooserFileTable = ChildStyleId.of("file-table");
    public static final ChildStyleId filechooserSouthPanel = ChildStyleId.of("south");
    public static final ChildStyleId filechooserSelectedLabel = ChildStyleId.of("selected");
    public static final ChildStyleId filechooserAcceptButton = ChildStyleId.of("accept");
    public static final ChildStyleId filechooserCancelButton = ChildStyleId.of("cancel");
    public static final ChildStyleId filechooserRemovalListPanel = ChildStyleId.of("removal");
    public static final StyleId desktoppane = StyleId.of("desktoppane");
    public static final StyleId desktoppaneTransparent = StyleId.of("transparent");
    public static final StyleId desktopicon = StyleId.of("desktopicon");
    public static final StyleId internalframe = StyleId.of("internalframe");
    public static final ChildStyleId internalframeTitlePanel = ChildStyleId.of("title");
    public static final ChildStyleId internalframeTitleIcon = ChildStyleId.of("icon");
    public static final ChildStyleId internalframeTitleLabel = ChildStyleId.of("title");
    public static final ChildStyleId internalframeButtonsPanel = ChildStyleId.of("buttons");
    public static final ChildStyleId internalframeMinimizeButton = ChildStyleId.of("minimize");
    public static final ChildStyleId internalframeMaximizeButton = ChildStyleId.of("maximize");
    public static final ChildStyleId internalframeCloseButton = ChildStyleId.of("close");
    public static final ChildStyleId internalframeRootpane = ChildStyleId.of("rootpane");
    public static final StyleId dockablepane = StyleId.of("dockablepane");
    public static final StyleId dockablepaneCompact = StyleId.of("compact");
    public static final ChildStyleId dockablepaneEmpty = ChildStyleId.of("empty");
    public static final ChildStyleId dockablepaneFloating = ChildStyleId.of("floating");
    public static final StyleId dockableframe = StyleId.of("dockableframe");
    public static final StyleId dockableframeCompact = StyleId.of("compact");
    public static final ChildStyleId dockableframeTitlePanel = ChildStyleId.of("title");
    public static final ChildStyleId dockableframeTitleLabel = ChildStyleId.of("title");
    public static final ChildStyleId dockableframeTitleButtonsPanel = ChildStyleId.of("buttons");
    public static final ChildStyleId dockableframeTitleSeparator = ChildStyleId.of("tool");
    public static final ChildStyleId dockableframeTitleButton = ChildStyleId.of("tool");
    public static final ChildStyleId dockableframeTitleIconButton = ChildStyleId.of("tool-icon");
    public static final ChildStyleId dockableframeSidebarButton = ChildStyleId.of("sidebar");
    public static final StyleId optionpane = StyleId.of("optionpane");
    public static final StyleId optionpaneInformationDialog = StyleId.of("information");
    public static final StyleId optionpaneErrorDialog = StyleId.of("error");
    public static final StyleId optionpaneQuestionDialog = StyleId.of("question");
    public static final StyleId optionpaneWarningDialog = StyleId.of("warning");
    public static final ChildStyleId optionpaneMessageArea = ChildStyleId.of("message-area");
    public static final ChildStyleId optionpaneIconLabel = ChildStyleId.of("message-icon");
    public static final ChildStyleId optionpaneRealBody = ChildStyleId.of("real-body");
    public static final ChildStyleId optionpaneSeparator = ChildStyleId.of("separator");
    public static final ChildStyleId optionpaneBody = ChildStyleId.of("body");
    public static final ChildStyleId optionpaneMessageLabel = ChildStyleId.of("message");
    public static final ChildStyleId optionpaneButtonArea = ChildStyleId.of("button-area");
    public static final ChildStyleId optionpaneButton = ChildStyleId.of("button");
    public static final ChildStyleId optionpaneYesButton = ChildStyleId.of("yes");
    public static final ChildStyleId optionpaneNoButton = ChildStyleId.of("no");
    public static final ChildStyleId optionpaneOkButton = ChildStyleId.of("ok");
    public static final ChildStyleId optionpaneCancelButton = ChildStyleId.of("cancel");
    public static final StyleId popup = StyleId.of("popup");
    public static final StyleId popupTransparent = StyleId.of("transparent");
    public static final StyleId popupUndecorated = StyleId.of("undecorated");
    public static final StyleId notification = StyleId.of("notification");
    public static final ChildStyleId notificationOption = ChildStyleId.of("option");
    public static final StyleId hotkeylabel = StyleId.of("hotkeylabel");
    public static final StyleId customtooltip = StyleId.of("customtooltip");
    public static final StyleId customtooltipLabel = StyleId.of("customtooltip-label");
    public static final StyleId customtooltipHotkeyLabel = StyleId.of("customtooltip-hotkey");
    public static final StyleId wswitch = StyleId.of("switch");
    public static final ChildStyleId wswitchGripper = ChildStyleId.of("gripper");
    public static final ChildStyleId wswitchLabel = ChildStyleId.of("option");
    public static final ChildStyleId wswitchSelectedLabel = ChildStyleId.of("selected");
    public static final ChildStyleId wswitchDeselectedLabel = ChildStyleId.of("deselected");
    public static final ChildStyleId wswitchSelectedIconLabel = ChildStyleId.of("icon-selected");
    public static final ChildStyleId wswitchDeselectedIconLabel = ChildStyleId.of("icon-deselected");
    public static final StyleId languagechooser = StyleId.of("languagechooser");
    public static final StyleId languagechooserHover = StyleId.of("languagechooser-hover");
    public static final StyleId languagechooserUndecorated = StyleId.of("languagechooser-undecorated");
    public static final StyleId treefilterfield = StyleId.of("treefilterfield");
    public static final StyleId treefilterfieldNonOpaque = StyleId.of("treefilterfield-non-opaque");
    public static final StyleId treefilterfieldTransparent = StyleId.of("treefilterfield-transparent");
    public static final ChildStyleId treefilterfieldSettings = ChildStyleId.of("settings");
    public static final StyleId checkboxlist = StyleId.of("checkboxlist");
    public static final StyleId checkboxlistNonOpaque = StyleId.of("checkboxlist-non-opaque");
    public static final StyleId checkboxlistTransparent = StyleId.of("checkboxlist-transparent");
    public static final ChildStyleId checkboxlistCellRenderer = ChildStyleId.of("renderer");
    public static final ChildStyleId checkboxlistCellEditor = ChildStyleId.of("editor");
    public static final StyleId filelist = StyleId.of("filelist");
    public static final StyleId filelistNonOpaque = StyleId.of("filelist-non-opaque");
    public static final StyleId filelistTransparent = StyleId.of("filelist-transparent");
    public static final StyleId filelistTiles = StyleId.of("filelist-tiles");
    public static final StyleId filelistTilesNonOpaque = StyleId.of("filelist-tiles-non-opaque");
    public static final StyleId filelistTilesTransparent = StyleId.of("filelist-tiles-transparent");
    public static final StyleId filelistIcons = StyleId.of("filelist-icons");
    public static final StyleId filelistIconsNonOpaque = StyleId.of("filelist-icons-non-opaque");
    public static final StyleId filelistIconsTransparent = StyleId.of("filelist-icons-transparent");
    public static final ChildStyleId filelistCellRenderer = ChildStyleId.of("renderer");
    public static final ChildStyleId filelistCellRendererIcon = ChildStyleId.of("icon");
    public static final ChildStyleId filelistCellRendererName = ChildStyleId.of("name");
    public static final ChildStyleId filelistCellRendererDescription = ChildStyleId.of("description");
    public static final ChildStyleId filelistCellRendererSize = ChildStyleId.of("size");
    public static final ChildStyleId filelistTileCellRenderer = ChildStyleId.of("tile-renderer");
    public static final ChildStyleId filelistIconCellRenderer = ChildStyleId.of("icon-renderer");
    public static final ChildStyleId filelistCellEditor = ChildStyleId.of("editor");
    public static final StyleId filedrop = StyleId.of("filedrop");
    public static final ChildStyleId filedropPlate = ChildStyleId.of("plate");
    public static final ChildStyleId filedropPlateFileLabel = ChildStyleId.of("file");
    public static final ChildStyleId filedropPlateRemoveButton = ChildStyleId.of("remove");
    public static final StyleId collapsiblepane = StyleId.of("collapsiblepane");
    public static final StyleId collapsiblepaneUndecorated = StyleId.of("undecorated");
    public static final ChildStyleId collapsiblepaneHeaderPanel = ChildStyleId.of("header");
    public static final ChildStyleId collapsiblepaneTitleLabel = ChildStyleId.of("title");
    public static final ChildStyleId collapsiblepaneControlButton = ChildStyleId.of("control");
    public static final StyleId accordion = StyleId.of("accordion");
    public static final StyleId accordionUndecorated = StyleId.of("undecorated");
    public static final ChildStyleId accordionPane = ChildStyleId.of("pane");
    public static final ChildStyleId accordionPaneHeaderPanel = ChildStyleId.of("header");
    public static final ChildStyleId accordionPaneTitleLabel = ChildStyleId.of("title");
    public static final ChildStyleId accordionPaneControlButton = ChildStyleId.of("control");
    public static final StyleId innerpopup = StyleId.of("innerpopup");
    public static final StyleId popover = StyleId.of("popover");
    public static final StyleId calendar = StyleId.of("calendar");
    public static final ChildStyleId calendarSeparator = ChildStyleId.of("separator");
    public static final ChildStyleId calendarHeaderPanel = ChildStyleId.of("header");
    public static final ChildStyleId calendarButton = ChildStyleId.of("control");
    public static final ChildStyleId calendarPrevYearButton = ChildStyleId.of("prev-year");
    public static final ChildStyleId calendarPrevMonthButton = ChildStyleId.of("prev-month");
    public static final ChildStyleId calendarNextMonthButton = ChildStyleId.of("next-month");
    public static final ChildStyleId calendarNextYearButton = ChildStyleId.of("next-year");
    public static final ChildStyleId calendarTitleLabel = ChildStyleId.of("title");
    public static final ChildStyleId calendarWeekTitlesPanel = ChildStyleId.of("week-titles");
    public static final ChildStyleId calendarWeekTitleSeparator = ChildStyleId.of("separator");
    public static final ChildStyleId calendarWeekTitleLabel = ChildStyleId.of("title");
    public static final ChildStyleId calendarMonthPanel = ChildStyleId.of("month");
    public static final ChildStyleId calendarMonthDateSeparator = ChildStyleId.of("separator");
    public static final ChildStyleId calendarMonthDateToggleButton = ChildStyleId.of("date");
    public static final ChildStyleId calendarPreviousMonthDateToggleButton = ChildStyleId.of("previous-date");
    public static final ChildStyleId calendarCurrentMonthDateToggleButton = ChildStyleId.of("current-date");
    public static final ChildStyleId calendarWeekendMonthDateToggleButton = ChildStyleId.of("weekend-date");
    public static final ChildStyleId calendarNextMonthDateToggleButton = ChildStyleId.of("next-date");
    public static final StyleId datefield = StyleId.of("datefield");
    public static final StyleId datefieldNonOpaque = StyleId.of("non-opaque");
    public static final StyleId datefieldTransparent = StyleId.of("transparent");
    public static final StyleId datefieldNoFocus = StyleId.of("nofocus");
    public static final ChildStyleId datefieldField = ChildStyleId.of("field");
    public static final ChildStyleId datefieldButton = ChildStyleId.of("button");
    public static final ChildStyleId datefieldPopup = ChildStyleId.of("popup");
    public static final ChildStyleId datefieldCalendar = ChildStyleId.of("calendar");
    public static final StyleId breadcrumb = StyleId.of("breadcrumb");
    public static final StyleId breadcrumbUndecorated = StyleId.of("undecorated");
    public static final StyleId breadcrumbSeparated = StyleId.of("separated");
    public static final StyleId breadcrumbSeparatedUndecorated = StyleId.of("separated-undecorated");
    public static final ChildStyleId breadcrumbLabel = ChildStyleId.of("label");
    public static final ChildStyleId breadcrumbStyledLabel = ChildStyleId.of("styledlabel");
    public static final ChildStyleId breadcrumbLink = ChildStyleId.of("link");
    public static final ChildStyleId breadcrumbButton = ChildStyleId.of("button");
    public static final ChildStyleId breadcrumbToggleButton = ChildStyleId.of("togglebutton");
    public static final ChildStyleId breadcrumbSplitButton = ChildStyleId.of("splitbutton");
    public static final ChildStyleId breadcrumbComboBox = ChildStyleId.of("combobox");
    public static final ChildStyleId breadcrumbDateField = ChildStyleId.of("datefield");
    public static final ChildStyleId breadcrumbCheckBox = ChildStyleId.of("checkbox");
    public static final ChildStyleId breadcrumbTristateCheckBox = ChildStyleId.of("tristatecheckbox");
    public static final ChildStyleId breadcrumbRadioButton = ChildStyleId.of("radiobutton");
    public static final ChildStyleId breadcrumbTextField = ChildStyleId.of("textfield");
    public static final ChildStyleId breadcrumbFormattedTextField = ChildStyleId.of("formattedtextfield");
    public static final ChildStyleId breadcrumbPasswordField = ChildStyleId.of("passwordfield");
    public static final ChildStyleId breadcrumbPanel = ChildStyleId.of("panel");
    public static final StyleId syntaxareaScroll = StyleId.of("syntaxarea-scroll");
    public static final StyleId syntaxareaScrollUndecorated = StyleId.of("syntaxarea-scroll-undecorated");
    public static final StyleId syntaxareaScrollTransparentHovering = StyleId.of("syntaxarea-scroll-transparent-hovering");
    public static final ChildStyleId syntaxareaScrollGutter = ChildStyleId.of("gutter");
    public static final StyleId syntaxpanel = StyleId.of("syntaxpanel");
    public static final StyleId componentpane = StyleId.of("componentpane");
    public static final ChildStyleId componentpanePanel = ChildStyleId.of("panel");
    public static final StyleId directorychooser = StyleId.of("directorychooser");
    public static final ChildStyleId directorychooserToolbar = ChildStyleId.of("toolbar");
    public static final ChildStyleId directorychooserToolButton = ChildStyleId.of("button");
    public static final ChildStyleId directorychooserFolderUpButton = ChildStyleId.of("folderup");
    public static final ChildStyleId directorychooserHomeButton = ChildStyleId.of("home");
    public static final ChildStyleId directorychooserDesktopButton = ChildStyleId.of("desktop");
    public static final ChildStyleId directorychooserDriveButton = ChildStyleId.of("drive");
    public static final ChildStyleId directorychooserRefreshButton = ChildStyleId.of("refresh");
    public static final ChildStyleId directorychooserNewFolderButton = ChildStyleId.of("new-folder");
    public static final ChildStyleId directorychooserDeleteButton = ChildStyleId.of("delete");
    public static final ChildStyleId directorychooserPathField = ChildStyleId.of("path");
    public static final ChildStyleId directorychooserScroll = ChildStyleId.of("scroll");
    public static final ChildStyleId directorychooserFileSystem = ChildStyleId.of("file-system");
    public static final ChildStyleId directorychooserControlsPanel = ChildStyleId.of("controls");
    public static final ChildStyleId directorychooserControlButton = ChildStyleId.of("button");
    public static final ChildStyleId directorychooserAcceptButton = ChildStyleId.of("accept");
    public static final ChildStyleId directorychooserCancelButton = ChildStyleId.of("cancel");
    public static final StyleId documentpane = StyleId.of("documentpane");
    public static final ChildStyleId documentpaneSplit = ChildStyleId.of("split");
    public static final ChildStyleId documentpaneTabbedPane = ChildStyleId.of("tabbedpane");
    public static final ChildStyleId documentpaneTabPanel = ChildStyleId.of("tab");
    public static final ChildStyleId documentpaneTabTitle = ChildStyleId.of("title");
    public static final ChildStyleId documentpaneTabCloseButton = ChildStyleId.of("close");
    public static final ChildStyleId documentpaneMenu = ChildStyleId.of("menu");
    public static final StyleId inspector = StyleId.of("inspector");
    public static final StyleId inspectorPopover = StyleId.of("inspector-popover");
    public static final ChildStyleId inspectorFilter = ChildStyleId.of("filter");
    public static final ChildStyleId inspectorInspect = ChildStyleId.of("inspect");
    public static final ChildStyleId inspectorSeparator = ChildStyleId.of("separator");
    public static final ChildStyleId inspectorScroll = ChildStyleId.of("scroll");
    public static final ChildStyleId inspectorTree = ChildStyleId.of("tree");
    public static final StyleId styleeditor = StyleId.of("styleeditor");
    public static final ChildStyleId styleeditorSplit = ChildStyleId.of("split");
    public static final ChildStyleId styleeditorPreview = ChildStyleId.of("preview");
    public static final ChildStyleId styleeditorPreviewToolbar = ChildStyleId.of("toolbar");
    public static final ChildStyleId styleeditorPreviewTool = ChildStyleId.of("tool");
    public static final ChildStyleId styleeditorPreviewScroll = ChildStyleId.of("scroll");
    public static final ChildStyleId styleeditorPreviewPane = ChildStyleId.of("pane");
    public static final ChildStyleId styleeditorPreviewSingle = ChildStyleId.of("single");
    public static final ChildStyleId styleeditorPreviewSingleTitle = ChildStyleId.of("title");
    public static final ChildStyleId styleeditorPreviewSingleShadow = ChildStyleId.of("shadow");
    public static final ChildStyleId styleeditorPreviewSingleDashed = ChildStyleId.of("dashed");
    public static final ChildStyleId styleeditorPreviewSingleEmpty = ChildStyleId.of("empty");
    public static final ChildStyleId styleeditorEditors = ChildStyleId.of("editors");
    public static final ChildStyleId styleeditorEditorsTabs = ChildStyleId.of("tabs");
    public static final ChildStyleId styleeditorStatus = ChildStyleId.of("status");
    public static final ChildStyleId styleeditorStatusLabel = ChildStyleId.of("label");
    public static final ChildStyleId styleeditorStatusDelay = ChildStyleId.of("delay");
    public static final ChildStyleId styleeditorStatusToggle = ChildStyleId.of("toggle");
    @Nullable
    private final String id;
    @Nullable
    private final WeakReference<JComponent> parent;

    private StyleId(@Nullable String id) {
        this.id = id;
        this.parent = null;
    }

    private StyleId(@NotNull String id, @NotNull JComponent parent) {
        this.id = id;
        this.parent = new WeakReference<JComponent>(parent);
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    @Nullable
    public JComponent getParent() {
        return this.parent != null ? (JComponent)this.parent.get() : null;
    }

    public String getCompleteId() {
        JComponent parent = this.getParent();
        return parent != null ? StyleId.get(parent).getPathId(parent) + styleSeparator + this.getId() : this.getId();
    }

    @NotNull
    private String getPathId(@NotNull JComponent component) {
        ComponentDescriptor descriptor = StyleManager.getDescriptor(component);
        String fullId = descriptor.getId() + ":" + this.getId();
        JComponent parent = this.getParent();
        return parent != null ? StyleId.get(parent).getPathId(parent) + styleSeparator + fullId : fullId;
    }

    @NotNull
    public StyleId set(@NotNull JComponent component) {
        return StyleManager.setStyleId(component, this);
    }

    @NotNull
    public StyleId set(@NotNull Window window) {
        return this.set(CoreSwingUtils.getNonNullRootPane((Component)window));
    }

    public boolean equals(@Nullable Object obj) {
        boolean equals = false;
        if (obj instanceof StyleId) {
            StyleId other = (StyleId)obj;
            equals = Objects.equals((Object)this.getId(), (Object)other.getId()) && this.getParent() == other.getParent();
        }
        return equals;
    }

    @NotNull
    public String toString() {
        String info = this != auto ? String.format("id: '%s'; parent: %s", this.getCompleteId(), this.parent) : "auto";
        return "StyleId [ " + info + " ]";
    }

    @NotNull
    public static StyleId of(@NotNull String id) {
        return new StyleId(id);
    }

    @NotNull
    public static StyleId of(@NotNull String id, @NotNull JComponent parent) {
        return new StyleId(id, parent);
    }

    @NotNull
    public static StyleId of(@NotNull String id, @NotNull Window parent) {
        return StyleId.of(id, CoreSwingUtils.getNonNullRootPane((Component)parent));
    }

    @NotNull
    public static StyleId get(@NotNull JComponent component) {
        return StyleManager.getStyleId(component);
    }

    @NotNull
    public static StyleId get(@NotNull Window window) {
        return StyleId.get(CoreSwingUtils.getNonNullRootPane((Component)window));
    }

    @NotNull
    public static StyleId getDefault(@NotNull JComponent component) {
        ComponentDescriptor descriptor = StyleManager.getDescriptor(component);
        return descriptor.getDefaultStyleId(component);
    }

    @NotNull
    public static StyleId getDefault(@NotNull Window window) {
        return StyleId.getDefault(CoreSwingUtils.getNonNullRootPane((Component)window));
    }

    @NotNull
    public static String getCompleteId(@NotNull JComponent component) {
        return StyleId.get(component).getCompleteId();
    }

    @NotNull
    public static String getCompleteId(@NotNull Window window) {
        return StyleId.getCompleteId(CoreSwingUtils.getNonNullRootPane((Component)window));
    }
}

