/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.Function;
import com.alee.extended.accordion.AccordionDescriptor;
import com.alee.extended.accordion.AccordionLayout;
import com.alee.extended.accordion.AccordionPaneLayout;
import com.alee.extended.breadcrumb.BreadcrumbDescriptor;
import com.alee.extended.breadcrumb.BreadcrumbElementShape;
import com.alee.extended.breadcrumb.BreadcrumbLayout;
import com.alee.extended.breadcrumb.BreadcrumbProgressBackground;
import com.alee.extended.breadcrumb.element.BreadcrumbButtonPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbCheckBoxPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbComboBoxPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbDateFieldPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbFormattedTextFieldPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbLabelPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbLinkPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbPanelPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbPasswordFieldPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbRadioButtonPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbSplitButtonPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbStyledLabelPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbTextFieldPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbToggleButtonPainter;
import com.alee.extended.breadcrumb.element.BreadcrumbTristateCheckBoxPainter;
import com.alee.extended.button.SplitButtonDescriptor;
import com.alee.extended.canvas.CanvasDescriptor;
import com.alee.extended.canvas.Gripper;
import com.alee.extended.checkbox.MixedIcon;
import com.alee.extended.checkbox.TristateCheckBoxDescriptor;
import com.alee.extended.collapsible.CollapsiblePaneDescriptor;
import com.alee.extended.collapsible.CollapsiblePaneLayout;
import com.alee.extended.date.DateFieldDescriptor;
import com.alee.extended.dock.DockableFrameDescriptor;
import com.alee.extended.dock.DockablePaneDescriptor;
import com.alee.extended.image.ImageDescriptor;
import com.alee.extended.label.AbstractStyledTextContent;
import com.alee.extended.label.HotkeyLabelBackground;
import com.alee.extended.label.StyledLabelDescriptor;
import com.alee.extended.label.StyledLabelText;
import com.alee.extended.link.LinkDescriptor;
import com.alee.extended.memorybar.MemoryBarBackground;
import com.alee.extended.memorybar.MemoryBarDescriptor;
import com.alee.extended.memorybar.MemoryBarText;
import com.alee.extended.overlay.OverlayDescriptor;
import com.alee.extended.overlay.OverlayLayout;
import com.alee.extended.overlay.ProgressOverlayBackground;
import com.alee.extended.overlay.ProgressOverlayShape;
import com.alee.extended.panel.SelectablePanelPainter;
import com.alee.extended.split.MultiSplitPaneDescriptor;
import com.alee.extended.split.MultiSplitPaneDividerDescriptor;
import com.alee.extended.statusbar.StatusBarDescriptor;
import com.alee.extended.statusbar.StatusBarLayout;
import com.alee.extended.syntax.SyntaxPanelPainter;
import com.alee.extended.window.PopOverPainter;
import com.alee.extended.window.PopupDescriptor;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.button.ButtonDescriptor;
import com.alee.laf.button.ButtonIcon;
import com.alee.laf.button.ButtonLayout;
import com.alee.laf.button.ButtonText;
import com.alee.laf.button.SimpleButtonIcon;
import com.alee.laf.button.StyledButtonText;
import com.alee.laf.button.ToggleButtonDescriptor;
import com.alee.laf.checkbox.CheckBoxDescriptor;
import com.alee.laf.checkbox.CheckIcon;
import com.alee.laf.colorchooser.ColorChooserDescriptor;
import com.alee.laf.combobox.ComboBoxDescriptor;
import com.alee.laf.desktoppane.DesktopIconDescriptor;
import com.alee.laf.desktoppane.DesktopPaneDescriptor;
import com.alee.laf.desktoppane.InternalFrameDescriptor;
import com.alee.laf.filechooser.FileChooserDescriptor;
import com.alee.laf.label.LabelDescriptor;
import com.alee.laf.label.LabelIcon;
import com.alee.laf.label.LabelLayout;
import com.alee.laf.label.LabelText;
import com.alee.laf.list.ListDescriptor;
import com.alee.laf.menu.AcceleratorText;
import com.alee.laf.menu.CheckBoxMenuItemDescriptor;
import com.alee.laf.menu.MenuBarDescriptor;
import com.alee.laf.menu.MenuBarLayout;
import com.alee.laf.menu.MenuDescriptor;
import com.alee.laf.menu.MenuItemDescriptor;
import com.alee.laf.menu.MenuItemLayout;
import com.alee.laf.menu.MenuItemStateIcon;
import com.alee.laf.menu.PopupMenuDescriptor;
import com.alee.laf.menu.PopupMenuSeparatorDescriptor;
import com.alee.laf.menu.RadioButtonMenuItemDescriptor;
import com.alee.laf.menu.SimpleMenuItemLayout;
import com.alee.laf.optionpane.OptionPaneDescriptor;
import com.alee.laf.panel.PanelDescriptor;
import com.alee.laf.progressbar.ProgressBarDescriptor;
import com.alee.laf.progressbar.ProgressBarText;
import com.alee.laf.progressbar.ProgressShape;
import com.alee.laf.radiobutton.RadioButtonDescriptor;
import com.alee.laf.radiobutton.RadioIcon;
import com.alee.laf.rootpane.RootPaneDescriptor;
import com.alee.laf.scroll.ScrollBarDescriptor;
import com.alee.laf.scroll.ScrollPaneDescriptor;
import com.alee.laf.scroll.layout.ScrollPaneLayout;
import com.alee.laf.separator.SeparatorDescriptor;
import com.alee.laf.separator.SeparatorStripes;
import com.alee.laf.slider.SliderDescriptor;
import com.alee.laf.spinner.SpinnerDescriptor;
import com.alee.laf.splitpane.SplitPaneDescriptor;
import com.alee.laf.splitpane.SplitPaneDividerDescriptor;
import com.alee.laf.tabbedpane.TabAreaLayout;
import com.alee.laf.tabbedpane.TabBackground;
import com.alee.laf.tabbedpane.TabContainerLayout;
import com.alee.laf.tabbedpane.TabMenuItemText;
import com.alee.laf.tabbedpane.TabSize;
import com.alee.laf.tabbedpane.TabStretchType;
import com.alee.laf.tabbedpane.TabText;
import com.alee.laf.tabbedpane.TabbedPaneDescriptor;
import com.alee.laf.tabbedpane.TabbedPaneLayout;
import com.alee.laf.table.TableDescriptor;
import com.alee.laf.table.TableHeaderDescriptor;
import com.alee.laf.text.EditorPaneDescriptor;
import com.alee.laf.text.FormattedTextFieldDescriptor;
import com.alee.laf.text.PasswordFieldDescriptor;
import com.alee.laf.text.TextAreaDescriptor;
import com.alee.laf.text.TextFieldDescriptor;
import com.alee.laf.text.TextPaneDescriptor;
import com.alee.laf.toolbar.ToolBarDescriptor;
import com.alee.laf.toolbar.ToolBarSeparatorDescriptor;
import com.alee.laf.toolbar.ToolbarLayout;
import com.alee.laf.tooltip.StyledToolTipText;
import com.alee.laf.tooltip.ToolTipDescriptor;
import com.alee.laf.tooltip.ToolTipText;
import com.alee.laf.tree.TreeDescriptor;
import com.alee.laf.viewport.ViewportDescriptor;
import com.alee.laf.viewport.ViewportLayout;
import com.alee.managers.animation.easing.Back;
import com.alee.managers.animation.easing.Bezier;
import com.alee.managers.animation.easing.Bounce;
import com.alee.managers.animation.easing.Circular;
import com.alee.managers.animation.easing.Cubic;
import com.alee.managers.animation.easing.Elastic;
import com.alee.managers.animation.easing.Exponential;
import com.alee.managers.animation.easing.Linear;
import com.alee.managers.animation.easing.Quadratic;
import com.alee.managers.animation.easing.Quartic;
import com.alee.managers.animation.easing.Quintic;
import com.alee.managers.animation.easing.Sinusoidal;
import com.alee.managers.icon.IconManager;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.Skin;
import com.alee.managers.style.SkinExtension;
import com.alee.managers.style.SkinListener;
import com.alee.managers.style.StyleData;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.StyleListener;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.SkinInfo;
import com.alee.painter.Painter;
import com.alee.painter.decoration.AbstractDecoration;
import com.alee.painter.decoration.Decorations;
import com.alee.painter.decoration.NinePatchDecoration;
import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.painter.decoration.background.AbstractClipBackground;
import com.alee.painter.decoration.background.AlphaLayerBackground;
import com.alee.painter.decoration.background.ColorBackground;
import com.alee.painter.decoration.background.ComponentBackground;
import com.alee.painter.decoration.background.GradientBackground;
import com.alee.painter.decoration.background.GradientColor;
import com.alee.painter.decoration.background.GradientType;
import com.alee.painter.decoration.background.ImageTextureBackground;
import com.alee.painter.decoration.background.MovingHighlightBackground;
import com.alee.painter.decoration.background.PresetTextureBackground;
import com.alee.painter.decoration.background.TextureType;
import com.alee.painter.decoration.border.AbstractBorder;
import com.alee.painter.decoration.border.LineBorder;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.painter.decoration.content.AbstractIconContent;
import com.alee.painter.decoration.content.AbstractTextContent;
import com.alee.painter.decoration.content.DashFocus;
import com.alee.painter.decoration.content.LocaleTextContent;
import com.alee.painter.decoration.content.RoundRectangle;
import com.alee.painter.decoration.content.Stripe;
import com.alee.painter.decoration.content.Stripes;
import com.alee.painter.decoration.layout.AbstractContentLayout;
import com.alee.painter.decoration.layout.AlignLayout;
import com.alee.painter.decoration.layout.BorderLayout;
import com.alee.painter.decoration.layout.IconTextLayout;
import com.alee.painter.decoration.layout.OverflowLineLayout;
import com.alee.painter.decoration.shadow.AbstractShadow;
import com.alee.painter.decoration.shadow.ExpandingShadow;
import com.alee.painter.decoration.shadow.WebShadow;
import com.alee.painter.decoration.shape.ArrowShape;
import com.alee.painter.decoration.shape.BoundsShape;
import com.alee.painter.decoration.shape.EllipseShape;
import com.alee.painter.decoration.shape.WebShape;
import com.alee.skin.light.WebLightSkin;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.ninepatch.NinePatchIcon;
import com.alee.utils.reflection.LazyInstance;
import com.alee.utils.swing.WeakComponentData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;

public final class StyleManager {
    @NotNull
    private static final EventListenerList listenerList = new EventListenerList();
    @NotNull
    private static final List<ComponentDescriptor> descriptors = new ArrayList<ComponentDescriptor>(60);
    @NotNull
    private static final Map<String, ComponentDescriptor> descriptorsByIdentifier = new HashMap<String, ComponentDescriptor>(60);
    @NotNull
    private static final Map<Class<? extends JComponent>, ComponentDescriptor> descriptorsByClass = new HashMap<Class<? extends JComponent>, ComponentDescriptor>(60);
    @NotNull
    private static final WeakComponentData<JComponent, StyleData> styleData = new WeakComponentData("StyleManager.StyleData", 200);
    @NotNull
    private static final List<SkinExtension> extensions = new ArrayList<SkinExtension>();
    @NotNull
    private static final Object skinLock = new Object();
    @Nullable
    private static LazyInstance<? extends Skin> defaultSkin = null;
    @Nullable
    private static Skin currentSkin = null;
    private static boolean strictStyleChecks = true;
    private static boolean initialized = false;

    public static synchronized void initialize() {
        if (!initialized) {
            StyleManager.initializeAnnotations();
            StyleManager.initializeDescriptors();
            initialized = true;
            StyleManager.setSkin(StyleManager.getDefaultSkin());
        }
    }

    private static void initializeAnnotations() {
        XmlUtils.processAnnotations(SkinInfo.class);
        XmlUtils.processAnnotations(ComponentStyle.class);
        XmlUtils.processAnnotations(NinePatchIcon.class);
        XmlUtils.processAnnotations(AbstractDecoration.class);
        XmlUtils.processAnnotations(Decorations.class);
        XmlUtils.processAnnotations(WebDecoration.class);
        XmlUtils.processAnnotations(NinePatchDecoration.class);
        XmlUtils.processAnnotations(AbstractShadow.class);
        XmlUtils.processAnnotations(BoundsShape.class);
        XmlUtils.processAnnotations(WebShape.class);
        XmlUtils.processAnnotations(EllipseShape.class);
        XmlUtils.processAnnotations(ArrowShape.class);
        XmlUtils.processAnnotations(ProgressShape.class);
        XmlUtils.processAnnotations(BreadcrumbElementShape.class);
        XmlUtils.processAnnotations(ProgressOverlayShape.class);
        XmlUtils.processAnnotations(WebShadow.class);
        XmlUtils.processAnnotations(ExpandingShadow.class);
        XmlUtils.processAnnotations(AbstractBorder.class);
        XmlUtils.processAnnotations(LineBorder.class);
        XmlUtils.processAnnotations(AbstractBackground.class);
        XmlUtils.processAnnotations(ComponentBackground.class);
        XmlUtils.processAnnotations(AbstractClipBackground.class);
        XmlUtils.processAnnotations(ColorBackground.class);
        XmlUtils.processAnnotations(GradientBackground.class);
        XmlUtils.processAnnotations(PresetTextureBackground.class);
        XmlUtils.processAnnotations(ImageTextureBackground.class);
        XmlUtils.processAnnotations(AlphaLayerBackground.class);
        XmlUtils.processAnnotations(MovingHighlightBackground.class);
        XmlUtils.processAnnotations(BreadcrumbProgressBackground.class);
        XmlUtils.processAnnotations(ProgressOverlayBackground.class);
        XmlUtils.processAnnotations(TextureType.class);
        XmlUtils.processAnnotations(GradientType.class);
        XmlUtils.processAnnotations(GradientColor.class);
        XmlUtils.processAnnotations(Stripes.class);
        XmlUtils.processAnnotations(Stripe.class);
        XmlUtils.processAnnotations(Gripper.class);
        XmlUtils.processAnnotations(BorderLayout.class);
        XmlUtils.processAnnotations(OverflowLineLayout.class);
        XmlUtils.processAnnotations(AlignLayout.class);
        XmlUtils.processAnnotations(AbstractContentLayout.class);
        XmlUtils.processAnnotations(IconTextLayout.class);
        XmlUtils.processAnnotations(AbstractContent.class);
        XmlUtils.processAnnotations(CheckIcon.class);
        XmlUtils.processAnnotations(RadioIcon.class);
        XmlUtils.processAnnotations(MixedIcon.class);
        XmlUtils.processAnnotations(SeparatorStripes.class);
        XmlUtils.processAnnotations(RoundRectangle.class);
        XmlUtils.processAnnotations(DashFocus.class);
        XmlUtils.processAnnotations(AbstractIconContent.class);
        XmlUtils.processAnnotations(AbstractTextContent.class);
        XmlUtils.processAnnotations(AbstractStyledTextContent.class);
        XmlUtils.processAnnotations(LocaleTextContent.class);
        XmlUtils.processAnnotations(ToolTipText.class);
        XmlUtils.processAnnotations(StyledToolTipText.class);
        XmlUtils.processAnnotations(TabText.class);
        XmlUtils.processAnnotations(TabMenuItemText.class);
        XmlUtils.processAnnotations(TabBackground.class);
        XmlUtils.processAnnotations(ButtonLayout.class);
        XmlUtils.processAnnotations(ButtonIcon.class);
        XmlUtils.processAnnotations(ButtonText.class);
        XmlUtils.processAnnotations(SimpleButtonIcon.class);
        XmlUtils.processAnnotations(StyledButtonText.class);
        XmlUtils.processAnnotations(LabelLayout.class);
        XmlUtils.processAnnotations(LabelIcon.class);
        XmlUtils.processAnnotations(LabelText.class);
        XmlUtils.processAnnotations(StyledLabelText.class);
        XmlUtils.processAnnotations(MenuItemLayout.class);
        XmlUtils.processAnnotations(SimpleMenuItemLayout.class);
        XmlUtils.processAnnotations(MenuItemStateIcon.class);
        XmlUtils.processAnnotations(AcceleratorText.class);
        XmlUtils.processAnnotations(ProgressBarText.class);
        XmlUtils.processAnnotations(HotkeyLabelBackground.class);
        XmlUtils.processAnnotations(MemoryBarBackground.class);
        XmlUtils.processAnnotations(MemoryBarText.class);
        XmlUtils.processAnnotations(PopOverPainter.class);
        XmlUtils.processAnnotations(SelectablePanelPainter.class);
        XmlUtils.processAnnotations(SyntaxPanelPainter.class);
        XmlUtils.processAnnotations(BreadcrumbPanelPainter.class);
        XmlUtils.processAnnotations(BreadcrumbLabelPainter.class);
        XmlUtils.processAnnotations(BreadcrumbStyledLabelPainter.class);
        XmlUtils.processAnnotations(BreadcrumbLinkPainter.class);
        XmlUtils.processAnnotations(BreadcrumbButtonPainter.class);
        XmlUtils.processAnnotations(BreadcrumbToggleButtonPainter.class);
        XmlUtils.processAnnotations(BreadcrumbSplitButtonPainter.class);
        XmlUtils.processAnnotations(BreadcrumbComboBoxPainter.class);
        XmlUtils.processAnnotations(BreadcrumbDateFieldPainter.class);
        XmlUtils.processAnnotations(BreadcrumbCheckBoxPainter.class);
        XmlUtils.processAnnotations(BreadcrumbTristateCheckBoxPainter.class);
        XmlUtils.processAnnotations(BreadcrumbRadioButtonPainter.class);
        XmlUtils.processAnnotations(BreadcrumbTextFieldPainter.class);
        XmlUtils.processAnnotations(BreadcrumbFormattedTextFieldPainter.class);
        XmlUtils.processAnnotations(BreadcrumbPasswordFieldPainter.class);
        XmlUtils.processAnnotations(ToolbarLayout.class);
        XmlUtils.processAnnotations(ToolbarLayout.UIResource.class);
        XmlUtils.processAnnotations(MenuBarLayout.class);
        XmlUtils.processAnnotations(MenuBarLayout.UIResource.class);
        XmlUtils.processAnnotations(StatusBarLayout.class);
        XmlUtils.processAnnotations(StatusBarLayout.UIResource.class);
        XmlUtils.processAnnotations(ScrollPaneLayout.class);
        XmlUtils.processAnnotations(ScrollPaneLayout.UIResource.class);
        XmlUtils.processAnnotations(ViewportLayout.class);
        XmlUtils.processAnnotations(ViewportLayout.UIResource.class);
        XmlUtils.processAnnotations(TabbedPaneLayout.class);
        XmlUtils.processAnnotations(TabbedPaneLayout.UIResource.class);
        XmlUtils.processAnnotations(TabAreaLayout.class);
        XmlUtils.processAnnotations(TabAreaLayout.UIResource.class);
        XmlUtils.processAnnotations(TabStretchType.class);
        XmlUtils.processAnnotations(TabSize.class);
        XmlUtils.processAnnotations(TabContainerLayout.class);
        XmlUtils.processAnnotations(TabContainerLayout.UIResource.class);
        XmlUtils.processAnnotations(BreadcrumbLayout.class);
        XmlUtils.processAnnotations(BreadcrumbLayout.UIResource.class);
        XmlUtils.processAnnotations(CollapsiblePaneLayout.class);
        XmlUtils.processAnnotations(CollapsiblePaneLayout.UIResource.class);
        XmlUtils.processAnnotations(AccordionLayout.class);
        XmlUtils.processAnnotations(AccordionLayout.UIResource.class);
        XmlUtils.processAnnotations(AccordionPaneLayout.class);
        XmlUtils.processAnnotations(AccordionPaneLayout.UIResource.class);
        XmlUtils.processAnnotations(OverlayLayout.class);
        XmlUtils.processAnnotations(OverlayLayout.UIResource.class);
        XmlUtils.processAnnotations(Linear.class);
        XmlUtils.processAnnotations(Sinusoidal.In.class);
        XmlUtils.processAnnotations(Sinusoidal.Out.class);
        XmlUtils.processAnnotations(Sinusoidal.InOut.class);
        XmlUtils.processAnnotations(Quadratic.In.class);
        XmlUtils.processAnnotations(Quadratic.Out.class);
        XmlUtils.processAnnotations(Quadratic.InOut.class);
        XmlUtils.processAnnotations(Cubic.In.class);
        XmlUtils.processAnnotations(Cubic.Out.class);
        XmlUtils.processAnnotations(Cubic.InOut.class);
        XmlUtils.processAnnotations(Quartic.In.class);
        XmlUtils.processAnnotations(Quartic.Out.class);
        XmlUtils.processAnnotations(Quartic.InOut.class);
        XmlUtils.processAnnotations(Quintic.In.class);
        XmlUtils.processAnnotations(Quintic.Out.class);
        XmlUtils.processAnnotations(Quintic.InOut.class);
        XmlUtils.processAnnotations(Exponential.In.class);
        XmlUtils.processAnnotations(Exponential.Out.class);
        XmlUtils.processAnnotations(Exponential.InOut.class);
        XmlUtils.processAnnotations(Circular.In.class);
        XmlUtils.processAnnotations(Circular.Out.class);
        XmlUtils.processAnnotations(Circular.InOut.class);
        XmlUtils.processAnnotations(Back.In.class);
        XmlUtils.processAnnotations(Back.Out.class);
        XmlUtils.processAnnotations(Back.InOut.class);
        XmlUtils.processAnnotations(Elastic.In.class);
        XmlUtils.processAnnotations(Elastic.Out.class);
        XmlUtils.processAnnotations(Elastic.InOut.class);
        XmlUtils.processAnnotations(Bounce.In.class);
        XmlUtils.processAnnotations(Bounce.Out.class);
        XmlUtils.processAnnotations(Bounce.InOut.class);
        XmlUtils.processAnnotations(Bezier.class);
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"viewport");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"vsb");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"hsb");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"rowHead");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"colHead");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"lowerLeft");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"lowerRight");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"upperLeft");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"upperRight");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"vsbPolicy");
        XmlUtils.omitField(javax.swing.ScrollPaneLayout.class, (String)"hsbPolicy");
    }

    private static void initializeDescriptors() {
        StyleManager.registerComponentDescriptor(new CanvasDescriptor());
        StyleManager.registerComponentDescriptor(new ImageDescriptor());
        StyleManager.registerComponentDescriptor(new LabelDescriptor());
        StyleManager.registerComponentDescriptor(new StyledLabelDescriptor());
        StyleManager.registerComponentDescriptor(new ToolTipDescriptor());
        StyleManager.registerComponentDescriptor(new LinkDescriptor());
        StyleManager.registerComponentDescriptor(new ButtonDescriptor());
        StyleManager.registerComponentDescriptor(new SplitButtonDescriptor());
        StyleManager.registerComponentDescriptor(new ToggleButtonDescriptor());
        StyleManager.registerComponentDescriptor(new CheckBoxDescriptor());
        StyleManager.registerComponentDescriptor(new TristateCheckBoxDescriptor());
        StyleManager.registerComponentDescriptor(new RadioButtonDescriptor());
        StyleManager.registerComponentDescriptor(new SeparatorDescriptor());
        StyleManager.registerComponentDescriptor(new MenuBarDescriptor());
        StyleManager.registerComponentDescriptor(new MenuDescriptor());
        StyleManager.registerComponentDescriptor(new PopupMenuDescriptor());
        StyleManager.registerComponentDescriptor(new MenuItemDescriptor());
        StyleManager.registerComponentDescriptor(new CheckBoxMenuItemDescriptor());
        StyleManager.registerComponentDescriptor(new RadioButtonMenuItemDescriptor());
        StyleManager.registerComponentDescriptor(new PopupMenuSeparatorDescriptor());
        StyleManager.registerComponentDescriptor(new PanelDescriptor());
        StyleManager.registerComponentDescriptor(new OverlayDescriptor());
        StyleManager.registerComponentDescriptor(new BreadcrumbDescriptor());
        StyleManager.registerComponentDescriptor(new TabbedPaneDescriptor());
        StyleManager.registerComponentDescriptor(new SplitPaneDividerDescriptor());
        StyleManager.registerComponentDescriptor(new SplitPaneDescriptor());
        StyleManager.registerComponentDescriptor(new MultiSplitPaneDividerDescriptor());
        StyleManager.registerComponentDescriptor(new MultiSplitPaneDescriptor());
        StyleManager.registerComponentDescriptor(new PopupDescriptor());
        StyleManager.registerComponentDescriptor(new CollapsiblePaneDescriptor());
        StyleManager.registerComponentDescriptor(new AccordionDescriptor());
        StyleManager.registerComponentDescriptor(new RootPaneDescriptor());
        StyleManager.registerComponentDescriptor(new ToolBarDescriptor());
        StyleManager.registerComponentDescriptor(new ToolBarSeparatorDescriptor());
        StyleManager.registerComponentDescriptor(new StatusBarDescriptor());
        StyleManager.registerComponentDescriptor(new MemoryBarDescriptor());
        StyleManager.registerComponentDescriptor(new ScrollBarDescriptor());
        StyleManager.registerComponentDescriptor(new ViewportDescriptor());
        StyleManager.registerComponentDescriptor(new ScrollPaneDescriptor());
        StyleManager.registerComponentDescriptor(new TextFieldDescriptor());
        StyleManager.registerComponentDescriptor(new PasswordFieldDescriptor());
        StyleManager.registerComponentDescriptor(new FormattedTextFieldDescriptor());
        StyleManager.registerComponentDescriptor(new TextAreaDescriptor());
        StyleManager.registerComponentDescriptor(new EditorPaneDescriptor());
        StyleManager.registerComponentDescriptor(new TextPaneDescriptor());
        StyleManager.registerComponentDescriptor(new TableHeaderDescriptor());
        StyleManager.registerComponentDescriptor(new TableDescriptor());
        StyleManager.registerComponentDescriptor(new ProgressBarDescriptor());
        StyleManager.registerComponentDescriptor(new SliderDescriptor());
        StyleManager.registerComponentDescriptor(new SpinnerDescriptor());
        StyleManager.registerComponentDescriptor(new ComboBoxDescriptor());
        StyleManager.registerComponentDescriptor(new ListDescriptor());
        StyleManager.registerComponentDescriptor(new TreeDescriptor());
        StyleManager.registerComponentDescriptor(new ColorChooserDescriptor());
        StyleManager.registerComponentDescriptor(new FileChooserDescriptor());
        StyleManager.registerComponentDescriptor(new DesktopPaneDescriptor());
        StyleManager.registerComponentDescriptor(new DesktopIconDescriptor());
        StyleManager.registerComponentDescriptor(new InternalFrameDescriptor());
        StyleManager.registerComponentDescriptor(new DockablePaneDescriptor());
        StyleManager.registerComponentDescriptor(new DockableFrameDescriptor());
        StyleManager.registerComponentDescriptor(new OptionPaneDescriptor());
        StyleManager.registerComponentDescriptor(new DateFieldDescriptor());
    }

    private static void mustBeInitialized() throws StyleException {
        if (!initialized) {
            throw new StyleException("StyleManager must be initialized first");
        }
    }

    public static boolean isStrictStyleChecks() {
        return strictStyleChecks;
    }

    public static void setStrictStyleChecks(boolean strict) {
        strictStyleChecks = strict;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDescriptorsCount() {
        StyleManager.mustBeInitialized();
        List<ComponentDescriptor> list = descriptors;
        synchronized (list) {
            return descriptors.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ComponentDescriptor> getDescriptors() {
        StyleManager.mustBeInitialized();
        List<ComponentDescriptor> list = descriptors;
        synchronized (list) {
            return new ImmutableList(descriptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ComponentDescriptor getDescriptor(@NotNull String id) {
        StyleManager.mustBeInitialized();
        List<ComponentDescriptor> list = descriptors;
        synchronized (list) {
            ComponentDescriptor descriptor = descriptorsByIdentifier.get(id);
            if (descriptor == null) {
                throw new StyleException("There is no descriptor registered with identifier: " + id);
            }
            return descriptor;
        }
    }

    @NotNull
    public static ComponentDescriptor getDescriptor(@NotNull JComponent component) {
        return StyleManager.getDescriptor(component.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ComponentDescriptor getDescriptor(@NotNull Class<? extends JComponent> componentClass) {
        StyleManager.mustBeInitialized();
        List<ComponentDescriptor> list = descriptors;
        synchronized (list) {
            ComponentDescriptor descriptor = StyleManager.getDescriptorImpl(componentClass);
            if (descriptor == null) {
                throw new StyleException("There is no descriptor registered for: " + componentClass);
            }
            return descriptor;
        }
    }

    @Nullable
    private static ComponentDescriptor getDescriptorImpl(@NotNull Class<? extends JComponent> componentClass) {
        ComponentDescriptor descriptor;
        if (descriptorsByClass.containsKey(componentClass)) {
            descriptor = descriptorsByClass.get(componentClass);
        } else {
            Class<? extends JComponent> superclass = componentClass.getSuperclass();
            if (JComponent.class.isAssignableFrom(superclass)) {
                Class<? extends JComponent> componentSuperClass = superclass;
                descriptor = StyleManager.getDescriptorImpl(componentSuperClass);
                descriptorsByClass.put(componentClass, descriptor);
            } else {
                descriptor = null;
            }
        }
        return descriptor;
    }

    public static boolean isSupported(@NotNull String id) {
        return TextUtils.notEmpty((String)id) && descriptorsByIdentifier.containsKey(id);
    }

    public static boolean isSupported(@NotNull JComponent component) {
        return StyleManager.getDescriptorImpl(component.getClass()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerComponentDescriptor(@NotNull ComponentDescriptor descriptor) {
        WebLookAndFeel.checkEventDispatchThread();
        List<ComponentDescriptor> list = descriptors;
        synchronized (list) {
            Class componentClass = descriptor.getComponentClass();
            ComponentDescriptor toRemove = descriptorsByClass.get(componentClass);
            if (toRemove != null) {
                StyleManager.unregisterComponentDescriptor(toRemove);
            }
            descriptors.add(descriptor);
            descriptorsByIdentifier.put(descriptor.getId(), descriptor);
            descriptorsByClass.put(componentClass, descriptor);
            if (WebLookAndFeel.isInstalled()) {
                descriptor.updateDefaults(UIManager.getLookAndFeelDefaults());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregisterComponentDescriptor(@NotNull ComponentDescriptor descriptor) {
        WebLookAndFeel.checkEventDispatchThread();
        List<ComponentDescriptor> list = descriptors;
        synchronized (list) {
            descriptors.remove(descriptor);
            descriptorsByIdentifier.remove(descriptor.getId());
            Iterator<Map.Entry<Class<? extends JComponent>, ComponentDescriptor>> byClassIterator = descriptorsByClass.entrySet().iterator();
            while (byClassIterator.hasNext()) {
                if (byClassIterator.next().getValue() != descriptor) continue;
                byClassIterator.remove();
            }
        }
    }

    @NotNull
    public static LazyInstance<? extends Skin> getDefaultSkin() {
        return defaultSkin != null ? defaultSkin : new LazyInstance(WebLightSkin.class, new Object[0]);
    }

    public static void setDefaultSkin(@NotNull String skin, Object ... arguments) {
        try {
            Class skinClass = ReflectUtils.getClass((String)skin);
            StyleManager.setDefaultSkin((LazyInstance<? extends Skin>)new LazyInstance(skinClass, arguments));
        }
        catch (ClassNotFoundException e) {
            String msg = "Unable to load skin class for name: %s";
            throw new StyleException(String.format("Unable to load skin class for name: %s", skin), e);
        }
    }

    public static void setDefaultSkin(@NotNull Class<? extends Skin> skin, Object ... arguments) {
        StyleManager.setDefaultSkin((LazyInstance<? extends Skin>)new LazyInstance(skin, arguments));
    }

    public static void setDefaultSkin(@NotNull LazyInstance<? extends Skin> skin) {
        WebLookAndFeel.checkEventDispatchThread();
        defaultSkin = skin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Skin getSkin() {
        Object object = skinLock;
        synchronized (object) {
            if (currentSkin == null) {
                if (!initialized) {
                    throw new StyleException("StyleManager have to be initiaized first");
                }
                throw new StyleException("StyleManager wasn't able to initialize default skin");
            }
            return currentSkin;
        }
    }

    @Nullable
    public static Skin setSkin(@NotNull String skin, Object ... arguments) {
        try {
            Class skinClass = ReflectUtils.getClass((String)skin);
            return StyleManager.setSkin(skinClass, arguments);
        }
        catch (ClassNotFoundException e) {
            throw new StyleException(String.format("Unable to load skin class for name: %s", skin), e);
        }
    }

    @Nullable
    public static Skin setSkin(@NotNull Class<? extends Skin> skin, Object ... arguments) {
        return StyleManager.setSkin((LazyInstance<? extends Skin>)new LazyInstance(skin, arguments));
    }

    @Nullable
    public static Skin setSkin(@NotNull LazyInstance<? extends Skin> skin) {
        return StyleManager.setSkin((Skin)skin.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Skin setSkin(@NotNull Skin skin) {
        WebLookAndFeel.checkEventDispatchThread();
        StyleManager.mustBeInitialized();
        Object object = skinLock;
        synchronized (object) {
            if (!skin.isSupported()) {
                throw new StyleException(String.format("Skin is not supported in this system: %s", skin));
            }
            Skin previousSkin = currentSkin;
            if (previousSkin != null) {
                previousSkin.uninstall();
            }
            try {
                StyleManager.setSkinImpl(skin);
                StyleManager.fireSkinChanged(previousSkin, skin);
            }
            catch (Exception e) {
                if (previousSkin != null) {
                    StyleManager.setSkinImpl(previousSkin);
                }
                throw new StyleException("Unable to install skin: " + skin, e);
            }
            return previousSkin;
        }
    }

    private static void setSkinImpl(final @NotNull Skin skin) {
        currentSkin = skin;
        skin.install();
        styleData.forEach((BiConsumer)new BiConsumer<JComponent, StyleData>(){

            public void accept(JComponent component, StyleData styleData) {
                if (!styleData.isPinnedSkin() && styleData.getSkin() != currentSkin) {
                    styleData.applySkin(skin, false);
                }
            }
        });
        IconManager.clearIconCaches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtensions(SkinExtension ... extensions) {
        WebLookAndFeel.checkEventDispatchThread();
        Object object = skinLock;
        synchronized (object) {
            for (SkinExtension extension : extensions) {
                if (extension == null) {
                    throw new StyleException("Null extension provided");
                }
                StyleManager.extensions.add(extension);
                if (!initialized) continue;
                StyleManager.getSkin().applyExtension(extension);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<SkinExtension> getExtensions() {
        Object object = skinLock;
        synchronized (object) {
            return new ImmutableList(extensions);
        }
    }

    @NotNull
    public static StyleId getStyleId(@NotNull JComponent component) {
        return StyleManager.getData(component).getStyleId();
    }

    @NotNull
    public static StyleId setStyleId(@NotNull JComponent component, @NotNull StyleId id) {
        return StyleManager.getData(component).setStyleId(id);
    }

    @NotNull
    public static StyleId resetStyleId(@NotNull JComponent component) {
        return StyleManager.getData(component).resetStyleId(true);
    }

    public static void installSkin(@NotNull JComponent component) {
        StyleManager.getData(component).install();
    }

    public static void updateSkin(@NotNull JComponent component) {
        StyleManager.getData(component).updateSkin(true);
    }

    public static void uninstallSkin(@NotNull JComponent component) {
        StyleManager.getData(component).uninstall();
    }

    public static Skin getSkin(@NotNull JComponent component) {
        return StyleManager.getData(component).getSkin();
    }

    @Nullable
    public static Skin setSkin(@NotNull JComponent component, @NotNull Skin skin) {
        return StyleManager.setSkin(component, skin, false);
    }

    @Nullable
    public static Skin setSkin(@NotNull JComponent component, @NotNull Skin skin, boolean recursively) {
        return StyleManager.getData(component).applyCustomSkin(skin, recursively);
    }

    @Nullable
    public static Skin resetSkin(@NotNull JComponent component) {
        return StyleManager.getData(component).resetSkin();
    }

    public static void addStyleListener(@NotNull JComponent component, @NotNull StyleListener listener) {
        StyleManager.getData(component).addStyleListener(listener);
    }

    public static void removeStyleListener(@NotNull JComponent component, @NotNull StyleListener listener) {
        StyleManager.getData(component).removeStyleListener(listener);
    }

    @Nullable
    public static Painter getCustomPainter(@NotNull JComponent component) {
        return StyleManager.getData(component).getCustomPainter();
    }

    @Nullable
    public static Painter setCustomPainter(@NotNull JComponent component, @NotNull Painter painter) {
        return StyleManager.getData(component).setCustomPainter(painter);
    }

    public static boolean resetCustomPainter(@NotNull JComponent component) {
        return StyleManager.getData(component).resetCustomPainter();
    }

    @NotNull
    protected static StyleData getData(@NotNull JComponent component) {
        WebLookAndFeel.checkEventDispatchThread();
        StyleManager.mustBeInitialized();
        if (!StyleManager.isSupported(component)) {
            throw new StyleException(String.format("Component styling is not supported: %s", component));
        }
        if (!LafUtils.hasWebLafUI(component)) {
            component.updateUI();
            if (!LafUtils.hasWebLafUI(component)) {
                throw new StyleException(String.format("Component '%s' doesn't use WebLaF UI", component.getClass()));
            }
        }
        return (StyleData)styleData.get(component, (Function)new Function<JComponent, StyleData>(){

            public StyleData apply(@NotNull JComponent component) {
                return new StyleData(component);
            }
        });
    }

    public static void addSkinListener(@NotNull SkinListener listener) {
        listenerList.add(SkinListener.class, listener);
    }

    public static void removeSkinListener(@NotNull SkinListener listener) {
        listenerList.remove(SkinListener.class, listener);
    }

    public static void fireSkinChanged(@Nullable Skin previous, @NotNull Skin current) {
        for (SkinListener listener : (SkinListener[])listenerList.getListeners(SkinListener.class)) {
            listener.skinChanged(previous, current);
        }
    }
}

