/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.Clone;
import com.alee.api.clone.CloneBehavior;
import com.alee.api.clone.RecursiveClone;
import com.alee.api.clone.behavior.PreserveOnClone;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.Merge;
import com.alee.extended.layout.AbstractLayoutManager;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.data.ComponentStyleConverter;
import com.alee.managers.style.data.IgnoredValue;
import com.alee.managers.style.data.PainterStyle;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.utils.CollectionUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.swing.InsetsUIResource;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.ViewportLayout;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.slf4j.LoggerFactory;

@XStreamAlias(value="style")
@XStreamConverter(value=ComponentStyleConverter.class)
public final class ComponentStyle
implements CloneBehavior<ComponentStyle>,
Serializable {
    @XStreamAsAttribute
    private String type;
    @XStreamAsAttribute
    private String id;
    @XStreamAsAttribute
    private String extendsId;
    private LinkedHashMap<String, Object> componentProperties;
    private LinkedHashMap<String, Object> uiProperties;
    private PainterStyle painterStyle;
    private List<ComponentStyle> nestedStyles;
    @PreserveOnClone
    private transient ComponentStyle parent;

    @NotNull
    public String getType() {
        return this.type;
    }

    public void setType(@NotNull String type) {
        this.type = type;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public void setId(@NotNull String id) {
        this.id = id;
    }

    @NotNull
    public String getCompleteId() {
        ComponentStyle parentStyle = this.getParent();
        return parentStyle != null ? parentStyle.getPathId() + "." + this.getId() : this.getId();
    }

    @NotNull
    private String getPathId() {
        String fullId = this.getType() + ":" + this.getId();
        ComponentStyle parentStyle = this.getParent();
        return parentStyle != null ? parentStyle.getPathId() + "." + fullId : fullId;
    }

    @Nullable
    public String getExtendsId() {
        return this.extendsId;
    }

    public void setExtendsId(@Nullable String id) {
        this.extendsId = id;
    }

    @NotNull
    public LinkedHashMap<String, Object> getComponentProperties() {
        return this.componentProperties;
    }

    public void setComponentProperties(@NotNull LinkedHashMap<String, Object> componentProperties) {
        this.componentProperties = componentProperties;
    }

    @NotNull
    public LinkedHashMap<String, Object> getUIProperties() {
        return this.uiProperties;
    }

    public void setUIProperties(@NotNull LinkedHashMap<String, Object> uiProperties) {
        this.uiProperties = uiProperties;
    }

    @Nullable
    public PainterStyle getPainterStyle() {
        return this.painterStyle;
    }

    public void setPainterStyle(@Nullable PainterStyle painterStyle) {
        this.painterStyle = painterStyle;
    }

    @NotNull
    public List<ComponentStyle> getNestedStyles() {
        return this.nestedStyles;
    }

    public void setNestedStyles(@NotNull List<ComponentStyle> nestedStyles) {
        this.nestedStyles = nestedStyles;
    }

    public int getStylesCount() {
        return this.getNestedStyles().size();
    }

    @Nullable
    public ComponentStyle getParent() {
        return this.parent;
    }

    public void setParent(@Nullable ComponentStyle parent) {
        this.parent = parent;
    }

    public void apply(@NotNull JComponent component) {
        try {
            ComponentUI ui = this.getComponentUI(component);
            this.applyProperties(component, this.appendEmptyComponentProperties(this.getComponentProperties()));
            this.applyProperties(ui, this.getUIProperties());
            Painter customPainter = StyleManager.getCustomPainter(component);
            Painter painter = customPainter != null ? customPainter : this.createPainter(this.getPainterStyle());
            PainterSupport.setPainter(component, ui, painter);
        }
        catch (Exception e) {
            throw new StyleException(String.format("Unable to apply style '%s' to component: %s", this.getCompleteId(), component), e);
        }
    }

    @NotNull
    private Painter createPainter(@NotNull PainterStyle painterStyle) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, NoSuchFieldException {
        String painterClass = painterStyle.getPainterClass();
        Painter painter = (Painter)ReflectUtils.createInstanceSafely((String)painterClass, (Object[])new Object[0]);
        if (painter == null) {
            String msg = "Unable to create painter '%s' in style '%s'";
            throw new StyleException(String.format("Unable to create painter '%s' in style '%s'", painterClass, this.getId()));
        }
        this.applyProperties(painter, painterStyle.getProperties());
        return painter;
    }

    private void applyProperties(@NotNull Object object, @Nullable Map<String, Object> skinProperties) throws NoSuchFieldException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (skinProperties != null && skinProperties.size() > 0) {
            for (Map.Entry<String, Object> entry : skinProperties.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof PainterStyle) {
                    Painter painter = this.createPainter((PainterStyle)value);
                    this.setFieldValue(object, entry.getKey(), painter);
                    continue;
                }
                if (entry.getKey().equals("layout") && object instanceof Container) {
                    if (value == null || value instanceof LayoutManager) {
                        Container container = (Container)object;
                        LayoutManager oldLayout = container.getLayout();
                        if (!this.isReplaceableLayout(container, oldLayout) && value instanceof UIResource) continue;
                        LayoutManager newLayout = (LayoutManager)Clone.deep().clone((Object)((LayoutManager)value));
                        if (newLayout != null && newLayout instanceof AbstractLayoutManager) {
                            ((AbstractLayoutManager)newLayout).migrate(container, oldLayout);
                        }
                        container.setLayout(newLayout);
                        continue;
                    }
                    throw new StyleException("Value provided for Container `layout` property is not LayoutManager");
                }
                if (entry.getKey().equalsIgnoreCase("margin") && object instanceof JComponent) {
                    PainterSupport.setMargin((JComponent)object, (Insets)entry.getValue());
                    continue;
                }
                if (entry.getKey().equalsIgnoreCase("padding") && object instanceof JComponent) {
                    PainterSupport.setPadding((JComponent)object, (Insets)entry.getValue());
                    continue;
                }
                this.setFieldValue(object, entry.getKey(), value);
            }
        }
    }

    private boolean isReplaceableLayout(@NotNull Container container, @Nullable LayoutManager oldLayout) {
        return oldLayout == null || oldLayout instanceof UIResource || container instanceof JViewport && oldLayout == ReflectUtils.getStaticFieldValueSafely(ViewportLayout.class, (String)"SHARED_INSTANCE");
    }

    @NotNull
    protected Map<String, Object> appendEmptyComponentProperties(@NotNull Map<String, Object> properties) {
        if (!properties.containsKey("margin")) {
            properties.put("margin", new InsetsUIResource(0, 0, 0, 0));
        }
        if (!properties.containsKey("padding")) {
            properties.put("padding", new InsetsUIResource(0, 0, 0, 0));
        }
        return properties;
    }

    public void remove(@NotNull JComponent component) {
        try {
            ComponentUI ui = this.getComponentUI(component);
            PainterSupport.setPainter(component, ui, null);
        }
        catch (Exception e) {
            throw new StyleException(String.format("Unable to remove style '%s' from component: %s", this.getCompleteId(), component), e);
        }
    }

    private void setFieldValue(@NotNull Object object, @NotNull String field, @Nullable Object value) throws InvocationTargetException, IllegalAccessException {
        if (value != IgnoredValue.VALUE) {
            Object usable;
            if (value instanceof Painter) {
                usable = value;
            } else {
                try {
                    usable = Clone.deep().clone(value);
                }
                catch (Exception e) {
                    String msg = "Unable to clone value: %s";
                    throw new StyleException(String.format("Unable to clone value: %s", value), e);
                }
            }
            try {
                String setterMethod = ReflectUtils.getSetterMethodName((String)field);
                ReflectUtils.callMethod((Object)object, (String)setterMethod, (Object[])new Object[]{usable});
            }
            catch (NoSuchMethodException e) {
                try {
                    ReflectUtils.setFieldValue((Object)object, (String)field, (Object)usable);
                }
                catch (Exception fe) {
                    String msg = "Unable to set `%s` object `%s` field value to: %s";
                    throw new StyleException(String.format("Unable to set `%s` object `%s` field value to: %s", object, field, usable), fe);
                }
            }
        }
    }

    @NotNull
    private ComponentUI getComponentUI(@NotNull JComponent component) {
        Object ui = LafUtils.getUI(component);
        if (ui == null) {
            String msg = "Unable to retrieve UI from component '%s'";
            throw new StyleException(String.format("Unable to retrieve UI from component '%s'", component));
        }
        return ui;
    }

    @NotNull
    public ComponentStyle merge(@NotNull ComponentStyle style) {
        this.setParent(style.getParent());
        this.setId(style.getId());
        this.setExtendsId(style.getExtendsId());
        this.extend(style);
        return this;
    }

    @NotNull
    private ComponentStyle extend(@NotNull ComponentStyle style) {
        this.mergeProperties(this.getComponentProperties(), style.getComponentProperties());
        this.mergeProperties(this.getUIProperties(), style.getUIProperties());
        this.mergePainters(this, style);
        int nestedCount = this.getStylesCount();
        int mergedCount = style.getStylesCount();
        if (nestedCount > 0 && mergedCount > 0) {
            for (ComponentStyle child : this.getNestedStyles()) {
                this.extendChild(style, child);
            }
            List<ComponentStyle> nestedStyles = this.getNestedStyles();
            for (ComponentStyle mergedNestedStyle : style.getNestedStyles()) {
                ComponentStyle existing = null;
                for (ComponentStyle nestedStyle : this.getNestedStyles()) {
                    if (!Objects.equals((Object)mergedNestedStyle.getType(), (Object)nestedStyle.getType()) || !Objects.equals((Object)mergedNestedStyle.getId(), (Object)nestedStyle.getId())) continue;
                    existing = nestedStyle;
                    break;
                }
                if (existing != null) {
                    nestedStyles.remove(existing);
                    super.extend(mergedNestedStyle);
                    nestedStyles.add(existing);
                    continue;
                }
                ComponentStyle mergedNestedStyleClone = mergedNestedStyle.clone();
                mergedNestedStyleClone.setParent(this);
                nestedStyles.add(mergedNestedStyleClone);
            }
            this.setNestedStyles(nestedStyles);
        } else if (mergedCount > 0) {
            List mergedStylesClone = (List)Clone.deep().nonNullClone(style.getNestedStyles());
            for (ComponentStyle mergedStyleClone : mergedStylesClone) {
                mergedStyleClone.setParent(this);
            }
            this.setNestedStyles(mergedStylesClone);
        } else if (nestedCount > 0) {
            List baseStylesClone = (List)Clone.deep().nonNullClone(this.getNestedStyles());
            for (ComponentStyle baseStyleClone : baseStylesClone) {
                baseStyleClone.setParent(this);
            }
            this.setNestedStyles(baseStylesClone);
        }
        return this;
    }

    private void extendChild(@NotNull ComponentStyle style, @NotNull ComponentStyle child) {
        for (ComponentStyle newParentChild : style.getNestedStyles()) {
            if (!child.getId().equals(newParentChild.getId())) continue;
            return;
        }
        for (ComponentStyle mergedChild : style.getNestedStyles()) {
            if (!Objects.equals((Object)child.getExtendsId(), (Object)mergedChild.getId())) continue;
            style.getNestedStyles().add(child.clone().extend(mergedChild));
            return;
        }
    }

    private void mergePainters(@NotNull ComponentStyle style, @NotNull ComponentStyle mergedStyle) {
        PainterStyle resultPainterStyle;
        PainterStyle painterStyle = style.getPainterStyle();
        PainterStyle mergedPainterStyle = mergedStyle.getPainterStyle();
        if (painterStyle != null) {
            if (mergedPainterStyle != null) {
                Class painterClass = ReflectUtils.getClassSafely((String)mergedPainterStyle.getPainterClass());
                Class extendedPainterClass = ReflectUtils.getClassSafely((String)painterStyle.getPainterClass());
                if (painterClass == null || extendedPainterClass == null) {
                    String pc = painterClass == null ? mergedPainterStyle.getPainterClass() : painterStyle.getPainterClass();
                    String msg = "Component style '%s' points to a missing painter class: %s";
                    throw new StyleException(String.format("Component style '%s' points to a missing painter class: %s", mergedStyle, pc));
                }
                if (ReflectUtils.isAssignable((Class)extendedPainterClass, (Class)painterClass)) {
                    painterStyle.setPainterClass(mergedPainterStyle.getPainterClass());
                    this.mergeProperties(painterStyle.getProperties(), mergedPainterStyle.getProperties());
                    resultPainterStyle = painterStyle;
                } else {
                    resultPainterStyle = (PainterStyle)Clone.deep().nonNullClone((Object)mergedPainterStyle);
                }
            } else {
                resultPainterStyle = (PainterStyle)Clone.deep().nonNullClone((Object)painterStyle);
            }
        } else {
            resultPainterStyle = mergedPainterStyle != null ? (PainterStyle)Clone.deep().nonNullClone((Object)mergedPainterStyle) : null;
        }
        style.setPainterStyle(resultPainterStyle);
    }

    private void mergeProperties(@NotNull Map<String, Object> properties, @NotNull Map<String, Object> merged) {
        for (Map.Entry<String, Object> property : merged.entrySet()) {
            String key = property.getKey();
            Object existingValue = properties.get(key);
            Object mergedValue = property.getValue();
            try {
                Object result = Merge.deep().merge(existingValue, mergedValue);
                properties.put(key, result);
            }
            catch (Exception ex) {
                String msg = "Unable to merge property '%s' values: '%s' and '%s'";
                LoggerFactory.getLogger(ComponentStyle.class).error(String.format("Unable to merge property '%s' values: '%s' and '%s'", key, existingValue, mergedValue), (Throwable)ex);
            }
        }
    }

    @NotNull
    public ComponentStyle clone(@NotNull RecursiveClone clone, int depth) {
        ComponentStyle styleCopy = (ComponentStyle)clone.cloneFields((Object)this, depth);
        if (CollectionUtils.notEmpty(styleCopy.getNestedStyles())) {
            for (ComponentStyle styleCopyChild : styleCopy.getNestedStyles()) {
                styleCopyChild.setParent(styleCopy);
            }
        }
        return styleCopy;
    }

    @NotNull
    public ComponentStyle clone() {
        return (ComponentStyle)Clone.deep().nonNullClone((Object)this);
    }

    @NotNull
    public String toString() {
        return "ComponentStyle [ id: " + this.getCompleteId() + " ]";
    }
}

