/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleManager;
import com.alee.managers.style.data.ComponentStyle;
import com.alee.managers.style.data.PainterStyle;
import com.alee.managers.style.data.PainterStyleConverter;
import com.alee.managers.style.data.StyleConverterUtils;
import com.alee.painter.Painter;
import com.alee.utils.MapUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.swing.InsetsUIResource;
import com.alee.utils.xml.ConverterContext;
import com.alee.utils.xml.InsetsConverter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ComponentStyleConverter
extends ReflectionConverter {
    public static final String STYLE_NODE = "style";
    public static final String COMPONENT_TYPE_ATTRIBUTE = "type";
    public static final String STYLE_ID_ATTRIBUTE = "id";
    public static final String EXTENDS_ID_ATTRIBUTE = "extends";
    public static final String MARGIN_ATTRIBUTE = "margin";
    public static final String PADDING_ATTRIBUTE = "padding";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String COMPONENT_NODE = "component";
    public static final String UI_NODE = "ui";
    public static final String PAINTER_NODE = "painter";
    public static final String OVERWRITE_ATTRIBUTE = "overwrite";
    public static final String CONTEXT_COMPONENT_TYPE = "component.type";
    public static final String CONTEXT_STYLE_ID = "style.id";
    public static final String CONTEXT_COMPONENT_CLASS = "component.class";
    public static final String CONTEXT_UI_CLASS = "ui.class";
    public static final String CONTEXT_PAINTER_CLASS = "painter.class";

    public ComponentStyleConverter(@NotNull Mapper mapper, @NotNull ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    public boolean canConvert(@NotNull Class type) {
        return type.equals(ComponentStyle.class);
    }

    public void marshal(@NotNull Object source, HierarchicalStreamWriter writer, @NotNull MarshallingContext context) {
        PainterStyle painterStyle;
        LinkedHashMap<String, Object> componentProperties;
        LinkedHashMap<String, Object> uiProperties;
        String extendsId;
        ComponentStyle componentStyle = (ComponentStyle)source;
        writer.addAttribute(COMPONENT_TYPE_ATTRIBUTE, componentStyle.getType());
        String styleId = componentStyle.getId();
        ComponentDescriptor descriptor = StyleManager.getDescriptor(componentStyle.getType());
        if (!descriptor.getDefaultStyleId().getCompleteId().equals(styleId)) {
            writer.addAttribute(STYLE_ID_ATTRIBUTE, styleId);
        }
        if ((extendsId = componentStyle.getExtendsId()) != null) {
            writer.addAttribute(EXTENDS_ID_ATTRIBUTE, extendsId);
        }
        if (MapUtils.notEmpty(uiProperties = componentStyle.getUIProperties())) {
            Iterator padding;
            Insets margin = (Insets)uiProperties.get(MARGIN_ATTRIBUTE);
            if (margin != null) {
                writer.addAttribute(MARGIN_ATTRIBUTE, InsetsConverter.insetsToString((Insets)margin));
            }
            if ((padding = (Insets)uiProperties.get(PADDING_ATTRIBUTE)) != null) {
                writer.addAttribute(PADDING_ATTRIBUTE, InsetsConverter.insetsToString(padding));
            }
        }
        if (MapUtils.notEmpty(componentProperties = componentStyle.getComponentProperties())) {
            writer.startNode(COMPONENT_NODE);
            for (Map.Entry property : componentProperties.entrySet()) {
                String key = (String)property.getKey();
                if (!Objects.notEquals((Object)key, (Object[])new Object[]{MARGIN_ATTRIBUTE, PADDING_ATTRIBUTE})) continue;
                writer.startNode(key);
                context.convertAnother(property.getValue());
                writer.endNode();
            }
            writer.endNode();
        }
        if (MapUtils.notEmpty(uiProperties)) {
            writer.startNode(UI_NODE);
            for (Map.Entry property : uiProperties.entrySet()) {
                writer.startNode((String)property.getKey());
                context.convertAnother(property.getValue());
                writer.endNode();
            }
            writer.endNode();
        }
        if ((painterStyle = componentStyle.getPainterStyle()) != null) {
            String painterPackage;
            writer.startNode(PAINTER_NODE);
            String skinClassName = (String)context.get((Object)"skin.class");
            Class skinClass = ReflectUtils.getClassSafely((String)skinClassName);
            if (skinClass == null) {
                String msg = "Specified skin class '%s' cannot be found";
                throw new StyleException(String.format("Specified skin class '%s' cannot be found", skinClassName));
            }
            String painterClassName = painterStyle.getPainterClass();
            Class painterClass = ReflectUtils.getClassSafely((String)painterClassName);
            if (painterClass == null) {
                String msg = "Specified painter class '%s' cannot be found";
                throw new StyleException(String.format("Specified painter class '%s' cannot be found", painterClassName));
            }
            String skinPackage = skinClass.getPackage().getName();
            if (skinPackage.equals(painterPackage = painterClass.getPackage().getName())) {
                writer.addAttribute(CLASS_ATTRIBUTE, painterClassName.substring(skinPackage.length() + 1));
            } else {
                writer.addAttribute(CLASS_ATTRIBUTE, painterClassName);
            }
            for (Map.Entry<String, Object> property : painterStyle.getProperties().entrySet()) {
                writer.startNode(property.getKey());
                context.convertAnother(property.getValue());
                writer.endNode();
            }
            writer.endNode();
        }
    }

    public Object unmarshal(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context) {
        String paddingAttribute;
        ComponentStyle style = new ComponentStyle();
        LinkedHashMap<String, Object> componentProperties = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> uiProperties = new LinkedHashMap<String, Object>();
        ArrayList<ComponentStyle> nestedStyles = new ArrayList<ComponentStyle>();
        ConverterContext converterContext = ConverterContext.get();
        boolean oldUIResource = converterContext.isUIResource();
        converterContext.setUIResource(true);
        String type = reader.getAttribute(COMPONENT_TYPE_ATTRIBUTE);
        ComponentDescriptor descriptor = StyleManager.getDescriptor(type);
        style.setType(type);
        String oldComponentType = (String)context.get((Object)CONTEXT_COMPONENT_TYPE);
        context.put((Object)CONTEXT_COMPONENT_TYPE, (Object)type);
        String styleId = reader.getAttribute(STYLE_ID_ATTRIBUTE);
        style.setId(styleId != null ? styleId : descriptor.getDefaultStyleId().getCompleteId());
        String oldStyleId = (String)context.get((Object)CONTEXT_STYLE_ID);
        context.put((Object)CONTEXT_STYLE_ID, (Object)style.getId());
        style.setExtendsId(reader.getAttribute(EXTENDS_ID_ATTRIBUTE));
        String marginAttribute = reader.getAttribute(MARGIN_ATTRIBUTE);
        if (marginAttribute != null) {
            componentProperties.put(MARGIN_ATTRIBUTE, new InsetsUIResource(InsetsConverter.insetsFromString((String)marginAttribute)));
        }
        if ((paddingAttribute = reader.getAttribute(PADDING_ATTRIBUTE)) != null) {
            componentProperties.put(PADDING_ATTRIBUTE, new InsetsUIResource(InsetsConverter.insetsFromString((String)paddingAttribute)));
        }
        Object occ = context.get((Object)CONTEXT_COMPONENT_CLASS);
        Object ouic = context.get((Object)CONTEXT_UI_CLASS);
        Object opc = context.get((Object)CONTEXT_PAINTER_CLASS);
        context.put((Object)CONTEXT_COMPONENT_CLASS, descriptor.getComponentClass());
        context.put((Object)CONTEXT_UI_CLASS, descriptor.getUIClass());
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (nodeName.equals(COMPONENT_NODE)) {
                this.readComponentProperties(style, componentProperties, reader, context, descriptor);
            } else if (nodeName.equals(UI_NODE)) {
                this.readUIProperties(style, uiProperties, reader, context, descriptor);
            } else if (nodeName.equals(PAINTER_NODE)) {
                this.readPainterStyle(style, descriptor, reader, context);
            } else if (nodeName.equals(STYLE_NODE)) {
                this.readNestedStyles(style, nestedStyles, context);
            } else {
                String msg = "Unknown style settings block '%s' provided for '%s' style";
                throw new StyleException(String.format("Unknown style settings block '%s' provided for '%s' style", nodeName, styleId));
            }
            reader.moveUp();
        }
        style.setComponentProperties(componentProperties);
        style.setUIProperties(uiProperties);
        style.setNestedStyles(nestedStyles);
        context.put((Object)CONTEXT_COMPONENT_CLASS, occ);
        context.put((Object)CONTEXT_UI_CLASS, ouic);
        context.put((Object)CONTEXT_PAINTER_CLASS, opc);
        context.put((Object)CONTEXT_STYLE_ID, (Object)oldStyleId);
        context.put((Object)CONTEXT_COMPONENT_TYPE, (Object)oldComponentType);
        converterContext.setUIResource(oldUIResource);
        return style;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readComponentProperties(@NotNull ComponentStyle style, @NotNull Map<String, Object> componentProperties, @NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context, @NotNull ComponentDescriptor descriptor) {
        Class componentType = descriptor.getComponentClass();
        String componentClassName = reader.getAttribute(CLASS_ATTRIBUTE);
        if (componentClassName != null) {
            Class cc = ReflectUtils.getClassSafely((String)componentClassName);
            if (cc == null) {
                String msg = "Specified custom component class %s for style %s cannot be found";
                throw new StyleException(String.format("Specified custom component class %s for style %s cannot be found", componentClassName, style.getId()));
            }
            if (!componentType.isAssignableFrom(cc)) {
                String custom = cc.getCanonicalName();
                String basic = componentType.getCanonicalName();
                String msg = "Specified custom component class '%s' for style '%s' is not assignable from base class '%s'";
                throw new StyleException(String.format("Specified custom component class '%s' for style '%s' is not assignable from base class '%s'", custom, style.getId(), basic));
            }
            componentType = cc;
        }
        context.put((Object)CONTEXT_COMPONENT_CLASS, componentType);
        StyleConverterUtils.readProperties(reader, context, this.mapper, componentProperties, componentType, style.getId());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void readUIProperties(@NotNull ComponentStyle style, @NotNull Map<String, Object> uiProperties, @NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context, @NotNull ComponentDescriptor descriptor) {
        Class uiType = descriptor.getUIClass();
        String uiClassName = reader.getAttribute(CLASS_ATTRIBUTE);
        if (uiClassName != null) {
            Class uic = ReflectUtils.getClassSafely((String)uiClassName);
            if (uic == null) {
                String msg = "Specified custom UI class '%s' for style '%s' cannot be found";
                throw new StyleException(String.format("Specified custom UI class '%s' for style '%s' cannot be found", uiClassName, style.getId()));
            }
            if (!uiType.isAssignableFrom(uic)) {
                String custom = uic.getCanonicalName();
                String basic = uiType.getCanonicalName();
                String msg = "Specified custom UI class '%s' for style '%s' is not assignable from base UI class '%s'";
                throw new StyleException(String.format("Specified custom UI class '%s' for style '%s' is not assignable from base UI class '%s'", custom, style.getId(), basic));
            }
            uiType = uic;
        }
        context.put((Object)CONTEXT_UI_CLASS, uiType);
        StyleConverterUtils.readProperties(reader, context, this.mapper, uiProperties, uiType, style.getId());
    }

    private void readPainterStyle(@NotNull ComponentStyle style, @NotNull ComponentDescriptor descriptor, @NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context) {
        String ow = reader.getAttribute(OVERWRITE_ATTRIBUTE);
        Boolean overwrite = ow != null ? Boolean.valueOf(Boolean.parseBoolean(ow)) : null;
        Class defaultPainter = descriptor.getPainterClass();
        Class<? extends Painter> painterClass = PainterStyleConverter.unmarshalPainterClass(reader, context, this.mapper, defaultPainter, style.getId());
        Object opc = context.get((Object)CONTEXT_PAINTER_CLASS);
        context.put((Object)CONTEXT_PAINTER_CLASS, painterClass);
        PainterStyle painterStyle = new PainterStyle();
        painterStyle.setOverwrite(overwrite);
        painterStyle.setPainterClass(painterClass.getCanonicalName());
        LinkedHashMap<String, Object> painterProperties = new LinkedHashMap<String, Object>();
        StyleConverterUtils.readProperties(reader, context, this.mapper, painterProperties, painterClass, style.getId());
        painterStyle.setProperties(painterProperties);
        style.setPainterStyle(painterStyle);
        context.put((Object)CONTEXT_PAINTER_CLASS, opc);
    }

    private void readNestedStyles(@NotNull ComponentStyle style, @NotNull List<ComponentStyle> styles, @NotNull UnmarshallingContext context) {
        ComponentStyle childStyle = (ComponentStyle)context.convertAnother((Object)style, ComponentStyle.class);
        childStyle.setParent(style);
        styles.add(childStyle);
    }
}

