/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.api.annotations.NotNull;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.data.IgnoredValue;
import com.alee.utils.ReflectUtils;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Method;
import java.util.Map;

public final class StyleConverterUtils {
    public static final String IGNORED_ATTRIBUTE = "ignored";

    public static void readProperties(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context, @NotNull Mapper mapper, @NotNull Map<String, Object> properties, @NotNull Class clazz, String styleId) {
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            StyleConverterUtils.readProperty(reader, context, mapper, styleId, properties, clazz, reader.getNodeName());
            reader.moveUp();
        }
    }

    private static void readProperty(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context, @NotNull Mapper mapper, @NotNull String styleId, @NotNull Map<String, Object> properties, @NotNull Class propertyClass, @NotNull String propertyName) {
        String ignored = reader.getAttribute(IGNORED_ATTRIBUTE);
        if (Boolean.parseBoolean(ignored)) {
            properties.put(propertyName, IgnoredValue.VALUE);
        } else {
            Class fieldClass;
            String classAttribute = reader.getAttribute("class");
            if (classAttribute != null) {
                try {
                    fieldClass = mapper.realClass(classAttribute);
                }
                catch (CannotResolveClassException e) {
                    String msg = "Component property '%s' value from style '%s' has unknown type: %s";
                    throw new StyleException(String.format("Component property '%s' value from style '%s' has unknown type: %s", propertyName, styleId, classAttribute), e);
                }
            } else {
                fieldClass = ReflectUtils.getFieldTypeSafely((Class)propertyClass, (String)propertyName);
            }
            if (fieldClass != null) {
                try {
                    properties.put(propertyName, context.convertAnother(properties, fieldClass));
                }
                catch (Exception e) {
                    String msg = "Component property '%s' value from style '%s' cannot be read";
                    throw new StyleException(String.format("Component property '%s' value from style '%s' cannot be read", propertyName, styleId), e);
                }
            } else {
                Method getter = ReflectUtils.getFieldGetter((Class)propertyClass, (String)propertyName);
                if (getter != null) {
                    try {
                        Class<?> rClass = getter.getReturnType();
                        properties.put(propertyName, context.convertAnother(properties, rClass));
                    }
                    catch (Exception e) {
                        String msg = "Component property '%s' value from style '%s' cannot be read";
                        throw new StyleException(String.format("Component property '%s' value from style '%s' cannot be read", propertyName, styleId), e);
                    }
                } else {
                    String msg = "Component property '%s' type from style '%s' cannot be determined. Make sure it points to existing field or getter method";
                    throw new StyleException(String.format("Component property '%s' type from style '%s' cannot be determined. Make sure it points to existing field or getter method", propertyName, styleId));
                }
            }
        }
    }
}

