/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.api.annotations.NotNull;
import com.alee.managers.tooltip.ComponentArea;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public abstract class AbstractComponentArea<V, C extends JComponent>
implements ComponentArea<V, C> {
    protected void adjustBounds(@NotNull C component, @NotNull Component content, @NotNull Rectangle bounds) {
        if (content instanceof JLabel) {
            JLabel label = (JLabel)content;
            int align = label.getHorizontalAlignment();
            this.adjustBounds(component, content, bounds, align);
        } else if (content instanceof JCheckBox || content instanceof JRadioButton) {
            AbstractButton button = (AbstractButton)content;
            int align = button.getHorizontalAlignment();
            this.adjustBounds(component, content, bounds, align);
        }
    }

    protected void adjustBounds(@NotNull C component, @NotNull Component content, @NotNull Rectangle bounds, int align) {
        boolean ltr = content.getComponentOrientation().isLeftToRight();
        if (align == 2 || ltr ? align == 10 : align == 11) {
            Dimension preferred = content.getPreferredSize();
            bounds.width = preferred.width;
        } else if (align == 4 || ltr ? align == 11 : align == 10) {
            Dimension preferred = content.getPreferredSize();
            bounds.x = bounds.x + bounds.width - preferred.width;
            bounds.width = preferred.width;
        }
    }
}

