/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.tooltip.ComponentArea;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public abstract class AbstractToolTipProvider<V, C extends JComponent, A extends ComponentArea<V, C>>
implements ToolTipProvider<V, C, A> {
    @Nullable
    private WebCustomTooltip tooltip;
    @Nullable
    private WebTimer delayTimer;

    @Override
    public long getDelay() {
        return TooltipManager.getDefaultDelay();
    }

    @Override
    @Nullable
    public Rectangle getSourceBounds(@NotNull C component, @NotNull A area) {
        Rectangle bounds = area.getBounds(component);
        return bounds != null ? bounds.intersection(((JComponent)component).getVisibleRect()) : null;
    }

    @Override
    @Nullable
    public WebCustomTooltip getToolTip(@NotNull C component, @NotNull A area) {
        WebCustomTooltip tooltip;
        String text = this.getToolTipText(component, area);
        if (text != null) {
            TooltipWay direction = this.getDirection(component, area);
            tooltip = new WebCustomTooltip((Component)component, text, direction);
        } else {
            tooltip = null;
        }
        return tooltip;
    }

    @Override
    public void hoverAreaChanged(@NotNull C component, @Nullable A oldArea, @Nullable A newArea) {
        if (this.delayTimer != null) {
            this.delayTimer.stop();
        }
        if (this.tooltip != null) {
            this.tooltip.closeTooltip();
        }
        if (newArea != null) {
            long delay = this.getDelay();
            if (delay <= 0L) {
                this.showTooltip(component, newArea);
            } else {
                this.delayTimer = WebTimer.delay((long)delay, (ActionListener)new ActionListener((JComponent)component, (ComponentArea)newArea){
                    final /* synthetic */ JComponent val$component;
                    final /* synthetic */ ComponentArea val$newArea;
                    {
                        this.val$component = jComponent;
                        this.val$newArea = componentArea;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractToolTipProvider.this.showTooltip(this.val$component, this.val$newArea);
                    }
                });
            }
        }
    }

    protected void showTooltip(@NotNull C component, @NotNull A area) {
        WebCustomTooltip toolTip;
        Rectangle sourceBounds;
        if (this.isAvailable(component, area) && (sourceBounds = this.getSourceBounds(component, area)) != null && (toolTip = this.getToolTip(component, area)) != null) {
            this.tooltip = toolTip;
            this.tooltip.setRelativeToBounds(sourceBounds);
            TooltipManager.showOneTimeTooltip(this.tooltip);
        }
    }

    protected boolean isAvailable(@NotNull C component, @NotNull A area) {
        return area.isAvailable(component);
    }

    @Nullable
    protected V getValue(@NotNull C component, @NotNull A area) {
        return area.getValue(component);
    }

    @NotNull
    protected TooltipWay getDirection(@NotNull C component, @NotNull A area) {
        return TooltipWay.trailing;
    }

    @Nullable
    protected abstract String getToolTipText(@NotNull C var1, @NotNull A var2);
}

