/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.api.jdk.Objects;
import com.alee.managers.language.AbstractToolTipLanguage;
import com.alee.managers.language.Language;
import com.alee.managers.language.data.Text;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import javax.swing.JComponent;

public class CustomToolTipLanguage<C extends JComponent>
extends AbstractToolTipLanguage<C> {
    public static final String TYPE = "CUSTOM";
    protected static final String CUSTOM_TOOLTIP_MARKER = "custom.tooltip.marker";

    @Override
    public Class getComponentClass() {
        return WebCustomTooltip.class;
    }

    @Override
    public void update(C component, Language language, String key, Object ... data) {
        WebCustomTooltip oldToolTip = (WebCustomTooltip)((JComponent)component).getClientProperty(CUSTOM_TOOLTIP_MARKER);
        Text toolTipText = this.getToolTipText(language, key);
        if (toolTipText != null) {
            if (oldToolTip == null) {
                WebCustomTooltip customToolTip = TooltipManager.setTooltip(component, toolTipText.getText(new Object[0]));
                ((JComponent)component).putClientProperty(CUSTOM_TOOLTIP_MARKER, customToolTip);
            } else {
                oldToolTip.setTooltip(toolTipText.getText(new Object[0]));
            }
        } else if (oldToolTip != null) {
            TooltipManager.removeTooltips(component, new WebCustomTooltip[]{oldToolTip});
            ((JComponent)component).putClientProperty(CUSTOM_TOOLTIP_MARKER, null);
        }
    }

    protected Text getToolTipText(Language language, String key) {
        Text tooltip = language.getText(key, "custom-tooltip");
        if (tooltip == null && Objects.equals((Object)CustomToolTipLanguage.getDefaultToolTipType(), (Object)TYPE)) {
            tooltip = language.getText(key, "tooltip");
        }
        return tooltip;
    }
}

