/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.Clone;
import com.alee.api.jdk.Objects;
import com.alee.api.merge.Merge;
import com.alee.laf.grouping.GroupingLayout;
import com.alee.managers.focus.DefaultFocusTracker;
import com.alee.managers.focus.FocusManager;
import com.alee.managers.focus.FocusTracker;
import com.alee.managers.focus.GlobalFocusListener;
import com.alee.managers.hover.DefaultHoverTracker;
import com.alee.managers.hover.GlobalHoverListener;
import com.alee.managers.hover.HoverManager;
import com.alee.managers.hover.HoverTracker;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.PainterShapeProvider;
import com.alee.managers.style.StyleManager;
import com.alee.painter.AbstractPainter;
import com.alee.painter.Painter;
import com.alee.painter.PainterSupport;
import com.alee.painter.SectionPainter;
import com.alee.painter.decoration.DecorationUtils;
import com.alee.painter.decoration.Decorations;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.IDecorationPainter;
import com.alee.utils.CollectionUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;

public abstract class AbstractDecorationPainter<C extends JComponent, U extends ComponentUI, D extends IDecoration<C, D>>
extends AbstractPainter<C, U>
implements IDecorationPainter<C, U, D>,
PainterShapeProvider<C> {
    public static final String DECORATION_STATES_PROPERTY = "decorationStates";
    public static final String DECORATION_BORDER_PROPERTY = "decorationBorder";
    protected Decorations<C, D> decorations;
    protected transient ContainerListener containerListener;
    protected transient FocusTracker focusStateTracker;
    protected transient GlobalFocusListener inFocusedParentTracker;
    protected transient AncestorListener inFocusedParentAncestorListener;
    protected transient HoverTracker hoverStateTracker;
    protected transient GlobalHoverListener inHoveredParentTracker;
    protected transient AncestorListener inHoveredParentAncestorListener;
    protected transient HierarchyListener hierarchyTracker;
    protected transient ContainerListener neighboursTracker;
    protected transient List<String> states;
    protected transient Map<String, D> stateDecorationCache;
    protected transient Map<String, D> decorationCache;
    protected transient String current;
    protected transient boolean focused;
    protected transient boolean inFocusedParent;
    protected transient boolean hover;
    protected transient boolean inHoveredParent;
    protected transient Container ancestor;

    @Override
    protected void afterInstall() {
        this.states = this.collectDecorationStates();
        super.afterInstall();
    }

    @Override
    protected void beforeUninstall() {
        super.beforeUninstall();
        this.deactivateLastDecoration(this.component);
    }

    @Override
    protected void afterUninstall() {
        this.stateDecorationCache = null;
        this.decorationCache = null;
        this.states = null;
        super.afterUninstall();
    }

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installChildrenListeners();
        this.installFocusListeners();
        this.installInFocusedParentListeners();
        this.installHoverListeners();
        this.installInHoveredParentListeners();
        this.installBorderListeners();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallBorderListeners();
        this.uninstallInHoveredParentListeners();
        this.uninstallHoverListeners();
        this.uninstallInFocusedParentListeners();
        this.uninstallFocusListeners();
        this.uninstallChildrenListeners();
        super.uninstallPropertiesAndListeners();
    }

    @Override
    protected void propertyChanged(@NotNull String property, @Nullable Object oldValue, @Nullable Object newValue) {
        super.propertyChanged(property, oldValue, newValue);
        if (Objects.equals((Object)property, (Object)"focusable")) {
            this.updateFocusListeners();
        }
        if (Objects.equals((Object)property, (Object)DECORATION_STATES_PROPERTY)) {
            this.updateDecorationState();
        }
        if (Objects.equals((Object)property, (Object)DECORATION_BORDER_PROPERTY)) {
            this.updateBorder();
        }
        if (Objects.equals((Object)property, (Object)"enabled") && (this.usesState("enabled") || this.usesState("disabled"))) {
            this.updateDecorationState();
        }
    }

    @Override
    protected void orientationChange() {
        this.saveOrientation();
        this.updateDecorationState();
    }

    protected boolean usesContainerView() {
        return this.usesState("has-children") || this.usesState("has-no-children");
    }

    protected void installChildrenListeners() {
        if (this.usesContainerView()) {
            this.containerListener = new ContainerListener(){

                @Override
                public void componentAdded(@NotNull ContainerEvent event) {
                    AbstractDecorationPainter.this.childrenChanged(event);
                }

                @Override
                public void componentRemoved(@NotNull ContainerEvent event) {
                    AbstractDecorationPainter.this.childrenChanged(event);
                }
            };
            this.component.addContainerListener(this.containerListener);
        }
    }

    protected void childrenChanged(@NotNull ContainerEvent event) {
        this.updateDecorationState();
    }

    protected void uninstallChildrenListeners() {
        if (this.containerListener != null) {
            this.component.removeContainerListener(this.containerListener);
            this.containerListener = null;
        }
    }

    protected boolean usesFocusedView() {
        return this.component.isFocusable() && this.usesState("focused");
    }

    protected void installFocusListeners() {
        if (this.usesFocusedView()) {
            this.focusStateTracker = new DefaultFocusTracker(this.component, true){

                @Override
                public void focusChanged(boolean focused) {
                    AbstractDecorationPainter.this.focusChanged(focused);
                }
            };
            FocusManager.addFocusTracker(this.component, this.focusStateTracker);
            this.focused = this.focusStateTracker.isFocused();
        } else {
            this.focused = false;
        }
    }

    protected void focusChanged(boolean focused) {
        if (this.component != null) {
            this.focused = focused;
            this.updateDecorationState();
        }
    }

    protected boolean isFocused() {
        return this.focused;
    }

    protected void uninstallFocusListeners() {
        if (this.focusStateTracker != null) {
            FocusManager.removeFocusTracker(this.component, this.focusStateTracker);
            this.focusStateTracker = null;
            this.focused = false;
        }
    }

    protected void updateFocusListeners() {
        if (this.usesFocusedView()) {
            this.installFocusListeners();
        } else {
            this.uninstallFocusListeners();
        }
    }

    protected boolean usesInFocusedParentView() {
        return this.usesState("in-focused-parent");
    }

    protected void installInFocusedParentListeners() {
        if (this.usesInFocusedParentView()) {
            this.inFocusedParent = this.updateInFocusedParent();
            this.inFocusedParentTracker = new GlobalFocusListener(){

                @Override
                public void focusChanged(@Nullable Component oldFocus, @Nullable Component newFocus) {
                    AbstractDecorationPainter.this.updateInFocusedParent();
                }
            };
            FocusManager.registerGlobalFocusListener(this.component, this.inFocusedParentTracker);
            this.inFocusedParentAncestorListener = new AncestorListener(){

                @Override
                public void ancestorAdded(@NotNull AncestorEvent event) {
                    AbstractDecorationPainter.this.updateInFocusedParent();
                }

                @Override
                public void ancestorRemoved(@NotNull AncestorEvent event) {
                    AbstractDecorationPainter.this.updateInFocusedParent();
                }

                @Override
                public void ancestorMoved(@NotNull AncestorEvent event) {
                    AbstractDecorationPainter.this.updateInFocusedParent();
                }
            };
            this.component.addAncestorListener(this.inFocusedParentAncestorListener);
        } else {
            this.inFocusedParent = false;
        }
    }

    protected boolean updateInFocusedParent() {
        if (this.component != null) {
            boolean old = this.inFocusedParent;
            this.inFocusedParent = false;
            for (Container current = this.component; current != null; current = current.getParent()) {
                AbstractDecorationPainter dp;
                Painter painter;
                if (current.isFocusOwner()) {
                    this.inFocusedParent = true;
                    break;
                }
                if (current == this.component || !((painter = PainterSupport.getPainter(current)) instanceof AbstractDecorationPainter) || !(dp = (AbstractDecorationPainter)painter).usesFocusedView()) continue;
                this.inFocusedParent = dp.isFocused();
                break;
            }
            if (Objects.notEquals((Object)old, (Object)this.inFocusedParent)) {
                this.updateDecorationState();
            }
        }
        return this.inFocusedParent;
    }

    protected boolean isInFocusedParent() {
        return this.inFocusedParent;
    }

    protected void uninstallInFocusedParentListeners() {
        if (this.inFocusedParentTracker != null) {
            this.component.removeAncestorListener(this.inFocusedParentAncestorListener);
            this.inFocusedParentAncestorListener = null;
            FocusManager.unregisterGlobalFocusListener(this.component, this.inFocusedParentTracker);
            this.inFocusedParentTracker = null;
            this.inFocusedParent = false;
        }
    }

    protected boolean usesHoverView() {
        return this.usesState("hover");
    }

    protected void installHoverListeners() {
        if (this.usesHoverView()) {
            this.hoverStateTracker = new DefaultHoverTracker(this.component, false){

                @Override
                public void hoverChanged(boolean hover) {
                    AbstractDecorationPainter.this.hoverChanged(hover);
                }
            };
            HoverManager.addHoverTracker(this.component, this.hoverStateTracker);
            this.hover = this.hoverStateTracker.isHovered();
        } else {
            this.hover = false;
        }
    }

    protected void hoverChanged(boolean hover) {
        if (this.component != null) {
            this.hover = hover;
            this.updateDecorationState();
        }
    }

    protected boolean isHover() {
        return this.hover;
    }

    protected void uninstallHoverListeners() {
        if (this.hoverStateTracker != null) {
            HoverManager.removeHoverTracker(this.component, this.hoverStateTracker);
            this.hoverStateTracker = null;
            this.hover = false;
        }
    }

    protected void updateHoverListeners() {
        if (this.usesHoverView()) {
            this.installHoverListeners();
        } else {
            this.uninstallHoverListeners();
        }
    }

    protected boolean usesInHoveredParentView() {
        return this.usesState("in-hovered-parent");
    }

    protected void installInHoveredParentListeners() {
        if (this.usesInHoveredParentView()) {
            this.inHoveredParent = this.updateInHoveredParent();
            this.inHoveredParentTracker = new GlobalHoverListener(){

                @Override
                public void hoverChanged(@Nullable Component oldHover, @Nullable Component newHover) {
                    AbstractDecorationPainter.this.updateInHoveredParent();
                }
            };
            HoverManager.registerGlobalHoverListener(this.component, this.inHoveredParentTracker);
            this.inHoveredParentAncestorListener = new AncestorListener(){

                @Override
                public void ancestorAdded(@NotNull AncestorEvent event) {
                    AbstractDecorationPainter.this.updateInHoveredParent();
                }

                @Override
                public void ancestorRemoved(@NotNull AncestorEvent event) {
                    AbstractDecorationPainter.this.updateInHoveredParent();
                }

                @Override
                public void ancestorMoved(@NotNull AncestorEvent event) {
                    AbstractDecorationPainter.this.updateInHoveredParent();
                }
            };
            this.component.addAncestorListener(this.inHoveredParentAncestorListener);
        } else {
            this.inHoveredParent = false;
        }
    }

    protected boolean updateInHoveredParent() {
        if (this.component != null) {
            boolean old = this.inHoveredParent;
            this.inHoveredParent = false;
            for (Container current = this.component; current != null; current = current.getParent()) {
                AbstractDecorationPainter dp;
                Painter painter;
                if (current == HoverManager.getHoverOwner()) {
                    this.inHoveredParent = true;
                    break;
                }
                if (current == this.component || (painter = PainterSupport.getPainter(current)) == null || !(painter instanceof AbstractDecorationPainter) || !(dp = (AbstractDecorationPainter)painter).usesHoverView()) continue;
                this.inHoveredParent = dp.isHover();
                break;
            }
            if (Objects.notEquals((Object)old, (Object)this.inHoveredParent)) {
                this.updateDecorationState();
            }
        }
        return this.inHoveredParent;
    }

    protected boolean isInHoveredParent() {
        return this.inHoveredParent;
    }

    protected void uninstallInHoveredParentListeners() {
        if (this.inHoveredParentTracker != null) {
            this.component.removeAncestorListener(this.inHoveredParentAncestorListener);
            this.inHoveredParentAncestorListener = null;
            HoverManager.unregisterGlobalHoverListener(this.component, this.inHoveredParentTracker);
            this.inHoveredParentTracker = null;
            this.inHoveredParent = false;
        }
    }

    protected boolean usesHierarchyBasedView() {
        return true;
    }

    protected void installBorderListeners() {
        if (this.usesHierarchyBasedView()) {
            this.neighboursTracker = new ContainerListener(){

                @Override
                public void componentAdded(@NotNull ContainerEvent event) {
                    if (AbstractDecorationPainter.this.component != null && AbstractDecorationPainter.this.ancestor != null && AbstractDecorationPainter.this.ancestor.getLayout() instanceof GroupingLayout && event.getChild() != AbstractDecorationPainter.this.component) {
                        AbstractDecorationPainter.this.updateBorder();
                    }
                }

                @Override
                public void componentRemoved(@NotNull ContainerEvent event) {
                    if (AbstractDecorationPainter.this.component != null && AbstractDecorationPainter.this.ancestor != null && AbstractDecorationPainter.this.ancestor.getLayout() instanceof GroupingLayout && event.getChild() != AbstractDecorationPainter.this.component) {
                        AbstractDecorationPainter.this.updateBorder();
                    }
                }
            };
            this.hierarchyTracker = new HierarchyListener(){

                @Override
                public void hierarchyChanged(@NotNull HierarchyEvent event) {
                    AbstractDecorationPainter.this.hierarchyChanged(event);
                }
            };
            this.component.addHierarchyListener(this.hierarchyTracker);
        } else {
            this.ancestor = null;
        }
    }

    protected void hierarchyChanged(@NotNull HierarchyEvent event) {
        if (this.component != null && (event.getChangeFlags() & 1L) == 1L) {
            if (this.ancestor != null) {
                this.ancestor.removeContainerListener(this.neighboursTracker);
            }
            this.ancestor = this.component.getParent();
            if (this.ancestor != null) {
                this.ancestor.addContainerListener(this.neighboursTracker);
                this.updateBorder();
            }
        }
    }

    protected void uninstallBorderListeners() {
        if (this.hierarchyTracker != null) {
            this.component.removeHierarchyListener(this.hierarchyTracker);
            this.hierarchyTracker = null;
            if (this.ancestor != null) {
                this.ancestor.removeContainerListener(this.neighboursTracker);
                this.ancestor = null;
            }
            this.neighboursTracker = null;
        }
    }

    protected boolean isEnabled() {
        return this.component != null && this.component.isEnabled();
    }

    @NotNull
    protected final List<String> collectDecorationStates() {
        List<String> states = this.getDecorationStates();
        states.addAll(DecorationUtils.getExtraStates(StyleManager.getSkin(this.component)));
        states.addAll(DecorationUtils.getExtraStates(this.ui));
        states.addAll(DecorationUtils.getExtraStates(this.component));
        Collections.sort(states);
        return states;
    }

    @Override
    @NotNull
    public List<String> getDecorationStates() {
        ArrayList<String> states = new ArrayList<String>(12);
        states.add(SystemUtils.getShortOsName());
        states.add(this.isEnabled() ? "enabled" : "disabled");
        states.add(this.ltr ? "ltr" : "rtl");
        states.add(this.component.getComponentCount() > 0 ? "has-children" : "has-no-children");
        if (this.isFocused()) {
            states.add("focused");
        }
        if (this.isInFocusedParent()) {
            states.add("in-focused-parent");
        }
        if (this.isHover()) {
            states.add("hover");
        }
        if (this.isInHoveredParent()) {
            states.add("in-hovered-parent");
        }
        return states;
    }

    @Override
    public final boolean usesState(@NotNull String state) {
        List sectionPainters;
        boolean usesState = this.usesState(this.decorations, state);
        if (!usesState && CollectionUtils.notEmpty(sectionPainters = this.getInstalledSectionPainters())) {
            for (SectionPainter section : sectionPainters) {
                if (!(section instanceof IDecorationPainter) || !((IDecorationPainter)((Object)section)).usesState(state)) continue;
                usesState = true;
                break;
            }
        }
        return usesState;
    }

    protected final boolean usesState(@Nullable Decorations<C, D> decorations, String state) {
        boolean usesState = false;
        if (decorations != null && decorations.size() > 0) {
            for (IDecoration decoration : decorations) {
                if (!decoration.usesState(state)) continue;
                usesState = true;
                break;
            }
        }
        return usesState;
    }

    @NotNull
    protected final List<D> getDecorations(@NotNull List<String> forStates) {
        ArrayList<IDecoration> result = new ArrayList<IDecoration>();
        if (this.decorations != null && this.decorations.size() > 0) {
            for (IDecoration decoration : this.decorations) {
                if (!decoration.isApplicableTo(forStates)) continue;
                result.add(decoration);
            }
        }
        return result;
    }

    @Override
    @Nullable
    public final D getDecoration() {
        IDecoration result;
        if (this.decorations != null && this.decorations.size() > 0) {
            IDecoration currentDecoration;
            IDecoration previousDecoration;
            String previous = this.current;
            this.current = TextUtils.listToString(this.states, (String)",");
            if (this.stateDecorationCache == null) {
                this.stateDecorationCache = new HashMap<String, D>(this.decorations.size());
                this.decorationCache = new HashMap<String, D>(this.decorations.size());
            }
            if (!this.stateDecorationCache.containsKey(this.current)) {
                IDecoration decoration;
                List<D> decorations = this.getDecorations(this.states);
                String decorationsKey = this.getDecorationsKey(decorations);
                if (this.decorationCache.containsKey(decorationsKey)) {
                    decoration = (IDecoration)this.decorationCache.get(decorationsKey);
                } else {
                    if (CollectionUtils.isEmpty(decorations)) {
                        decoration = null;
                    } else if (decorations.size() == 1) {
                        decoration = (IDecoration)Clone.deep().nonNullClone(decorations.get(0));
                    } else {
                        Class<?> type = ((IDecoration)decorations.get(decorations.size() - 1)).getClass();
                        Iterator<D> iterator = decorations.iterator();
                        while (iterator.hasNext()) {
                            IDecoration d = (IDecoration)iterator.next();
                            if (d.getClass() == type) continue;
                            iterator.remove();
                        }
                        decoration = (IDecoration)Merge.deep().nonNullMerge(decorations);
                    }
                    if (decoration != null) {
                        decoration.setSection(this.isSectionPainter());
                    }
                    this.decorationCache.put(decorationsKey, decoration);
                }
                this.stateDecorationCache.put(this.current, decoration);
            }
            if (previous == null && this.current == null) {
                IDecoration initialDecoration = (IDecoration)this.stateDecorationCache.get(this.current);
                if (initialDecoration != null) {
                    initialDecoration.activate(this.component);
                }
            } else if (Objects.notEquals((Object)previous, (Object)this.current) && (previousDecoration = (IDecoration)this.stateDecorationCache.get(previous)) != (currentDecoration = (IDecoration)this.stateDecorationCache.get(this.current))) {
                if (previousDecoration != null) {
                    previousDecoration.deactivate(this.component);
                }
                if (currentDecoration != null) {
                    currentDecoration.activate(this.component);
                }
            }
            result = (IDecoration)this.stateDecorationCache.get(this.current);
        } else {
            result = null;
        }
        return (D)result;
    }

    @NotNull
    protected final String getDecorationsKey(@NotNull List<D> decorations) {
        StringBuilder key = new StringBuilder(15 * decorations.size());
        for (IDecoration decoration : decorations) {
            if (key.length() > 0) {
                key.append(";");
            }
            key.append(decoration.getId());
        }
        return key.toString();
    }

    protected final void deactivateLastDecoration(@NotNull C c) {
        D decoration = this.getDecoration();
        if (decoration != null) {
            decoration.deactivate(c);
        }
    }

    @Override
    public final void updateDecorationState() {
        List<String> states = this.collectDecorationStates();
        if (!CollectionUtils.equals(this.states, states, (boolean)true)) {
            this.states = states;
            List sectionPainters = this.getInstalledSectionPainters();
            if (CollectionUtils.notEmpty(sectionPainters)) {
                for (SectionPainter section : sectionPainters) {
                    if (!(section instanceof IDecorationPainter)) continue;
                    ((IDecorationPainter)((Object)section)).updateDecorationState();
                }
            }
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    @Nullable
    protected Insets getBorder() {
        D decoration = this.getDecoration();
        Insets insets = decoration != null && this.isDecorationAvailable(decoration) ? decoration.getBorderInsets((JComponent)this.component) : null;
        return insets;
    }

    @Override
    @NotNull
    public Shape provideShape(@NotNull C component, @NotNull Rectangle bounds) {
        D decoration = this.getDecoration();
        Shape shape = decoration != null && this.isDecorationAvailable(decoration) ? decoration.provideShape(component, bounds) : bounds;
        return shape;
    }

    @Override
    @Nullable
    public Boolean isOpaque() {
        D decoration = this.getDecoration();
        Boolean opaque = decoration != null && this.isDecorationAvailable(decoration) ? this.isOpaqueDecorated() : this.isOpaqueUndecorated();
        return opaque;
    }

    protected Boolean isOpaqueDecorated() {
        return false;
    }

    protected Boolean isOpaqueUndecorated() {
        return null;
    }

    @Override
    public boolean contains(@NotNull C c, @NotNull U ui, @NotNull Bounds bounds, int x, int y) {
        boolean contains;
        D decoration = this.getDecoration();
        if (decoration != null && this.isDecorationAvailable(decoration)) {
            Bounds marginBounds = new Bounds(bounds, BoundsType.margin, (JComponent)c, (IDecoration)decoration);
            contains = decoration.contains(c, marginBounds, x, y);
        } else {
            contains = super.contains(c, ui, bounds, x, y);
        }
        return contains;
    }

    @Override
    public int getBaseline(@NotNull C c, @NotNull U ui, @NotNull Bounds bounds) {
        int baseline;
        D decoration = this.getDecoration();
        if (decoration != null && this.isDecorationAvailable(decoration)) {
            Bounds marginBounds = new Bounds(bounds, BoundsType.margin, (JComponent)c, (IDecoration)decoration);
            baseline = decoration.getBaseline(c, marginBounds);
        } else {
            baseline = super.getBaseline(c, ui, bounds);
        }
        return baseline;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull C c, @NotNull U ui) {
        D decoration = this.getDecoration();
        Component.BaselineResizeBehavior behavior = decoration != null && this.isDecorationAvailable(decoration) ? decoration.getBaselineResizeBehavior(c) : super.getBaselineResizeBehavior(c, ui);
        return behavior;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Bounds bounds) {
        D decoration;
        if (this.isPlainBackgroundRequired(c)) {
            g2d.setPaint(((Component)c).getBackground());
            g2d.fill(bounds.get());
        }
        if ((decoration = this.getDecoration()) != null && this.isDecorationAvailable(decoration)) {
            Bounds marginBounds = new Bounds(bounds, BoundsType.margin, (JComponent)c, (IDecoration)decoration);
            decoration.paint(g2d, c, marginBounds);
        }
        this.paintContent(g2d, c, ui, bounds.get());
    }

    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Rectangle bounds) {
    }

    protected boolean isPlainBackgroundRequired(@NotNull C c) {
        return ((JComponent)c).isOpaque();
    }

    protected boolean isDecorationAvailable(@NotNull D decoration) {
        return true;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        D d = this.getDecoration();
        return d != null ? SwingUtils.maxNonNull(d.getPreferredSize((JComponent)this.component), ps) : ps;
    }
}

